/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util.exif;

import net.coobird.thumbnailator.util.exif.IfdType;

public class IfdStructure {
    private final int tag;
    private final IfdType type;
    private final int count;
    private final int offsetValue;

    public IfdStructure(int n, int n2, int n3, int n4) {
        this.tag = n;
        this.type = IfdType.typeOf(n2);
        this.count = n3;
        this.offsetValue = n4;
    }

    public int getTag() {
        return this.tag;
    }

    public IfdType getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public int getOffsetValue() {
        return this.offsetValue;
    }

    public boolean isValue() {
        return this.type.size() * this.count <= 4;
    }

    public boolean isOffset() {
        return !this.isValue();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.count;
        n = 31 * n + this.offsetValue;
        n = 31 * n + this.tag;
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IfdStructure ifdStructure = (IfdStructure)object;
        if (this.count != ifdStructure.count) {
            return false;
        }
        if (this.offsetValue != ifdStructure.offsetValue) {
            return false;
        }
        if (this.tag != ifdStructure.tag) {
            return false;
        }
        return this.type == ifdStructure.type;
    }

    public String toString() {
        return "IfdStructure [tag=" + Integer.toHexString(this.tag) + ", type=" + (Object)((Object)this.type) + ", count=" + this.count + ", offsetValue=" + this.offsetValue + "]";
    }
}

