/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.ThumbnailTask;
import net.coobird.thumbnailator.tasks.io.ImageSink;
import net.coobird.thumbnailator.tasks.io.ImageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSinkThumbnailTask<S, D>
extends ThumbnailTask<S, D> {
    private final ImageSource<S> source;
    private final ImageSink<D> destination;

    public SourceSinkThumbnailTask(ThumbnailParameter thumbnailParameter, ImageSource<S> imageSource, ImageSink<D> imageSink) {
        super(thumbnailParameter);
        if (imageSource == null) {
            throw new NullPointerException("ImageSource cannot be null.");
        }
        if (imageSink == null) {
            throw new NullPointerException("ImageSink cannot be null.");
        }
        imageSource.setThumbnailParameter(thumbnailParameter);
        this.source = imageSource;
        imageSink.setThumbnailParameter(thumbnailParameter);
        this.destination = imageSink;
    }

    @Override
    public BufferedImage read() throws IOException {
        BufferedImage bufferedImage = this.source.read();
        this.inputFormatName = this.source.getInputFormatName();
        return bufferedImage;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        String string = this.param.getOutputFormat();
        String string2 = null;
        if ("\u0000".equals(string)) {
            string = this.destination.preferredOutputFormatName();
        }
        string2 = string == ThumbnailParameter.ORIGINAL_FORMAT ? this.inputFormatName : string;
        this.destination.setOutputFormatName(string2);
        this.destination.write(bufferedImage);
    }

    @Override
    public S getSource() {
        return this.source.getSource();
    }

    @Override
    public D getDestination() {
        return this.destination.getSink();
    }
}

