/*
 * Decompiled with CFR 0.152.
 */
package net.codebox.readableregex;

import java.util.regex.Pattern;
import net.codebox.readableregex.CharacterTokenPart;
import net.codebox.readableregex.Quantifier;
import net.codebox.readableregex.RegExBuilder;
import net.codebox.readableregex.Utils;

public class Token {
    private Quantifier quantifier;
    private boolean requiresBrackets;
    private String tokenString;
    private static char[] SPECIAL_CHARS = new char[]{'\\', '[', '^', '$', '.', '|', '?', '*', '+', '(', ')', '{', '}'};
    private static final Pattern OCTAL_PATTERN = Pattern.compile("([0-7]|[0-7][0-7]|[0-2][0-7][0-7])");
    private static final Pattern HEX_PATTERN = Pattern.compile("[a-fA-F0-9]{2}([a-fA-F0-9]{2})?");
    private static final Pattern UNICODE_PATTERN = Pattern.compile("[a-fA-F0-9]{4}");

    protected Token(String tokenString, boolean requiresBrackets, Quantifier quantifier) {
        this.tokenString = tokenString;
        this.requiresBrackets = requiresBrackets;
        this.quantifier = quantifier;
    }

    protected Token(Token token, Quantifier quantifier) {
        this.tokenString = token.tokenString;
        this.requiresBrackets = token.requiresBrackets;
        this.quantifier = quantifier;
    }

    public final String toString() {
        if (this.quantifier == null) {
            return this.tokenString;
        }
        if (this.requiresBrackets) {
            return "(" + this.tokenString + ")" + this.quantifier.toString();
        }
        return this.tokenString + this.quantifier.toString();
    }

    public static Token groupOf(Token ... tokens) {
        return new Token("(" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token nonCapturingGroup(Token ... tokens) {
        return new Token("(?:" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token independentNonCapturingGroup(Token ... tokens) {
        return new Token("(?>" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token positiveLookAhead(Token ... tokens) {
        return new Token("(?=" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token negativeLookAhead(Token ... tokens) {
        return new Token("(?!" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token positiveLookBehind(Token ... tokens) {
        return new Token("(?<=" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token negativeLookBehind(Token ... tokens) {
        return new Token("(?<!" + RegExBuilder.build(tokens) + ")", false, null);
    }

    public static Token group(int groupNumber) {
        return new Token("\\" + groupNumber, false, null);
    }

    public static Token anything() {
        return new Token(".*", false, null);
    }

    public static Token octalCharacter(String octalNumber) {
        if (!OCTAL_PATTERN.matcher(octalNumber).matches()) {
            throw new IllegalArgumentException("Bad octal value");
        }
        return new Token("\\0" + octalNumber, false, null);
    }

    public static Token hexCharacter(String hexNumber) {
        if (!HEX_PATTERN.matcher(hexNumber).matches()) {
            throw new IllegalArgumentException("Bad hex value");
        }
        return new Token("\\x" + hexNumber.toUpperCase(), false, null);
    }

    public static Token unicodeCharacter(String unicodeNumber) {
        if (!UNICODE_PATTERN.matcher(unicodeNumber).matches()) {
            throw new IllegalArgumentException("Bad unicode value");
        }
        return new Token("\\u" + unicodeNumber.toUpperCase(), false, null);
    }

    public static Token tab() {
        return new Token("\\t", false, null);
    }

    public static Token newline() {
        return new Token("\\n", false, null);
    }

    public static Token carriageReturn() {
        return new Token("\\r", false, null);
    }

    public static Token formFeed() {
        return new Token("\\f", false, null);
    }

    public static Token alertCharacter() {
        return new Token("\\a", false, null);
    }

    public static Token escapeCharacter() {
        return new Token("\\e", false, null);
    }

    public static Token controlCharacter(char character) {
        if (!Character.isLetter(character)) {
            throw new IllegalArgumentException("Only letters are permitted for control characters");
        }
        char upperCaseLetter = Character.toUpperCase(character);
        return new Token("\\c" + upperCaseLetter, false, null);
    }

    public static Token anyDigit() {
        return Token.anyOneOf(CharacterTokenPart.range('0', '9'));
    }

    public static Token anyLetter() {
        return Token.anyOneOf(CharacterTokenPart.range('a', 'z'), CharacterTokenPart.range('A', 'Z'));
    }

    public static Token text(String text) {
        return new Token(Utils.escapeSpecial(text, SPECIAL_CHARS), text.length() > 1, null);
    }

    public static Token anyCharacterExcept(CharacterTokenPart ... characterTokens) {
        Token.setFirstAndLastParts(characterTokens);
        String txt = Utils.appendObjects(characterTokens);
        String tokenString = "[^" + txt + "]";
        return new Token(tokenString, false, null);
    }

    public static Token anyOneOf(CharacterTokenPart ... characterTokens) {
        Token.setFirstAndLastParts(characterTokens);
        String txt = Utils.appendObjects(characterTokens);
        String tokenString = "[" + txt + "]";
        return new Token(tokenString, false, null);
    }

    private static void setFirstAndLastParts(CharacterTokenPart ... characterTokens) {
        int count = characterTokens.length;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                characterTokens[i] = characterTokens[i].copyAndSetFirstPartInToken();
            }
            if (i != count - 1) continue;
            characterTokens[i] = characterTokens[i].copyAndSetLastPartInToken();
        }
    }

    public static Token or(Token ... tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(token.toString());
        }
        boolean requiresBrackets = tokens.length > 1 ? true : tokens[0].requiresBrackets;
        return new Token(sb.toString(), requiresBrackets, null);
    }

    public static Token oneOf(Token ... tokens) {
        return Token.or(tokens);
    }
}

