/*
 * Decompiled with CFR 0.152.
 */
package net.codebox.readableregex;

import net.codebox.readableregex.Utils;

public abstract class CharacterTokenPart {
    protected final boolean isFirstPartInToken;
    protected final boolean isLastPartInToken;

    protected CharacterTokenPart(boolean isFirstPartInToken, boolean isLastPartInToken) {
        this.isFirstPartInToken = isFirstPartInToken;
        this.isLastPartInToken = isLastPartInToken;
    }

    protected abstract CharacterTokenPart copyAndSetFirstPartInToken();

    protected abstract CharacterTokenPart copyAndSetLastPartInToken();

    public static CharacterTokenPart characters(Character ... characters) {
        return new SimpleCharacterTokenPart(characters, false, false);
    }

    public static CharacterTokenPart range(char from, char to) {
        return new RangeCharacterTokenPart(from, to, false, false);
    }

    private static String escapeCharacter(char c, boolean isFirstCharInToken, boolean isLastCharInToken) {
        char[] specialCharacters = isFirstCharInToken ? new char[]{'\\', ']', '^'} : new char[]{'\\', ']', '-'};
        return Utils.escapeSpecial(c, specialCharacters);
    }

    private static class RangeCharacterTokenPart
    extends CharacterTokenPart {
        private char from;
        private char to;

        protected RangeCharacterTokenPart(char from, char to, boolean isFirstPartInToken, boolean isLastPartInToken) {
            super(isFirstPartInToken, isLastPartInToken);
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return CharacterTokenPart.escapeCharacter(this.from, this.isFirstPartInToken, false) + "-" + CharacterTokenPart.escapeCharacter(this.to, false, this.isLastPartInToken);
        }

        @Override
        protected CharacterTokenPart copyAndSetFirstPartInToken() {
            return new RangeCharacterTokenPart(this.from, this.to, true, this.isLastPartInToken);
        }

        @Override
        protected CharacterTokenPart copyAndSetLastPartInToken() {
            return new RangeCharacterTokenPart(this.from, this.to, this.isFirstPartInToken, true);
        }
    }

    private static class SimpleCharacterTokenPart
    extends CharacterTokenPart {
        private final Character[] characters;

        protected SimpleCharacterTokenPart(Character[] characters, boolean isFirstPartInToken, boolean isLastPartInToken) {
            super(isFirstPartInToken, isLastPartInToken);
            this.characters = characters;
        }

        public String toString() {
            int charactersCount = this.characters.length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < charactersCount; ++i) {
                boolean isFirstCharInPart = i == 0;
                boolean isLastCharInPart = i == charactersCount - 1;
                boolean isFirstCharInToken = isFirstCharInPart && this.isFirstPartInToken;
                boolean isLastCharInToken = isLastCharInPart && this.isLastPartInToken;
                String escapedChar = CharacterTokenPart.escapeCharacter(this.characters[i].charValue(), isFirstCharInToken, isLastCharInToken);
                sb.append(escapedChar);
            }
            return sb.toString();
        }

        @Override
        protected CharacterTokenPart copyAndSetFirstPartInToken() {
            return new SimpleCharacterTokenPart(this.characters, true, this.isLastPartInToken);
        }

        @Override
        protected CharacterTokenPart copyAndSetLastPartInToken() {
            return new SimpleCharacterTokenPart(this.characters, this.isFirstPartInToken, true);
        }
    }
}

