/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.libretranslate.util;

import com.google.gson.Gson;
import lombok.NonNull;

public final class JsonUtil {
    private static final Gson gson = new Gson();

    public static String to(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return gson.toJson(object);
    }

    public static <T> T from(@NonNull String s, Class<T> tClass) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return (T)gson.fromJson(s, tClass);
    }

    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

