/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.libretranslate;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Scanner;
import lombok.NonNull;
import net.suuft.libretranslate.Language;
import net.suuft.libretranslate.exception.BadTranslatorResponseException;
import net.suuft.libretranslate.type.TranslateResponse;
import net.suuft.libretranslate.util.JsonUtil;

public final class Translator {
    private static String urlApi = "https://translate.fedilab.app/translate";

    public static String translate(@NonNull String from, @NonNull String to, @NonNull String request) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        try {
            URL url = new URL(urlApi);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("accept", "application/json");
            httpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
            writer.write("q=" + URLEncoder.encode(request, "UTF-8") + "&source=" + from + "&target=" + to + "&format=text");
            writer.flush();
            writer.close();
            httpConn.getOutputStream().close();
            if (httpConn.getResponseCode() / 100 != 2) {
                throw new BadTranslatorResponseException(httpConn.getResponseCode(), urlApi);
            }
            InputStream responseStream = httpConn.getInputStream();
            Scanner s = new Scanner(responseStream).useDelimiter("\\A");
            String response = s.hasNext() ? s.next() : "";
            return JsonUtil.from(response, TranslateResponse.class).getTranslatedText();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String translate(@NonNull Language from, @NonNull Language to, @NonNull String request) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (to == Language.NONE || from == to) {
            return request;
        }
        return Translator.translate(from.getCode(), to.getCode(), request);
    }

    public static String translate(@NonNull Language to, @NonNull String request) {
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (to == Language.NONE) {
            return request;
        }
        return Translator.translate("auto", to.getCode(), request);
    }

    private Translator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setUrlApi(String urlApi) {
        Translator.urlApi = urlApi;
    }
}

