/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.utils;

import android.widget.AdapterView;
import android.widget.Spinner;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;

public class SpinnerUtils {
    public static boolean selectSpinnerValue(@NonNull Spinner spinner, Object value) {
        return SpinnerUtils.selectSpinnerValue(spinner, value, false);
    }

    public static boolean selectSpinnerValue(@NonNull Spinner spinner, Object value, boolean cancelListener) {
        if (value == null) {
            for (int i = 0; i < spinner.getCount(); ++i) {
                if (spinner.getItemAtPosition(i) != null) continue;
                SpinnerUtils.setSelection(spinner, i, cancelListener);
                return true;
            }
            return false;
        }
        for (int i = 0; i < spinner.getCount(); ++i) {
            if (!value.equals(spinner.getItemAtPosition(i))) continue;
            SpinnerUtils.setSelection(spinner, i, cancelListener);
            return true;
        }
        return false;
    }

    public static void setSelection(@NonNull Spinner spinner, int position, boolean cancelListener) {
        if (cancelListener) {
            AdapterView.OnItemSelectedListener listener = spinner.getOnItemSelectedListener();
            if (listener != null) {
                spinner.setOnItemSelectedListener(null);
            }
            spinner.setSelection(position, false);
            if (listener != null) {
                spinner.setOnItemSelectedListener(listener);
            }
        } else {
            spinner.setSelection(position);
        }
    }

    public static void dismissPopup(@NonNull Spinner spinner) {
        Object popup = null;
        for (Class<?> clazz = spinner.getClass(); popup == null && clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField("mPopup");
                field.setAccessible(true);
                popup = field.get(spinner);
                if (popup == null) continue;
                popup.getClass().getMethod("dismiss", new Class[0]).invoke(popup, new Object[0]);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

