/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.cattaka.android.adaptertoolbox.adapter.AbsCustomRecyclerAdapter;
import net.cattaka.android.adaptertoolbox.adapter.listener.ForwardingListener;
import net.cattaka.android.adaptertoolbox.adapter.listener.ListenerRelay;
import net.cattaka.android.adaptertoolbox.data.ITreeItem;

public abstract class AbsTreeItemAdapter<A extends AbsTreeItemAdapter<A, VH, T, W>, VH extends RecyclerView.ViewHolder, T extends ITreeItem<T>, W extends WrappedItem<W, T>>
extends AbsCustomRecyclerAdapter<A, VH, W, ForwardingListener<A, VH>> {
    private Context mContext;
    private List<W> mItems;
    private ListenerRelay<A, VH> mListenerRelay;

    @NonNull
    protected static <T extends ITreeItem<T>, W extends WrappedItem<W, T>, REF extends ITreeItemAdapterRef<?, ?, T, W>> List<W> inflateWrappedList(@NonNull List<W> dest, @NonNull List<T> items, int level, @Nullable W parent, @NonNull REF ref) {
        for (ITreeItem item : items) {
            W child = ref.createWrappedItem(level, (ITreeItem)item, parent);
            ((WrappedItem)child).setOpened(true);
            dest.add(child);
            if (parent != null) {
                parent.children.add(child);
            }
            if (item.getChildren() == null) continue;
            AbsTreeItemAdapter.inflateWrappedList(dest, item.getChildren(), level + 1, child, ref);
        }
        return dest;
    }

    public <REF extends ITreeItemAdapterRef<A, ?, T, W>> AbsTreeItemAdapter(@NonNull Context context, @NonNull List<T> items, @NonNull REF ref) {
        this.mContext = context;
        this.mItems = AbsTreeItemAdapter.inflateWrappedList(new ArrayList(), items, 0, null, ref);
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public int getItemCount() {
        return this.mItems.size();
    }

    @Override
    @NonNull
    public W getItemAt(int position) {
        return (W)((WrappedItem)this.mItems.get(position));
    }

    @Override
    @NonNull
    public List<W> getItems() {
        return this.mItems;
    }

    public void doOpen(W item, boolean opened) {
        if (((WrappedItem)item).isOpened() != opened) {
            ((WrappedItem)item).setOpened(opened);
            ArrayList children = new ArrayList();
            this.flattenChildren(children, item);
            if (opened) {
                int p = this.mItems.indexOf(item);
                this.mItems.addAll(p + 1, children);
                this.notifyItemRangeInserted(p + 1, children.size());
            } else {
                for (WrappedItem child : children) {
                    int p = this.mItems.indexOf(child);
                    if (p == -1) continue;
                    this.mItems.remove(p);
                    this.notifyItemRemoved(p);
                }
            }
        }
    }

    private void flattenChildren(List<W> dest, W item) {
        if (((WrappedItem)item).children != null) {
            for (WrappedItem child : ((WrappedItem)item).children) {
                dest.add(child);
                if (!child.isOpened()) continue;
                this.flattenChildren(dest, child);
            }
        }
    }

    public void setListenerRelay(@Nullable ListenerRelay<A, VH> listenerRelay) {
        this.mListenerRelay = listenerRelay;
    }

    @Override
    @NonNull
    public ForwardingListener<A, VH> createForwardingListener() {
        ForwardingListener<A, VH> forwardingListener = new ForwardingListener<A, VH>();
        if (this.mListenerRelay != null) {
            forwardingListener.setListenerRelay(this.mListenerRelay);
        }
        return forwardingListener;
    }

    public static interface ITreeItemAdapterRef<A extends AbsTreeItemAdapter<A, VH, T, W>, VH extends RecyclerView.ViewHolder, T extends ITreeItem<T>, W extends WrappedItem<W, T>>
    extends Serializable {
        @NonNull
        public Class<T> getItemClass();

        @NonNull
        public A createAdapter(@NonNull Context var1, @NonNull List<T> var2);

        @NonNull
        public W createWrappedItem(int var1, T var2, W var3);
    }

    public static class WrappedItem<W extends WrappedItem<W, T>, T extends ITreeItem<T>> {
        public final int level;
        public final T item;
        public final List<W> children = new ArrayList<W>();
        public final W parent;
        private boolean opened;

        public WrappedItem(int level, T item, @NonNull W parent) {
            this.level = level;
            this.item = item;
            this.parent = parent;
        }

        public T getItem() {
            return this.item;
        }

        public boolean isOpened() {
            return this.opened;
        }

        void setOpened(boolean opened) {
            this.opened = opened;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedItem that = (WrappedItem)o;
            return this.item != null ? this.item.equals(that.item) : that.item == null;
        }

        public int hashCode() {
            return this.item != null ? this.item.hashCode() : 0;
        }
    }
}

