/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cattaka.android.adaptertoolbox.adapter.IHasItemAdapter;
import net.cattaka.android.adaptertoolbox.adapter.listener.IForwardingListener;

public abstract class AbsScrambleAdapter<A extends AbsScrambleAdapter<A, SA, VH, FL, T>, SA extends AbsScrambleAdapter<?, SA, VH, ?, ?>, VH extends RecyclerView.ViewHolder, FL extends IForwardingListener<SA, VH>, T>
extends RecyclerView.Adapter<VH>
implements IHasItemAdapter<VH, T> {
    Map<View, IForwardingListener.IProvider<SA, VH>> mProviderMap = new HashMap<View, IForwardingListener.IProvider<SA, VH>>();
    IForwardingListener.IProvider<SA, VH> mNullProvider = new IForwardingListener.IProvider<SA, VH>(){

        @Override
        @NonNull
        public SA getAdapter() {
            return AbsScrambleAdapter.this.getSelf();
        }

        @Override
        @Nullable
        public RecyclerView getAttachedRecyclerView() {
            return null;
        }
    };
    List<IViewHolderFactory<SA, VH, FL, ? extends VH>> mViewHolderFactory;
    Map<Class<? extends RecyclerView.ViewHolder>, IViewHolderFactory<SA, VH, FL, ? extends VH>> mViewHolder2FactoryMap;
    Map<View, SparseArray<FL>> mForwardingListenersMap = new HashMap<View, SparseArray<FL>>();

    public AbsScrambleAdapter(@NonNull List<? extends IViewHolderFactory<SA, VH, FL, ?>> viewHolderFactories) {
        this.mViewHolderFactory = new ArrayList<IViewHolderFactory<SA, VH, FL, ? extends VH>>();
        this.mViewHolder2FactoryMap = new HashMap<Class<? extends RecyclerView.ViewHolder>, IViewHolderFactory<SA, VH, FL, ? extends VH>>();
        this.mViewHolderFactory.addAll(viewHolderFactories);
        NullViewHolderFactory nvhf = new NullViewHolderFactory(this);
        this.mViewHolderFactory.add(nvhf);
    }

    @Override
    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        Object forwardingListener;
        IViewHolderFactory<SA, VH, Object, VH> viewHolderFactory = this.mViewHolderFactory.get(viewType);
        SparseArray forwardingListeners = this.mForwardingListenersMap.get(parent);
        if (forwardingListeners == null) {
            forwardingListeners = new SparseArray();
            this.mForwardingListenersMap.put((View)parent, forwardingListeners);
        }
        if (forwardingListeners.indexOfKey(viewType) < 0) {
            forwardingListener = this.createForwardingListener(viewHolderFactory);
            if (forwardingListener != null) {
                forwardingListener.setProvider(this.getProvider((View)parent));
            }
            forwardingListeners.put(viewType, forwardingListener);
        } else {
            forwardingListener = (IForwardingListener)forwardingListeners.get(viewType);
        }
        VH holder = viewHolderFactory.onCreateViewHolder(this.getSelf(), parent, forwardingListener);
        this.mViewHolder2FactoryMap.put(holder.getClass(), viewHolderFactory);
        return holder;
    }

    @Override
    public void onBindViewHolder(VH holder, int position) {
        int viewType = this.getItemViewType(position);
        IViewHolderFactory<SA, VH, FL, ? extends VH> viewHolderFactory = this.mViewHolderFactory.get(viewType);
        this.onBindViewHolderInner(viewHolderFactory, holder, position);
    }

    public void onBindViewHolder(VH holder, int position, List<Object> payloads) {
        int viewType = this.getItemViewType(position);
        IViewHolderFactory<SA, VH, FL, ? extends VH> viewHolderFactory = this.mViewHolderFactory.get(viewType);
        this.onBindViewHolderInner(viewHolderFactory, holder, position, payloads);
    }

    public void onViewRecycled(VH holder) {
        IViewHolderFactory<SA, VH, FL, VH> viewHolderFactory = this.mViewHolder2FactoryMap.get(holder.getClass());
        if (viewHolderFactory != null) {
            viewHolderFactory.onViewRecycled(this.getSelf(), holder);
        }
    }

    public void onViewDetachedFromWindow(VH holder) {
        IViewHolderFactory<SA, VH, FL, VH> viewHolderFactory = this.mViewHolder2FactoryMap.get(holder.getClass());
        if (viewHolderFactory != null) {
            viewHolderFactory.onViewDetachedFromWindow(this.getSelf(), holder);
        }
    }

    public void onViewAttachedToWindow(VH holder) {
        IViewHolderFactory<SA, VH, FL, VH> viewHolderFactory = this.mViewHolder2FactoryMap.get(holder.getClass());
        if (viewHolderFactory != null) {
            viewHolderFactory.onViewAttachedToWindow(this.getSelf(), holder);
        }
    }

    public boolean onFailedToRecycleView(VH holder) {
        IViewHolderFactory<SA, VH, FL, VH> viewHolderFactory = this.mViewHolder2FactoryMap.get(holder.getClass());
        if (viewHolderFactory != null) {
            return viewHolderFactory.onFailedToRecycleView(this.getSelf(), holder);
        }
        return super.onFailedToRecycleView(holder);
    }

    private <EVH extends VH> void onBindViewHolderInner(IViewHolderFactory<SA, VH, FL, EVH> viewHolderFactory, VH holder, int position) {
        T object = this.getItemAt(position);
        viewHolderFactory.onBindViewHolder(this.getSelf(), holder, position, object);
    }

    private <EVH extends VH> void onBindViewHolderInner(IViewHolderFactory<SA, VH, FL, EVH> viewHolderFactory, VH holder, int position, List<Object> payloads) {
        T object = this.getItemAt(position);
        viewHolderFactory.onBindViewHolder(this.getSelf(), holder, position, object, payloads);
    }

    @Override
    public int getItemViewType(int position) {
        T object = this.getItemAt(position);
        int index = 0;
        for (IViewHolderFactory<SA, VH, FL, VH> viewHolderFactory : this.mViewHolderFactory) {
            if (viewHolderFactory.isAssignable(this.getSelf(), object)) {
                return index;
            }
            ++index;
        }
        return this.mViewHolderFactory.size() - 1;
    }

    @Nullable
    public IViewHolderFactory<SA, VH, FL, ?> getViewHolderFactory(int itemViewType) {
        return this.mViewHolderFactory.get(itemViewType);
    }

    @Nullable
    public IViewHolderFactory<SA, VH, FL, ?> getViewHolderFactoryByPosition(int position) {
        int viewType = this.getItemViewType(position);
        return this.mViewHolderFactory.get(viewType);
    }

    @Override
    public abstract T getItemAt(int var1);

    public void onAttachedToRecyclerView(final RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mProviderMap.put((View)recyclerView, new IForwardingListener.IProvider<SA, VH>(){

            @Override
            @NonNull
            public SA getAdapter() {
                return AbsScrambleAdapter.this.getSelf();
            }

            @Override
            @Nullable
            public RecyclerView getAttachedRecyclerView() {
                return recyclerView;
            }
        });
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mProviderMap.remove(recyclerView);
        this.mForwardingListenersMap.remove(recyclerView);
    }

    protected IForwardingListener.IProvider<SA, VH> getProvider(View parent) {
        IForwardingListener.IProvider<SA, VH> provider = this.mProviderMap.get(parent);
        return provider != null ? provider : this.mNullProvider;
    }

    @NonNull
    public SA getSelf() {
        return (SA)this;
    }

    @Override
    public int getViewTypeCount() {
        return this.mViewHolderFactory.size();
    }

    @Nullable
    public abstract FL createForwardingListener(@NonNull IViewHolderFactory<SA, VH, FL, ?> var1);

    @NonNull
    public abstract VH createNullViewHolder();

    public static class NullViewHolderFactory<SA extends AbsScrambleAdapter<?, SA, VH, ?, ?>, VH extends RecyclerView.ViewHolder, FL extends IForwardingListener<SA, VH>>
    implements IViewHolderFactory<SA, VH, FL, VH> {
        SA mAdapter;

        public NullViewHolderFactory(@NonNull SA adapter) {
            this.mAdapter = adapter;
        }

        @Override
        @NonNull
        public VH onCreateViewHolder(@NonNull SA adapter, @NonNull ViewGroup parent, @NonNull FL forwardingListener) {
            return ((AbsScrambleAdapter)this.mAdapter).createNullViewHolder();
        }

        @Override
        public void onBindViewHolder(@NonNull SA adapter, @NonNull VH holder, int position, @Nullable Object object) {
        }

        @Override
        public void onBindViewHolder(@NonNull SA adapter, @NonNull VH holder, int position, @Nullable Object object, List<Object> payloads) {
            this.onBindViewHolder(adapter, holder, position, object);
        }

        @Override
        public boolean isAssignable(@NonNull SA adapter, @Nullable Object object) {
            return true;
        }

        @Override
        @Nullable
        public FL createForwardingListener() {
            return null;
        }

        @Override
        public void onViewRecycled(@NonNull SA adapter, @NonNull VH holder) {
        }

        @Override
        public void onViewDetachedFromWindow(@NonNull SA adapter, @NonNull VH holder) {
        }

        @Override
        public void onViewAttachedToWindow(@NonNull SA adapter, @NonNull VH holder) {
        }

        @Override
        public boolean onFailedToRecycleView(@NonNull SA adapter, @NonNull VH holder) {
            return false;
        }
    }

    public static interface IViewHolderFactory<SA extends AbsScrambleAdapter<?, SA, VH, ?, ?>, VH extends RecyclerView.ViewHolder, FL extends IForwardingListener<SA, VH>, EVH extends VH> {
        @NonNull
        public EVH onCreateViewHolder(@NonNull SA var1, @NonNull ViewGroup var2, @NonNull FL var3);

        public void onBindViewHolder(@NonNull SA var1, @NonNull EVH var2, int var3, @Nullable Object var4);

        public void onBindViewHolder(@NonNull SA var1, @NonNull EVH var2, int var3, @Nullable Object var4, List<Object> var5);

        public boolean isAssignable(@NonNull SA var1, @Nullable Object var2);

        @Nullable
        public FL createForwardingListener();

        public boolean onFailedToRecycleView(@NonNull SA var1, @NonNull VH var2);

        public void onViewAttachedToWindow(@NonNull SA var1, @NonNull VH var2);

        public void onViewDetachedFromWindow(@NonNull SA var1, @NonNull VH var2);

        public void onViewRecycled(@NonNull SA var1, @NonNull VH var2);
    }
}

