/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.classic;

import android.database.DataSetObserver;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.HashMap;
import java.util.Map;
import net.cattaka.android.adaptertoolbox.R;
import net.cattaka.android.adaptertoolbox.adapter.IHasItemAdapter;

public class AdapterConverter<S extends IHasItemAdapter<VH, T>, VH extends RecyclerView.ViewHolder, T>
extends BaseAdapter {
    @IdRes
    public static int VIEW_HOLDER = R.id.viewholder;
    private S mOrig;
    private boolean mRecyclingDisabled = false;
    private Map<DataSetObserver, AdapterDataObserver> mAdapterDataObservers = new HashMap<DataSetObserver, AdapterDataObserver>();

    public void setOriginal(S orig) {
        this.mOrig = orig;
    }

    @NonNull
    public S getOrig() {
        return this.mOrig;
    }

    public int getCount() {
        return this.mOrig.getItemCount();
    }

    public T getItem(int i) {
        return this.mOrig.getItemAt(i);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return this.mRecyclingDisabled ? 1 : this.mOrig.getItemViewType(position);
    }

    public int getViewTypeCount() {
        return this.mRecyclingDisabled ? 1 : this.mOrig.getViewTypeCount();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolderWrapper vhw;
        int itemViewType = this.mOrig.getItemViewType(position);
        ViewHolderWrapper viewHolderWrapper = vhw = convertView != null ? (ViewHolderWrapper)AdapterConverter.findViewHolder(convertView) : null;
        if (vhw == null || vhw.getItemViewType() != itemViewType) {
            vhw = new ViewHolderWrapper(this.mOrig.onCreateViewHolder(parent, itemViewType));
            ((RecyclerView.ViewHolder)vhw.getOrig()).itemView.setTag(VIEW_HOLDER, vhw);
        }
        vhw.setPosition(position);
        vhw.setItemViewType(itemViewType);
        this.mOrig.onBindViewHolder(vhw.getOrig(), position);
        return ((RecyclerView.ViewHolder)vhw.getOrig()).itemView;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        ViewHolderWrapper vhw;
        int itemViewType = this.mOrig.getItemViewType(position);
        ViewHolderWrapper viewHolderWrapper = vhw = convertView != null ? (ViewHolderWrapper)AdapterConverter.findViewHolder(convertView) : null;
        if (vhw == null || vhw.getItemViewType() != itemViewType) {
            vhw = new ViewHolderWrapper(this.mOrig.onCreateViewHolder(parent, itemViewType));
            ((RecyclerView.ViewHolder)vhw.getOrig()).itemView.setTag(VIEW_HOLDER, vhw);
        }
        vhw.setPosition(position);
        vhw.setItemViewType(itemViewType);
        this.mOrig.onBindViewHolder(vhw.getOrig(), position);
        return ((RecyclerView.ViewHolder)vhw.getOrig()).itemView;
    }

    @Nullable
    public static Object findViewHolder(@Nullable View view) {
        View p = view;
        while (p != null) {
            Object viewHolder = p.getTag(VIEW_HOLDER);
            if (viewHolder != null) {
                return viewHolder;
            }
            p = p.getParent() instanceof View ? (View)p.getParent() : null;
        }
        return null;
    }

    public boolean isRecyclingDisabled() {
        return this.mRecyclingDisabled;
    }

    public void setRecyclingDisabled(boolean recyclingDisabled) {
        this.mRecyclingDisabled = recyclingDisabled;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        super.registerDataSetObserver(observer);
        AdapterDataObserver adapterDataObserver = this.mAdapterDataObservers.get(observer);
        if (adapterDataObserver == null) {
            adapterDataObserver = new AdapterDataObserver(observer);
            this.mOrig.registerAdapterDataObserver(adapterDataObserver);
            this.mAdapterDataObservers.put(observer, adapterDataObserver);
        }
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        super.unregisterDataSetObserver(observer);
        AdapterDataObserver adapterDataObserver = this.mAdapterDataObservers.remove(observer);
        if (adapterDataObserver != null) {
            this.mOrig.unregisterAdapterDataObserver(adapterDataObserver);
        }
    }

    private static class AdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        DataSetObserver observer;

        public AdapterDataObserver(DataSetObserver observer) {
            this.observer = observer;
        }

        public void onChanged() {
            super.onChanged();
            this.observer.onChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            this.observer.onChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            super.onItemRangeChanged(positionStart, itemCount, payload);
            this.observer.onChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            super.onItemRangeInserted(positionStart, itemCount);
            this.observer.onChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            this.observer.onChanged();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            super.onItemRangeMoved(fromPosition, toPosition, itemCount);
            this.observer.onChanged();
        }
    }

    public static class ViewHolderWrapper<VH extends RecyclerView.ViewHolder> {
        VH orig;
        private int position;
        private int itemViewType;

        public ViewHolderWrapper(VH orig) {
            this.orig = orig;
        }

        public VH getOrig() {
            return this.orig;
        }

        public int getPosition() {
            return this.position;
        }

        void setPosition(int position) {
            this.position = position;
        }

        public int getItemViewType() {
            return this.itemViewType;
        }

        public void setItemViewType(int itemViewType) {
            this.itemViewType = itemViewType;
        }
    }
}

