/*
 * Decompiled with CFR 0.152.
 */
package net.cafeto.queryserialize;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.cafeto.queryserialize.CriteriaQuery;

public class Expression
implements Serializable {
    private static final long serialVersionUID = -8581378668443176744L;
    private boolean negated = false;
    private String logical;
    private String operator;
    private String function;
    private String trim;
    private List<Expression> values = new ArrayList<Expression>();
    private String path;
    private String parameter;
    private Object literal;
    private CriteriaQuery subquery;
    private String alias;

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String getLogical() {
        return this.logical;
    }

    public void setLogical(String logical) {
        this.logical = logical;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Object getLiteral() {
        return this.literal;
    }

    public void setLiteral(Object literal) {
        this.literal = literal;
    }

    public CriteriaQuery getSubquery() {
        return this.subquery;
    }

    public void setSubquery(CriteriaQuery subquery) {
        this.subquery = subquery;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getTrim() {
        return this.trim;
    }

    public void setTrim(String trim) {
        this.trim = trim;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> values) {
        this.values = values;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Expression alias(String alias) {
        this.alias = alias;
        return this;
    }

    public String toJPQL() {
        StringBuffer buffer = new StringBuffer();
        int size = this.values.size();
        if (this.negated) {
            buffer.append(" NOT (");
        }
        if (this.logical != null) {
            if (size == 1) {
                buffer.append(" (");
            }
            for (int i = 0; i < size; ++i) {
                buffer.append(" " + this.values.get(i).toJPQL());
                if (i == size - 1) continue;
                buffer.append(" " + this.logical);
            }
            if (size == 1) {
                buffer.append(")");
            }
        } else if (this.function != null) {
            if ("COUNT".equals(this.function)) {
                buffer.append(" COUNT(" + this.values.get(0).toJPQL() + ")");
            } else if ("COUNT_DISTINCT".equals(this.function)) {
                buffer.append(" COUNT(DISTINCT " + this.values.get(0).toJPQL() + ")");
            } else if ("MIN".equals(this.function)) {
                buffer.append(" MIN(" + this.values.get(0).toJPQL() + ")");
            } else if ("MAX".equals(this.function)) {
                buffer.append(" MAX(" + this.values.get(0).toJPQL() + ")");
            } else if ("AVG".equals(this.function)) {
                buffer.append(" AVG(" + this.values.get(0).toJPQL() + ")");
            } else if ("SUM".equals(this.function)) {
                buffer.append(" SUM(" + this.values.get(0).toJPQL() + ")");
            } else if ("CONCAT".equals(this.function)) {
                buffer.append(" CONCAT(" + this.values.get(0).toJPQL() + "," + this.values.get(1).toJPQL() + ")");
            } else if ("SUBSTRING".equals(this.function)) {
                buffer.append(" SUBSTRING(");
                for (int i = 0; i < this.values.size(); ++i) {
                    buffer.append(this.values.get(i).toJPQL());
                }
                buffer.append(")");
            } else if ("TRIM".equals(this.function)) {
                buffer.append(" TRIM(" + this.trim + "," + this.values.get(0).toJPQL() + "," + this.values.get(1).toJPQL() + ")");
            } else if ("LOWER".equals(this.function)) {
                buffer.append(" LOWER(" + this.values.get(0).toJPQL() + ")");
            } else if ("UPPER".equals(this.function)) {
                buffer.append(" UPPER(" + this.values.get(0).toJPQL() + ")");
            } else if ("LENGTH".equals(this.function)) {
                buffer.append(" LENGTH(" + this.values.get(0).toJPQL() + ")");
            } else if ("LOCATE".equals(this.function)) {
                buffer.append(" LOCATE(");
            } else if ("ABS".equals(this.function)) {
                buffer.append(" ABS(" + this.values.get(0).toJPQL() + ")");
            } else if ("SQRT".equals(this.function)) {
                buffer.append(" SQRT(" + this.values.get(0).toJPQL() + ")");
            } else if ("MOD".equals(this.function)) {
                buffer.append(" MOD(" + this.values.get(0).toJPQL() + ")");
            } else if ("SIZE".equals(this.function)) {
                buffer.append(" SIZE(" + this.values.get(0).toJPQL() + ")");
            } else if ("CURRENT_DATE".equals(this.function)) {
                buffer.append(" CURRENT_DATE");
            } else if ("CURRENT_TIME".equals(this.function)) {
                buffer.append(" CURRENT_TIME");
            } else if ("CURRENT_TIMESTAMP".equals(this.function)) {
                buffer.append(" CURRENT_TIMESTAMP");
            }
        } else if (this.operator != null) {
            if ("SUM".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" + ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("DIFF".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" - ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("PROD".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" * ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("QUOT".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" / ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("EQ".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" = ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("NE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" != ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("GT".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" > ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("LT".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" < ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("GE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" >= ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("LE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" <= ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("LIKE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" LIKE ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("NOT_LIKE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" NOT LIKE ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("BETWEEN".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" BETWEEN ");
                buffer.append(this.values.get(1).toJPQL());
                buffer.append(" AND ");
                buffer.append(this.values.get(2).toJPQL());
            } else if ("NOT_BETWEEN".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" NOT BETWEEN ");
                buffer.append(this.values.get(1).toJPQL());
                buffer.append(" AND ");
                buffer.append(this.values.get(2).toJPQL());
            } else if ("IS_NULL".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS NULL ");
            } else if ("IS_NOT_NULL".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS NOT NULL ");
            } else if ("IS_EMPTY".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS EMPTY ");
            } else if ("IS_NOT_EMPTY".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS NOT EMPTY ");
            } else if ("MEMBER".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" MEMBER OF ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("NOT_MEMBER".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" NOT MEMBER OF ");
                buffer.append(this.values.get(1).toJPQL());
            } else if ("IS_TRUE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS TRUE");
            } else if ("IS_NOT_TRUE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS NOT TRUE");
            } else if ("IS_FALSE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS FALSE");
            } else if ("IS_NOT_FALSE".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IS NOT FALSE");
            } else if ("IN".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" IN (");
                for (int i = 0; i < this.values.size(); ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.values.get(1).toJPQL());
                }
                buffer.append(")");
            } else if ("NOT_IN".equals(this.operator)) {
                buffer.append(this.values.get(0).toJPQL());
                buffer.append(" NOT IN (");
                for (int i = 0; i < this.values.size(); ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.values.get(1).toJPQL());
                }
                buffer.append(")");
            } else if ("EXISTS".equals(this.operator)) {
                buffer.append(" EXISTS");
                buffer.append(this.values.get(0).toJPQL());
            } else if ("NOT_EXISTS".equals(this.operator)) {
                buffer.append(" NOT EXISTS");
                buffer.append(this.values.get(0).toJPQL());
            } else if ("ALL".equals(this.operator)) {
                buffer.append(" ALL");
                buffer.append(this.values.get(0).toJPQL());
            } else if ("SOME".equals(this.operator)) {
                buffer.append(" SOME");
                buffer.append(this.values.get(0).toJPQL());
            } else if ("ANY".equals(this.operator)) {
                buffer.append(" ANY");
                buffer.append(this.values.get(0).toJPQL());
            }
        } else if (this.path != null) {
            buffer.append(" " + this.path);
        } else if (this.parameter != null) {
            buffer.append(" :" + this.parameter);
        } else if (this.literal != null) {
            if (this.literal instanceof String || this.literal instanceof Character) {
                buffer.append("'" + this.literal.toString() + "'");
            } else if (this.literal instanceof Date) {
                buffer.append("'" + this.literal.toString() + "'");
            } else {
                buffer.append(" " + this.literal.toString());
            }
        } else if (this.subquery != null) {
            buffer.append(" (" + this.subquery.toJPQL() + ")");
        }
        if (this.negated) {
            buffer.append(")");
        }
        if (this.alias != null) {
            buffer.append(" AS " + this.alias);
        }
        return buffer.toString().trim();
    }
}

