/*
 * Decompiled with CFR 0.152.
 */
package net.cafeto.queryserialize;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.cafeto.queryserialize.Domain;
import net.cafeto.queryserialize.Expression;
import net.cafeto.queryserialize.Order;

public class CriteriaQuery
implements Serializable {
    private static final long serialVersionUID = -1825648103557536367L;
    private boolean distict;
    private Domain root;
    private List<Expression> selects = new ArrayList<Expression>();
    private List<Domain> froms = new ArrayList<Domain>();
    private Expression where;
    private Expression having;
    private List<Expression> groupBys = new ArrayList<Expression>();
    private List<Order> orders = new ArrayList<Order>();

    public boolean isDistict() {
        return this.distict;
    }

    public void setDistict(boolean distict) {
        this.distict = distict;
    }

    public Domain getRoot() {
        return this.root;
    }

    public void setRoot(Domain root) {
        this.root = root;
    }

    public List<Expression> getSelects() {
        return this.selects;
    }

    public void setSelects(List<Expression> selects) {
        this.selects = selects;
    }

    public List<Domain> getFroms() {
        return this.froms;
    }

    public void setFroms(List<Domain> froms) {
        this.froms = froms;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public List<Expression> getGroupBys() {
        return this.groupBys;
    }

    public void setGroupBys(List<Expression> groupBys) {
        this.groupBys = groupBys;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public CriteriaQuery distict(boolean distinct) {
        this.distict = distinct;
        return this;
    }

    public CriteriaQuery select(List<Expression> selects) {
        this.selects = selects;
        return this;
    }

    public CriteriaQuery where(Expression expression) {
        this.where = expression;
        return this;
    }

    public CriteriaQuery groupBy(List<Expression> expressions) {
        this.groupBys = expressions;
        return this;
    }

    public CriteriaQuery having(Expression expression) {
        this.where = expression;
        return this;
    }

    public CriteriaQuery orderBy(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public String toJPQL() {
        StringBuffer buffer = new StringBuffer(this.toJPQLSubquery());
        if (!this.orders.isEmpty()) {
            buffer.append(" ORDER BY ");
            for (int i = 0; i < this.orders.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.orders.get(i).toJPQL());
            }
        }
        return buffer.toString().trim();
    }

    public String toJPQLSubquery() {
        int i;
        StringBuffer buffer = new StringBuffer("SELECT ");
        if (this.distict) {
            buffer.append(" DISTINCT");
        }
        if (this.root != null) {
            buffer.append(this.root.getAlias());
        }
        for (i = 0; i < this.selects.size(); ++i) {
            if (i > 0 || this.root != null) {
                buffer.append(", ");
            }
            buffer.append(this.selects.get(i).toJPQL());
        }
        buffer.append(" FROM ");
        if (this.root != null) {
            buffer.append(this.root.toJPQL());
        }
        for (i = 0; i < this.froms.size(); ++i) {
            if (i > 0 || this.root != null) {
                buffer.append(", ");
            }
            buffer.append(this.froms.get(i).toJPQL());
        }
        if (this.where != null) {
            buffer.append(" WHERE " + this.where.toJPQL());
        }
        if (!this.groupBys.isEmpty()) {
            buffer.append(" GROUP BY ");
            for (i = 0; i < this.groupBys.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.groupBys.get(i).toJPQL());
            }
        }
        if (this.having != null) {
            buffer.append(" HAVING " + this.having.toJPQL());
        }
        return buffer.toString().trim();
    }

    public String toJPQLCount() {
        if (this.root == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.selects.size() > 0) {
            buffer.append("SELECT COUNT(countObj) FROM " + this.root.getName() + " countObj");
            buffer.append(" WHERE EXISTS (" + this.toJPQLSubquery() + ")");
        } else {
            buffer.append("SELECT COUNT(" + this.root.getAlias() + ") FROM " + this.root.toJPQL());
            if (this.where != null) {
                buffer.append(" WHERE " + this.where.toJPQL());
            }
            if (!this.groupBys.isEmpty()) {
                buffer.append(" GROUP BY ");
                for (int i = 0; i < this.groupBys.size(); ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.groupBys.get(i).toJPQL());
                }
            }
            if (this.having != null) {
                buffer.append(" HAVING " + this.having.toJPQL());
            }
        }
        return buffer.toString().trim();
    }
}

