/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.visitor.ExceptionTableSensitiveMethodVisitor;
import net.bytebuddy.utility.visitor.LineNumberPrependingMethodVisitor;
import net.bytebuddy.utility.visitor.StackAwareMethodVisitor;

public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper,
Implementation {
    private static final ClassReader UNDEFINED = null;
    private static final MethodDescription.InDefinedShape INLINE_ENTER;
    private static final MethodDescription.InDefinedShape SUPPRESS_ENTER;
    private static final MethodDescription.InDefinedShape PREPEND_LINE_NUMBER;
    private static final MethodDescription.InDefinedShape SKIP_ON;
    private static final MethodDescription.InDefinedShape INLINE_EXIT;
    private static final MethodDescription.InDefinedShape SUPPRESS_EXIT;
    private static final MethodDescription.InDefinedShape ON_THROWABLE;
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final boolean replace;

    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit) {
        this(methodEnter, methodExit, false);
    }

    private Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, boolean replace) {
        this.methodEnter = methodEnter;
        this.methodExit = methodExit;
        this.replace = replace;
    }

    public static Advice to(Class<?> advice) {
        return Advice.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
    }

    public static Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
    }

    public static Advice to(TypeDescription advice) {
        return Advice.to(advice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
        return Advice.to(advice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription advice, ClassFileLocator classFileLocator, List<? extends Dispatcher.OffsetMapping.Factory> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : advice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodEnter.isAlive() && !methodExit.isAlive()) {
            throw new IllegalArgumentException("No advice defined by " + advice);
        }
        try {
            ClassReader classReader = methodEnter.isBinary() || methodExit.isBinary() ? new ClassReader(classFileLocator.locate(advice.getName()).resolve()) : UNDEFINED;
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter(userFactories, classReader);
            return new Advice(resolved, methodExit.asMethodExitTo(userFactories, classReader, resolved));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + advice, exception);
        }
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
        ClassLoader exitLoader;
        ClassLoader enterLoader = enterAdvice.getClassLoader();
        return Advice.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
        return Advice.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to(enterAdvice, exitAdvice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator, List<? extends Dispatcher.OffsetMapping.Factory> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : enterAdvice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
        }
        if (!methodEnter.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + enterAdvice);
        }
        for (MethodDescription.InDefinedShape methodDescription : exitAdvice.getDeclaredMethods()) {
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodExit.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + exitAdvice);
        }
        try {
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter(userFactories, methodEnter.isBinary() ? new ClassReader(classFileLocator.locate(enterAdvice.getName()).resolve()) : UNDEFINED);
            return new Advice(resolved, methodExit.asMethodExitTo(userFactories, methodExit.isBinary() ? new ClassReader(classFileLocator.locate(exitAdvice.getName()).resolve()) : UNDEFINED, resolved));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + enterAdvice + " or " + exitAdvice, exception);
        }
    }

    private static Dispatcher.Unresolved locate(Class<? extends Annotation> type, MethodDescription.InDefinedShape property, Dispatcher.Unresolved dispatcher, MethodDescription.InDefinedShape methodDescription) {
        AnnotationDescription.Loadable<? extends Annotation> annotation = methodDescription.getDeclaredAnnotations().ofType(type);
        if (annotation == null) {
            return dispatcher;
        }
        if (dispatcher.isAlive()) {
            throw new IllegalStateException("Duplicate advice for " + dispatcher + " and " + methodDescription);
        }
        if (!methodDescription.isStatic()) {
            throw new IllegalStateException("Advice for " + methodDescription + " is not static");
        }
        return annotation.getValue(property).resolve(Boolean.class) != false ? new Dispatcher.Inlining(methodDescription) : new Dispatcher.Delegating(methodDescription);
    }

    public static WithCustomMapping withCustomMapping() {
        return new WithCustomMapping();
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription.InDefinedShape> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().method(matcher, this);
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription.InDefinedShape instrumentedMethod, MethodVisitor methodVisitor, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
        return instrumentedMethod.isAbstract() || instrumentedMethod.isNative() ? methodVisitor : this.doWrap(instrumentedType, instrumentedMethod, methodVisitor, classFileVersion, writerFlags, readerFlags);
    }

    protected MethodVisitor doWrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
        MethodVisitor methodVisitor2 = methodVisitor = this.methodEnter.isPrependLineNumber() ? new LineNumberPrependingMethodVisitor(methodVisitor) : methodVisitor;
        if (!this.methodExit.isAlive()) {
            return new AdviceVisitor.WithoutExitAdvice(methodVisitor, instrumentedType, instrumentedMethod, this.methodEnter, classFileVersion, writerFlags, readerFlags);
        }
        if (this.methodExit.getTriggeringThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
            return new AdviceVisitor.WithExitAdvice.WithoutExceptionHandling(methodVisitor, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, classFileVersion, writerFlags, readerFlags);
        }
        if (instrumentedMethod.isConstructor()) {
            throw new IllegalStateException("Cannot catch exception during constructor call for " + instrumentedMethod);
        }
        return new AdviceVisitor.WithExitAdvice.WithExceptionHandling(methodVisitor, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, classFileVersion, writerFlags, readerFlags, this.methodExit.getTriggeringThrowable());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this, implementationTarget, this.replace);
    }

    public Implementation replaceExisting() {
        return new Advice(this.methodEnter, this.methodExit, true);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Advice advice = (Advice)other;
        return this.methodEnter.equals(advice.methodEnter) && this.methodExit.equals(advice.methodExit) && this.replace == advice.replace;
    }

    public int hashCode() {
        int result = this.methodEnter.hashCode();
        result = 31 * result + this.methodExit.hashCode();
        result = 31 * result + (this.replace ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Advice{methodEnter=" + this.methodEnter + ", methodExit=" + this.methodExit + ", replace=" + this.replace + '}';
    }

    static {
        MethodList<MethodDescription.InDefinedShape> enter = new TypeDescription.ForLoadedType(OnMethodEnter.class).getDeclaredMethods();
        INLINE_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("suppress"))).getOnly();
        SKIP_ON = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("skipOn"))).getOnly();
        PREPEND_LINE_NUMBER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("prependLineNumber"))).getOnly();
        MethodList<MethodDescription.InDefinedShape> exit = new TypeDescription.ForLoadedType(OnMethodExit.class).getDeclaredMethods();
        INLINE_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("suppress"))).getOnly();
        ON_THROWABLE = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("onThrowable"))).getOnly();
    }

    public static final class OnNonDefaultValue {
        private OnNonDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static final class OnDefaultValue {
        private OnDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    private static class NoExceptionHandler
    extends Throwable {
        private static final TypeDescription DESCRIPTION = new TypeDescription.ForLoadedType(NoExceptionHandler.class);

        private NoExceptionHandler() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static class WithCustomMapping {
        private final Map<Class<? extends Annotation>, DynamicValue<?>> dynamicValues;

        protected WithCustomMapping() {
            this(Collections.emptyMap());
        }

        protected WithCustomMapping(Map<Class<? extends Annotation>, DynamicValue<?>> dynamicValues) {
            this.dynamicValues = dynamicValues;
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, TypeDescription value) {
            return this.bind(type, new DynamicValue.ForFixedValue(value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, Serializable value) {
            return this.bind(type, new DynamicValue.ForFixedValue(value));
        }

        public <T extends Annotation> WithCustomMapping bindProperty(Class<? extends T> type, String property) {
            return this.bind(type, DynamicValue.ForAnnotationProperty.of(type, property));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, DynamicValue<T> dynamicValue) {
            HashMap dynamicValues = new HashMap(this.dynamicValues);
            if (!type.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + type);
            }
            if (dynamicValues.put(type, dynamicValue) != null) {
                throw new IllegalArgumentException("Annotation type already mapped: " + type);
            }
            return new WithCustomMapping(dynamicValues);
        }

        public Advice to(Class<?> advice) {
            return this.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
        }

        public Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
            return this.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
        }

        public Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
            ArrayList<Dispatcher.OffsetMapping.Factory> userFactories = new ArrayList<Dispatcher.OffsetMapping.Factory>(this.dynamicValues.size());
            for (Map.Entry<Class<Annotation>, DynamicValue<?>> entry : this.dynamicValues.entrySet()) {
                userFactories.add(Dispatcher.OffsetMapping.ForUserValue.Factory.of(entry.getKey(), entry.getValue()));
            }
            return Advice.to(advice, classFileLocator, userFactories);
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
            ClassLoader exitLoader;
            ClassLoader enterLoader = enterAdvice.getClassLoader();
            return this.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
            return this.to(new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
            return this.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
            ArrayList<Dispatcher.OffsetMapping.Factory> userFactories = new ArrayList<Dispatcher.OffsetMapping.Factory>(this.dynamicValues.size());
            for (Map.Entry<Class<Annotation>, DynamicValue<?>> entry : this.dynamicValues.entrySet()) {
                userFactories.add(Dispatcher.OffsetMapping.ForUserValue.Factory.of(entry.getKey(), entry.getValue()));
            }
            return Advice.to(enterAdvice, exitAdvice, classFileLocator, userFactories);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            WithCustomMapping that = (WithCustomMapping)other;
            return this.dynamicValues.equals(that.dynamicValues);
        }

        public int hashCode() {
            return this.dynamicValues.hashCode();
        }

        public String toString() {
            return "Advice.WithCustomMapping{dynamicValues=" + this.dynamicValues + '}';
        }
    }

    public static interface DynamicValue<T extends Annotation> {
        public Object resolve(TypeDescription var1, MethodDescription var2, ParameterDescription.InDefinedShape var3, AnnotationDescription.Loadable<T> var4, boolean var5);

        public static class ForAnnotationProperty<T extends Annotation>
        implements DynamicValue<T> {
            private final MethodDescription.InDefinedShape annotationProperty;

            protected ForAnnotationProperty(MethodDescription.InDefinedShape annotationProperty) {
                this.annotationProperty = annotationProperty;
            }

            protected static <T extends Annotation> DynamicValue<T> of(Class<? extends T> type, String property) {
                try {
                    return new ForAnnotationProperty<T>(new MethodDescription.ForLoadedMethod(type.getDeclaredMethod(property, new Class[0])));
                }
                catch (NoSuchMethodException exception) {
                    throw new IllegalArgumentException("Property '" + property + "' does not exist for " + type, exception);
                }
            }

            @Override
            public Object resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, boolean initialized) {
                return annotation.getValue(this.annotationProperty).resolve();
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForAnnotationProperty that = (ForAnnotationProperty)other;
                return this.annotationProperty.equals(that.annotationProperty);
            }

            public int hashCode() {
                return this.annotationProperty.hashCode();
            }

            public String toString() {
                return "Advice.DynamicValue.ForAnnotationProperty{annotationProperty=" + this.annotationProperty + '}';
            }
        }

        public static class ForFixedValue
        implements DynamicValue<Annotation> {
            private final Object value;

            public ForFixedValue(Object value) {
                this.value = value;
            }

            @Override
            public Object resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Annotation> annotation, boolean initialized) {
                return this.value;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForFixedValue that = (ForFixedValue)other;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            public int hashCode() {
                return this.value != null ? this.value.hashCode() : 0;
            }

            public String toString() {
                return "Advice.DynamicValue.ForFixedValue{value=" + this.value + '}';
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Thrown {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface BoxedArguments {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface BoxedReturn {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Return {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Enter {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface StubValue {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Unused {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Origin {
        public static final String DEFAULT = "";

        public String value() default "";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldValue {
        public String value();

        public Class<?> declaringType() default void.class;

        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface This {
        public boolean readOnly() default true;

        public boolean optional() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Argument {
        public int value();

        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodExit {
        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;

        public Class<? extends Throwable> onThrowable() default NoExceptionHandler.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodEnter {
        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;

        public Class<?> skipOn() default void.class;

        public boolean prependLineNumber() default true;
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Advice advice;
        private final Implementation.Target implementationTarget;
        private final boolean replace;

        protected Appender(Advice advice, Implementation.Target implementationTarget, boolean replace) {
            this.advice = advice;
            this.implementationTarget = implementationTarget;
            this.replace = replace;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            EmulatingMethodVisitor emulatingMethodVisitor = new EmulatingMethodVisitor(methodVisitor, instrumentedMethod);
            methodVisitor = this.advice.doWrap(this.implementationTarget.getInstrumentedType(), instrumentedMethod, emulatingMethodVisitor, implementationContext.getClassFileVersion(), 0, 0);
            StackManipulation.Illegal invocation = this.replace ? StackManipulation.Illegal.INSTANCE : this.implementationTarget.invokeDominant(instrumentedMethod.asSignatureToken());
            return emulatingMethodVisitor.resolve(methodVisitor, implementationContext, new StackManipulation.Compound(invocation.isValid() ? new StackManipulation.Compound(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), invocation) : DefaultValue.of(instrumentedMethod.getReturnType()), MethodReturn.of(instrumentedMethod.getReturnType())));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Appender appender = (Appender)object;
            return this.advice.equals(appender.advice) && this.replace == appender.replace && this.implementationTarget.equals(appender.implementationTarget);
        }

        public int hashCode() {
            int result = this.advice.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + (this.replace ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Advice.Appender{advice=" + this.advice + ", implementationTarget=" + this.implementationTarget + ", replace=" + this.replace + '}';
        }

        protected static class EmulatingMethodVisitor
        extends MethodVisitor {
            private final MethodDescription instrumentedMethod;
            private int stackSize;
            private int localVariableLength;

            protected EmulatingMethodVisitor(MethodVisitor methodVisitor, MethodDescription instrumentedMethod) {
                super(327680, methodVisitor);
                this.instrumentedMethod = instrumentedMethod;
            }

            protected ByteCodeAppender.Size resolve(MethodVisitor methodVisitor, Implementation.Context implementationContext, StackManipulation stackManipulation) {
                methodVisitor.visitCode();
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                methodVisitor.visitMaxs(size.getMaximalSize(), this.instrumentedMethod.getStackSize());
                methodVisitor.visitEnd();
                return new ByteCodeAppender.Size(this.stackSize, this.localVariableLength);
            }

            @Override
            public void visitCode() {
            }

            @Override
            public void visitMaxs(int stackSize, int localVariableLength) {
                this.stackSize = stackSize;
                this.localVariableLength = localVariableLength;
            }

            @Override
            public void visitEnd() {
            }

            public String toString() {
                return "Advice.Appender.EmulatingMethodVisitor{instrumentedMethod=" + this.instrumentedMethod + ", stackSize=" + this.stackSize + ", localVariableLength=" + this.localVariableLength + '}';
            }
        }
    }

    protected static abstract class AdviceVisitor
    extends ExceptionTableSensitiveMethodVisitor
    implements Dispatcher.Bound.SkipHandler {
        private static final int NO_OFFSET = 0;
        protected final MethodVisitor methodVisitor;
        protected final MethodDescription instrumentedMethod;
        private final int padding;
        private final Dispatcher.Bound.ForMethodEnter methodEnter;
        protected final Dispatcher.Bound.ForMethodExit methodExit;
        protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
        protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;

        protected AdviceVisitor(MethodVisitor methodVisitor, MethodVisitor delegate, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> yieldedTypes, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
            super(327680, delegate);
            this.methodVisitor = methodVisitor;
            this.instrumentedMethod = instrumentedMethod;
            this.padding = methodEnter.getEnterType().getStackSize().getSize();
            List requiredTypes = methodEnter.getEnterType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodEnter.getEnterType());
            this.methodSizeHandler = MethodSizeHandler.Default.of(instrumentedMethod, requiredTypes, yieldedTypes, writerFlags);
            this.stackMapFrameHandler = StackMapFrameHandler.Default.of(instrumentedType, instrumentedMethod, requiredTypes, yieldedTypes, classFileVersion, writerFlags, readerFlags);
            this.methodEnter = methodEnter.bind(instrumentedType, instrumentedMethod, methodVisitor, this.methodSizeHandler, this.stackMapFrameHandler);
            this.methodExit = methodExit.bind(instrumentedType, instrumentedMethod, methodVisitor, this.methodSizeHandler, this.stackMapFrameHandler);
        }

        @Override
        protected void onAfterExceptionTable() {
            this.methodEnter.prepare();
            this.onUserPrepare();
            this.methodExit.prepare();
            this.methodEnter.apply(this);
            this.onUserStart();
        }

        protected abstract void onUserPrepare();

        protected abstract void onUserStart();

        @Override
        protected void onVisitVarInsn(int opcode, int offset) {
            this.mv.visitVarInsn(opcode, this.resolve(offset));
        }

        @Override
        protected void onVisitIincInsn(int offset, int increment) {
            this.mv.visitIincInsn(this.resolve(offset), increment);
        }

        protected void variable(int opcode) {
            this.variable(opcode, 0);
        }

        protected void variable(int opcode, int offset) {
            this.methodVisitor.visitVarInsn(opcode, this.instrumentedMethod.getStackSize() + this.padding + offset);
        }

        @Override
        public void visitFrame(int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            this.stackMapFrameHandler.translateFrame(this.methodVisitor, frameType, localVariableLength, localVariable, stackSize, stack);
        }

        @Override
        public void visitMaxs(int stackSize, int localVariableLength) {
            this.onUserEnd();
            this.methodVisitor.visitMaxs(this.methodSizeHandler.compoundStackSize(stackSize), this.methodSizeHandler.compoundLocalVariableLength(localVariableLength));
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, descriptor, signature, start, end, this.resolve(index));
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            return this.mv.visitLocalVariableAnnotation(typeReference, typePath, start, end, this.resolve(index), descriptor, visible);
        }

        private int[] resolve(int[] index) {
            int[] resolved = new int[index.length];
            for (int anIndex = 0; anIndex < index.length; ++anIndex) {
                resolved[anIndex] = this.resolve(index[anIndex]);
            }
            return resolved;
        }

        private int resolve(int index) {
            return index < this.instrumentedMethod.getStackSize() ? index : this.padding + index;
        }

        protected abstract void onUserEnd();

        protected static abstract class WithExitAdvice
        extends AdviceVisitor {
            protected final Label returnHandler = new Label();
            protected boolean doesReturn = false;

            protected WithExitAdvice(MethodVisitor methodVisitor, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> yieldedTypes, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                super(methodVisitor, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod), instrumentedType, instrumentedMethod, methodEnter, methodExit, yieldedTypes, classFileVersion, writerFlags, readerFlags);
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(1);
                }
                methodVisitor.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onVisitInsn(int opcode) {
                switch (opcode) {
                    case 177: {
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        break;
                    }
                    case 172: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                        break;
                    }
                    case 174: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                        break;
                    }
                    case 175: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                        break;
                    }
                    case 173: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                        break;
                    }
                    case 176: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                        break;
                    }
                    default: {
                        this.mv.visitInsn(opcode);
                        return;
                    }
                }
                this.mv.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onUserEnd() {
                Type returnType = Type.getType(this.instrumentedMethod.getReturnType().asErasure().getDescriptor());
                this.methodVisitor.visitLabel(this.returnHandler);
                if (this.doesReturn) {
                    this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                    if (!returnType.equals(Type.VOID_TYPE)) {
                        this.variable(returnType.getOpcode(54));
                    }
                }
                this.onUserReturn();
                this.methodExit.apply();
                this.onExitAdviceReturn();
                if (returnType.equals(Type.VOID_TYPE)) {
                    this.methodVisitor.visitInsn(177);
                } else {
                    this.variable(returnType.getOpcode(21));
                    this.methodVisitor.visitInsn(returnType.getOpcode(172));
                }
            }

            protected abstract void onUserReturn();

            protected abstract void onExitAdviceReturn();

            protected static class WithExceptionHandling
            extends WithExitAdvice {
                private final TypeDescription triggeringThrowable;
                private final Label userStart;
                private final Label exceptionHandler;

                protected WithExceptionHandling(MethodVisitor methodVisitor, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, ClassFileVersion classFileVersion, int writerFlags, int readerFlags, TypeDescription triggeringThrowable) {
                    super(methodVisitor, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.singletonList(TypeDescription.THROWABLE) : Arrays.asList(instrumentedMethod.getReturnType().asErasure(), TypeDescription.THROWABLE), classFileVersion, writerFlags, readerFlags);
                    this.triggeringThrowable = triggeringThrowable;
                    this.userStart = new Label();
                    this.exceptionHandler = new Label();
                }

                @Override
                protected void onUserPrepare() {
                    this.methodVisitor.visitTryCatchBlock(this.userStart, this.returnHandler, this.exceptionHandler, this.triggeringThrowable.getInternalName());
                }

                @Override
                protected void onUserStart() {
                    this.methodVisitor.visitLabel(this.userStart);
                }

                @Override
                protected void onUserReturn() {
                    Label endOfHandler = new Label();
                    if (this.doesReturn) {
                        this.methodVisitor.visitInsn(1);
                        this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                        this.methodVisitor.visitJumpInsn(167, endOfHandler);
                    }
                    this.methodVisitor.visitLabel(this.exceptionHandler);
                    this.stackMapFrameHandler.injectExceptionFrame(this.methodVisitor);
                    this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    this.storeDefaultReturn();
                    if (this.doesReturn) {
                        this.methodVisitor.visitLabel(endOfHandler);
                    }
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                protected void onExitAdviceReturn() {
                    this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    Label endOfHandler = new Label();
                    this.methodVisitor.visitJumpInsn(198, endOfHandler);
                    this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    this.methodVisitor.visitInsn(191);
                    this.methodVisitor.visitLabel(endOfHandler);
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, true);
                }

                private void storeDefaultReturn() {
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.methodVisitor.visitInsn(3);
                        this.variable(54);
                    } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.methodVisitor.visitInsn(9);
                        this.variable(55);
                    } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.methodVisitor.visitInsn(11);
                        this.variable(56);
                    } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.methodVisitor.visitInsn(14);
                        this.variable(57);
                    } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.methodVisitor.visitInsn(1);
                        this.variable(58);
                    }
                }

                public String toString() {
                    return "Advice.AdviceVisitor.WithExitAdvice.WithExceptionHandling{instrumentedMethod=" + this.instrumentedMethod + ", triggeringThrowable=" + this.triggeringThrowable + ", doesReturn=" + this.doesReturn + "}";
                }
            }

            protected static class WithoutExceptionHandling
            extends WithExitAdvice {
                protected WithoutExceptionHandling(MethodVisitor methodVisitor, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                    super(methodVisitor, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(instrumentedMethod.getReturnType().asErasure()), classFileVersion, writerFlags, readerFlags);
                }

                @Override
                protected void onUserPrepare() {
                }

                @Override
                protected void onUserStart() {
                }

                @Override
                protected void onUserReturn() {
                    if (!this.doesReturn || !this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                    }
                }

                @Override
                protected void onExitAdviceReturn() {
                }

                public String toString() {
                    return "Advice.AdviceVisitor.WithExitAdvice.WithoutExceptionHandling{instrumentedMethod=" + this.instrumentedMethod + ", doesReturn=" + this.doesReturn + "}";
                }
            }
        }

        protected static class WithoutExitAdvice
        extends AdviceVisitor {
            protected WithoutExitAdvice(MethodVisitor methodVisitor, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                super(methodVisitor, methodVisitor, instrumentedType, instrumentedMethod, methodEnter, Dispatcher.Inactive.INSTANCE, Collections.emptyList(), classFileVersion, writerFlags, readerFlags);
            }

            @Override
            protected void onUserPrepare() {
            }

            @Override
            protected void onUserStart() {
            }

            @Override
            protected void onUserEnd() {
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitInsn(172);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                    methodVisitor.visitInsn(173);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                    methodVisitor.visitInsn(174);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                    methodVisitor.visitInsn(175);
                } else if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(177);
                } else {
                    methodVisitor.visitInsn(1);
                    methodVisitor.visitInsn(176);
                }
            }

            public String toString() {
                return "Advice.AdviceVisitor.WithoutExitAdvice{, instrumentedMethod=" + this.instrumentedMethod + "}";
            }
        }
    }

    protected static interface Dispatcher {
        public static final MethodVisitor IGNORE_METHOD = null;
        public static final AnnotationVisitor IGNORE_ANNOTATION = null;

        public boolean isAlive();

        public static class Delegating
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Delegating(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                return new Resolved.ForMethodEnter(this.adviceMethod, userFactories);
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, dispatcher.getEnterType());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.adviceMethod.equals(((Delegating)other).adviceMethod);
            }

            public int hashCode() {
                return this.adviceMethod.hashCode();
            }

            public String toString() {
                return "Advice.Dispatcher.Delegating{adviceMethod=" + this.adviceMethod + '}';
            }

            protected static abstract class Resolved<T extends Bound>
            implements net.bytebuddy.asm.Advice$Dispatcher$Resolved {
                private static final boolean READ_ONLY = true;
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final List<OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Factory> factories, TypeDescription throwableType) {
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = new ArrayList<OffsetMapping>(adviceMethod.getParameters().size());
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = OffsetMapping.Factory.UNDEFINED;
                        for (OffsetMapping.Factory factory : factories) {
                            OffsetMapping possible = factory.make(parameterDescription);
                            if (possible == null) continue;
                            if (offsetMapping == null) {
                                offsetMapping = possible;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + possible + " and " + offsetMapping);
                        }
                        this.offsetMappings.add(offsetMapping == null ? new OffsetMapping.ForParameter(parameterDescription.getIndex(), true, parameterDescription.getType().asErasure()) : offsetMapping);
                    }
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                public T bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler) {
                    if (!this.adviceMethod.isVisibleTo(instrumentedType)) {
                        throw new IllegalStateException(this.adviceMethod + " is not visible to " + instrumentedMethod.getDeclaringType());
                    }
                    return this.resolve(instrumentedType, instrumentedMethod, methodVisitor, methodSizeHandler, stackMapFrameHandler);
                }

                protected abstract T resolve(TypeDescription var1, MethodDescription var2, MethodVisitor var3, MethodSizeHandler.ForInstrumentedMethod var4, StackMapFrameHandler.ForInstrumentedMethod var5);

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.adviceMethod.equals(resolved.adviceMethod) && this.offsetMappings.equals(resolved.offsetMappings);
                }

                public int hashCode() {
                    int result = this.adviceMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    return result;
                }

                protected static abstract class ForMethodExit
                extends Resolved<Bound.ForMethodExit>
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDescription enterType;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDescription enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForParameter.Factory.READ_ONLY, OffsetMapping.ForBoxedArguments.Factory.READ_ONLY, OffsetMapping.ForThisReference.Factory.READ_ONLY, OffsetMapping.ForField.Factory.READ_ONLY, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType, true), OffsetMapping.ForReturnValue.Factory.READ_ONLY, OffsetMapping.ForBoxedReturnValue.Factory.READ_ONLY, OffsetMapping.ForThrowable.Factory.of(adviceMethod, true)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class));
                        this.enterType = enterType;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDescription enterType) {
                        TypeDescription triggeringThrowable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return triggeringThrowable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, enterType) : new WithExceptionHandler(adviceMethod, userFactories, enterType, triggeringThrowable);
                    }

                    @Override
                    protected Bound.ForMethodExit resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, OffsetMapping.Context.ForMethodExit.of(this.enterType)));
                        }
                        return new AdviceMethodWriter.ForMethodExit(this.adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, methodSizeHandler.bindExit(this.adviceMethod, this.getTriggeringThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), this.suppressionHandler.bind());
                    }

                    @Override
                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.enterType == ((ForMethodExit)other).enterType;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDescription enterType) {
                            super(adviceMethod, userFactories, enterType);
                        }

                        @Override
                        public TypeDescription getTriggeringThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.ForMethodExit.WithoutExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + '}';
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription triggeringThrowable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDescription enterType, TypeDescription triggeringThrowable) {
                            super(adviceMethod, userFactories, enterType);
                            this.triggeringThrowable = triggeringThrowable;
                        }

                        @Override
                        public TypeDescription getTriggeringThrowable() {
                            return this.triggeringThrowable;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.ForMethodExit.WithExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", triggeringThrowable=" + this.triggeringThrowable + '}';
                        }
                    }
                }

                protected static class ForMethodEnter
                extends Resolved<Bound.ForMethodEnter>
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForParameter.Factory.READ_ONLY, OffsetMapping.ForBoxedArguments.Factory.READ_ONLY, OffsetMapping.ForThisReference.Factory.READ_ONLY, OffsetMapping.ForField.Factory.READ_ONLY, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.Illegal(Thrown.class, Enter.class, Return.class, BoxedReturn.class)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class));
                        this.skipDispatcher = Resolved.ForMethodEnter.SkipDispatcher.ForType.of(adviceMethod);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    @Override
                    public TypeDescription getEnterType() {
                        return this.adviceMethod.getReturnType().asErasure();
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected Bound.ForMethodEnter resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, OffsetMapping.Context.ForMethodEntry.of(instrumentedMethod)));
                        }
                        return new AdviceMethodWriter.ForMethodEnter(this.adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, methodSizeHandler.bindEntry(this.adviceMethod), stackMapFrameHandler.bindEntry(this.adviceMethod), this.suppressionHandler.bind(), this.skipDispatcher);
                    }

                    @Override
                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        if (!super.equals(other)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)other;
                        return this.skipDispatcher == that.skipDispatcher && this.prependLineNumber == that.prependLineNumber;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.skipDispatcher.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Delegating.Resolved.ForMethodEnter{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", skipDispatcher=" + this.skipDispatcher + ", prependLineNumber=" + this.prependLineNumber + '}';
                    }
                }

                protected static abstract class AdviceMethodWriter
                implements Bound,
                SuppressionHandler.ReturnValueProducer {
                    private static final int EMPTY = 0;
                    protected final MethodDescription.InDefinedShape adviceMethod;
                    protected final MethodDescription instrumentedMethod;
                    private final List<OffsetMapping.Target> offsetMappings;
                    protected final MethodVisitor methodVisitor;
                    protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                    protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                    private final SuppressionHandler.Bound suppressionHandler;

                    protected AdviceMethodWriter(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler) {
                        this.adviceMethod = adviceMethod;
                        this.instrumentedMethod = instrumentedMethod;
                        this.offsetMappings = offsetMappings;
                        this.methodVisitor = methodVisitor;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                    }

                    @Override
                    public void prepare() {
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    protected void doApply() {
                        this.suppressionHandler.onStart(this.methodVisitor, this.methodSizeHandler);
                        int index = 0;
                        int currentStackSize = 0;
                        int maximumStackSize = 0;
                        for (OffsetMapping.Target offsetMapping : this.offsetMappings) {
                            Type type = Type.getType(((ParameterDescription.InDefinedShape)this.adviceMethod.getParameters().get(index++)).getType().asErasure().getDescriptor());
                            maximumStackSize = Math.max(maximumStackSize, (currentStackSize += type.getSize()) + offsetMapping.resolveAccess(this.methodVisitor, type.getOpcode(21)));
                        }
                        this.methodVisitor.visitMethodInsn(184, this.adviceMethod.getDeclaringType().getInternalName(), this.adviceMethod.getInternalName(), this.adviceMethod.getDescriptor(), false);
                        this.onMethodReturn();
                        this.suppressionHandler.onEndSkipped(this.methodVisitor, this.stackMapFrameHandler, this);
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                        this.methodSizeHandler.recordMaxima(Math.max(maximumStackSize, this.adviceMethod.getReturnType().getStackSize().getSize()), 0);
                    }

                    protected abstract void onMethodReturn();

                    public String toString() {
                        return "Advice.Dispatcher.Delegating.Resolved.AdviceMethodWriter{instrumentedMethod=" + this.instrumentedMethod + ", methodVisitor=" + this.methodVisitor + ", methodSizeHandler=" + this.methodSizeHandler + ", stackMapFrameHandler=" + this.stackMapFrameHandler + ", suppressionHandler=" + this.suppressionHandler + '}';
                    }

                    protected static class ForMethodExit
                    extends AdviceMethodWriter
                    implements Bound.ForMethodExit {
                        protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler) {
                            super(adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, methodSizeHandler, stackMapFrameHandler, suppressionHandler);
                        }

                        @Override
                        public void apply() {
                            this.doApply();
                        }

                        @Override
                        protected void onMethodReturn() {
                            switch (this.adviceMethod.getReturnType().getStackSize()) {
                                case ZERO: {
                                    return;
                                }
                                case SINGLE: {
                                    this.methodVisitor.visitInsn(87);
                                    return;
                                }
                                case DOUBLE: {
                                    this.methodVisitor.visitInsn(88);
                                    return;
                                }
                            }
                            throw new IllegalStateException("Unexpected size: " + (Object)((Object)this.adviceMethod.getReturnType().getStackSize()));
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                        }

                        @Override
                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.AdviceMethodWriter.ForMethodExit{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + "}";
                        }
                    }

                    protected static class ForMethodEnter
                    extends AdviceMethodWriter
                    implements Bound.ForMethodEnter {
                        private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;

                        protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, Resolved.ForMethodEnter.SkipDispatcher skipDispatcher) {
                            super(adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, methodSizeHandler, stackMapFrameHandler, suppressionHandler);
                            this.skipDispatcher = skipDispatcher;
                        }

                        @Override
                        protected void onMethodReturn() {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                this.methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                this.methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                this.methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                this.methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                this.methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                            }
                        }

                        @Override
                        public void apply(Bound.SkipHandler skipHandler) {
                            this.doApply();
                            this.skipDispatcher.apply(this.methodVisitor, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedMethod, skipHandler);
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                methodVisitor.visitInsn(3);
                                methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                methodVisitor.visitInsn(9);
                                methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                methodVisitor.visitInsn(1);
                                methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                            }
                        }

                        @Override
                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.AdviceMethodWriter.ForMethodEnter{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + "}";
                        }
                    }
                }
            }
        }

        public static class Inlining
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Inlining(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return true;
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                return new Resolved.ForMethodEnter(this.adviceMethod, userFactories, classReader);
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, classReader, dispatcher.getEnterType());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.adviceMethod.equals(((Inlining)other).adviceMethod);
            }

            public int hashCode() {
                return this.adviceMethod.hashCode();
            }

            public String toString() {
                return "Advice.Dispatcher.Inlining{adviceMethod=" + this.adviceMethod + '}';
            }

            protected static abstract class CodeTranslationVisitor
            extends MethodVisitor
            implements SuppressionHandler.ReturnValueProducer {
                protected final MethodVisitor methodVisitor;
                protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                protected final MethodDescription instrumentedMethod;
                protected final MethodDescription.InDefinedShape adviceMethod;
                private final Map<Integer, OffsetMapping.Target> offsetMappings;
                private final SuppressionHandler.Bound suppressionHandler;
                protected final Label endOfMethod;

                protected CodeTranslationVisitor(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler) {
                    super(327680, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod));
                    this.methodVisitor = methodVisitor;
                    this.methodSizeHandler = methodSizeHandler;
                    this.stackMapFrameHandler = stackMapFrameHandler;
                    this.instrumentedMethod = instrumentedMethod;
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = offsetMappings;
                    this.suppressionHandler = suppressionHandler;
                    this.endOfMethod = new Label();
                }

                protected void propagateHandler(Label label) {
                    ((StackAwareMethodVisitor)this.mv).register(label, Collections.singletonList(StackSize.SINGLE));
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public void visitAttribute(Attribute attribute) {
                }

                @Override
                public void visitCode() {
                    this.suppressionHandler.onStart(this.methodVisitor, this.methodSizeHandler);
                }

                @Override
                public void visitFrame(int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    this.stackMapFrameHandler.translateFrame(this.methodVisitor, frameType, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void visitEnd() {
                    this.suppressionHandler.onEnd(this.methodVisitor, this.stackMapFrameHandler, this);
                    this.methodVisitor.visitLabel(this.endOfMethod);
                    this.onMethodReturn();
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                public void visitMaxs(int stackSize, int localVariableLength) {
                    this.methodSizeHandler.recordMaxima(stackSize, localVariableLength);
                }

                @Override
                public void visitVarInsn(int opcode, int offset) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        this.methodSizeHandler.recordPadding(target.resolveAccess(this.mv, opcode));
                    } else {
                        this.mv.visitVarInsn(opcode, this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize()));
                    }
                }

                @Override
                public void visitIincInsn(int offset, int increment) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        this.methodSizeHandler.recordPadding(target.resolveIncrement(this.mv, increment));
                    } else {
                        this.mv.visitIincInsn(this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize()), increment);
                    }
                }

                protected abstract int adjust(int var1);

                @Override
                public abstract void visitInsn(int var1);

                protected abstract void onMethodReturn();

                protected static class ForMethodExit
                extends CodeTranslationVisitor {
                    private final int padding;

                    protected ForMethodExit(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, int padding) {
                        super(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler);
                        this.padding = padding;
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                break;
                            }
                            case 172: 
                            case 174: 
                            case 176: {
                                this.mv.visitInsn(87);
                                break;
                            }
                            case 173: 
                            case 175: {
                                this.mv.visitInsn(88);
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                    }

                    @Override
                    protected int adjust(int offset) {
                        return this.instrumentedMethod.getReturnType().getStackSize().getSize() + this.padding + offset;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                    }

                    @Override
                    protected void onMethodReturn() {
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Inlining.CodeTranslationVisitor.ForMethodExit{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + ", padding=" + this.padding + '}';
                    }
                }

                protected static class ForMethodEnter
                extends CodeTranslationVisitor {
                    private boolean doesReturn = false;

                    protected ForMethodEnter(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler) {
                        super(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                ((StackAwareMethodVisitor)this.mv).drainStack();
                                break;
                            }
                            case 172: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                                break;
                            }
                            case 176: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                                break;
                            }
                            case 174: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                                break;
                            }
                            case 173: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                                break;
                            }
                            case 175: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                        this.doesReturn = true;
                    }

                    @Override
                    protected int adjust(int offset) {
                        return offset;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                        if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                            methodVisitor.visitInsn(3);
                        } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                            methodVisitor.visitInsn(9);
                        } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                            methodVisitor.visitInsn(11);
                        } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                            methodVisitor.visitInsn(14);
                        } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitInsn(1);
                        }
                        this.doesReturn = true;
                    }

                    @Override
                    protected void onMethodReturn() {
                        Type returnType = Type.getType(this.adviceMethod.getReturnType().asErasure().getDescriptor());
                        if (this.doesReturn && !returnType.equals(Type.VOID_TYPE)) {
                            this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                            this.methodVisitor.visitVarInsn(returnType.getOpcode(54), this.instrumentedMethod.getStackSize());
                        }
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Inlining.CodeTranslationVisitor.ForMethodEnter{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + ", doesReturn=" + this.doesReturn + '}';
                    }
                }
            }

            protected static abstract class Resolved
            implements net.bytebuddy.asm.Advice$Dispatcher$Resolved {
                private static final boolean READ_ONLY = true;
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final ClassReader classReader;
                protected final Map<Integer, OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Factory> factories, ClassReader classReader, TypeDescription throwableType) {
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = new HashMap<Integer, OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = OffsetMapping.Factory.UNDEFINED;
                        for (OffsetMapping.Factory factory : factories) {
                            OffsetMapping possible = factory.make(parameterDescription);
                            if (possible == null) continue;
                            if (offsetMapping == null) {
                                offsetMapping = possible;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + possible + " and " + offsetMapping);
                        }
                        this.offsetMappings.put(parameterDescription.getOffset(), offsetMapping == null ? new OffsetMapping.ForParameter(parameterDescription.getIndex(), true, parameterDescription.getType().asErasure()) : offsetMapping);
                    }
                    this.classReader = classReader;
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                protected abstract MethodVisitor apply(MethodVisitor var1, MethodSizeHandler.ForInstrumentedMethod var2, StackMapFrameHandler.ForInstrumentedMethod var3, TypeDescription var4, MethodDescription var5, SuppressionHandler.Bound var6);

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.adviceMethod.equals(resolved.adviceMethod) && this.offsetMappings.equals(resolved.offsetMappings);
                }

                public int hashCode() {
                    int result = this.adviceMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    return result;
                }

                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDescription enterType;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDescription enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForParameter.Factory.READ_WRITE, OffsetMapping.ForBoxedArguments.Factory.READ_WRITE, OffsetMapping.ForThisReference.Factory.READ_WRITE, OffsetMapping.ForField.Factory.READ_WRITE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType, false), OffsetMapping.ForReturnValue.Factory.READ_WRITE, OffsetMapping.ForBoxedReturnValue.Factory.READ_WRITE, OffsetMapping.ForThrowable.Factory.of(adviceMethod, false)), userFactories), classReader, adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class));
                        this.enterType = enterType;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDescription enterType) {
                        TypeDescription triggeringThrowable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return triggeringThrowable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, classReader, enterType) : new WithExceptionHandler(adviceMethod, userFactories, classReader, enterType, triggeringThrowable);
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, OffsetMapping.Context.ForMethodExit.of(this.enterType)));
                        }
                        return new CodeTranslationVisitor.ForMethodExit(methodVisitor, methodSizeHandler.bindExit(this.adviceMethod, this.getTriggeringThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler, this.enterType.getStackSize().getSize() + this.getPadding().getSize());
                    }

                    @Override
                    public Bound.ForMethodExit bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(), this.classReader);
                    }

                    protected abstract StackSize getPadding();

                    @Override
                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.enterType == ((ForMethodExit)other).enterType;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDescription enterType) {
                            super(adviceMethod, userFactories, classReader, enterType);
                        }

                        @Override
                        protected StackSize getPadding() {
                            return StackSize.ZERO;
                        }

                        @Override
                        public TypeDescription getTriggeringThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodExit.WithoutExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + '}';
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription triggeringThrowable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDescription enterType, TypeDescription triggeringThrowable) {
                            super(adviceMethod, userFactories, classReader, enterType);
                            this.triggeringThrowable = triggeringThrowable;
                        }

                        @Override
                        protected StackSize getPadding() {
                            return this.triggeringThrowable.getStackSize();
                        }

                        @Override
                        public TypeDescription getTriggeringThrowable() {
                            return this.triggeringThrowable;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodExit.WithExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", triggeringThrowable=" + this.triggeringThrowable + '}';
                        }
                    }

                    protected class AdviceMethodInliner
                    extends net.bytebuddy.asm.Advice$Dispatcher$Inlining$Resolved$AdviceMethodInliner
                    implements Bound.ForMethodExit {
                        public AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader) {
                            super(instrumentedType, instrumentedMethod, methodVisitor, methodSizeHandler, stackMapFrameHandler, suppressionHandler, classReader);
                        }

                        @Override
                        public void apply() {
                            this.doApply();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodExit.AdviceMethodInliner{instrumentedType=" + this.instrumentedType + ", instrumentedMethod=" + this.instrumentedMethod + ", methodVisitor=" + this.methodVisitor + ", methodSizeHandler=" + this.methodSizeHandler + ", stackMapFrameHandler=" + this.stackMapFrameHandler + ", suppressionHandler=" + this.suppressionHandler + ", classReader=" + this.classReader + ", labels=" + this.labels + '}';
                        }
                    }
                }

                protected static class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForParameter.Factory.READ_WRITE, OffsetMapping.ForBoxedArguments.Factory.READ_WRITE, OffsetMapping.ForThisReference.Factory.READ_WRITE, OffsetMapping.ForField.Factory.READ_WRITE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.Illegal(Thrown.class, Enter.class, Return.class, BoxedReturn.class)), userFactories), classReader, adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class));
                        this.skipDispatcher = Resolved.ForMethodEnter.SkipDispatcher.ForType.of(adviceMethod);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    @Override
                    public Bound.ForMethodEnter bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(), this.classReader, this.skipDispatcher);
                    }

                    @Override
                    public TypeDescription getEnterType() {
                        return this.adviceMethod.getReturnType().asErasure();
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, OffsetMapping.Context.ForMethodEntry.of(instrumentedMethod)));
                        }
                        return new CodeTranslationVisitor.ForMethodEnter(methodVisitor, methodSizeHandler.bindEntry(this.adviceMethod), stackMapFrameHandler.bindEntry(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler);
                    }

                    @Override
                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        if (!super.equals(other)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)other;
                        return this.skipDispatcher == that.skipDispatcher && this.prependLineNumber == that.prependLineNumber;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.skipDispatcher.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Inlining.Resolved.ForMethodEnter{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", skipDispatcher=" + this.skipDispatcher + ", prependLineNumber=" + this.prependLineNumber + '}';
                    }

                    protected class AdviceMethodInliner
                    extends net.bytebuddy.asm.Advice$Dispatcher$Inlining$Resolved$AdviceMethodInliner
                    implements Bound.ForMethodEnter {
                        private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;

                        public AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader, Resolved.ForMethodEnter.SkipDispatcher skipDispatcher) {
                            super(instrumentedType, instrumentedMethod, methodVisitor, methodSizeHandler, stackMapFrameHandler, suppressionHandler, classReader);
                            this.skipDispatcher = skipDispatcher;
                        }

                        @Override
                        public void apply(Bound.SkipHandler skipHandler) {
                            this.doApply();
                            this.skipDispatcher.apply(this.methodVisitor, this.methodSizeHandler.bindEntry(ForMethodEnter.this.adviceMethod), this.stackMapFrameHandler.bindEntry(ForMethodEnter.this.adviceMethod), this.instrumentedMethod, skipHandler);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodEnter.AdviceMethodInliner{instrumentedType=" + this.instrumentedType + ", instrumentedMethod=" + this.instrumentedMethod + ", methodVisitor=" + this.methodVisitor + ", methodSizeHandler=" + this.methodSizeHandler + ", stackMapFrameHandler=" + this.stackMapFrameHandler + ", suppressionHandler=" + this.suppressionHandler + ", classReader=" + this.classReader + ", labels=" + this.labels + ", skipDispatcher=" + this.skipDispatcher + '}';
                        }
                    }
                }

                protected abstract class AdviceMethodInliner
                extends ClassVisitor
                implements Bound {
                    protected final TypeDescription instrumentedType;
                    protected final MethodDescription instrumentedMethod;
                    protected final MethodVisitor methodVisitor;
                    protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
                    protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;
                    protected final SuppressionHandler.Bound suppressionHandler;
                    protected final ClassReader classReader;
                    protected List<Label> labels;

                    protected AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader) {
                        super(327680);
                        this.instrumentedType = instrumentedType;
                        this.instrumentedMethod = instrumentedMethod;
                        this.methodVisitor = methodVisitor;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.classReader = classReader;
                        this.labels = new ArrayList<Label>();
                    }

                    @Override
                    public void prepare() {
                        this.classReader.accept(new ExceptionTableExtractor(), 6);
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    protected void doApply() {
                        this.classReader.accept(this, 2 | this.stackMapFrameHandler.getReaderHint());
                    }

                    @Override
                    public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                        return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableSubstitutor(Resolved.this.apply(this.methodVisitor, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedType, this.instrumentedMethod, this.suppressionHandler)) : IGNORE_METHOD;
                    }

                    protected class ExceptionTableSubstitutor
                    extends MethodVisitor {
                        private final Map<Label, Label> substitutions;
                        private int index;

                        protected ExceptionTableSubstitutor(MethodVisitor methodVisitor) {
                            super(327680, methodVisitor);
                            this.substitutions = new IdentityHashMap<Label, Label>();
                        }

                        @Override
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.substitutions.put(start, AdviceMethodInliner.this.labels.get(this.index++));
                            this.substitutions.put(end, AdviceMethodInliner.this.labels.get(this.index++));
                            Label actualHandler = AdviceMethodInliner.this.labels.get(this.index++);
                            this.substitutions.put(handler, actualHandler);
                            ((CodeTranslationVisitor)this.mv).propagateHandler(actualHandler);
                        }

                        @Override
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return IGNORE_ANNOTATION;
                        }

                        @Override
                        public void visitLabel(Label label) {
                            super.visitLabel(this.resolve(label));
                        }

                        @Override
                        public void visitJumpInsn(int opcode, Label label) {
                            super.visitJumpInsn(opcode, this.resolve(label));
                        }

                        @Override
                        public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... label) {
                            super.visitTableSwitchInsn(minimum, maximum, defaultOption, this.resolve(label));
                        }

                        @Override
                        public void visitLookupSwitchInsn(Label defaultOption, int[] keys, Label[] label) {
                            super.visitLookupSwitchInsn(this.resolve(defaultOption), keys, this.resolve(label));
                        }

                        private Label[] resolve(Label[] label) {
                            Label[] resolved = new Label[label.length];
                            int index = 0;
                            for (Label aLabel : label) {
                                resolved[index++] = this.resolve(aLabel);
                            }
                            return resolved;
                        }

                        private Label resolve(Label label) {
                            Label substitution = this.substitutions.get(label);
                            return substitution == null ? label : substitution;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.AdviceMethodInliner.ExceptionTableSubstitutor{methodVisitor=" + AdviceMethodInliner.this.methodVisitor + ", substitutions=" + this.substitutions + ", index=" + this.index + '}';
                        }
                    }

                    protected class ExceptionTableCollector
                    extends MethodVisitor {
                        private final MethodVisitor methodVisitor;

                        protected ExceptionTableCollector(MethodVisitor methodVisitor) {
                            super(327680);
                            this.methodVisitor = methodVisitor;
                        }

                        @Override
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.methodVisitor.visitTryCatchBlock(start, end, handler, type);
                            AdviceMethodInliner.this.labels.addAll(Arrays.asList(start, end, handler));
                        }

                        @Override
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return this.methodVisitor.visitTryCatchAnnotation(typeReference, typePath, descriptor, visible);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.AdviceMethodInliner.ExceptionTableCollector{methodVisitor=" + this.methodVisitor + '}';
                        }
                    }

                    protected class ExceptionTableExtractor
                    extends ClassVisitor {
                        protected ExceptionTableExtractor() {
                            super(327680);
                        }

                        @Override
                        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                            return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableCollector(AdviceMethodInliner.this.methodVisitor) : IGNORE_METHOD;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.AdviceMethodInliner.ExceptionTableExtractor{methodVisitor=" + AdviceMethodInliner.this.methodVisitor + '}';
                        }
                    }
                }
            }
        }

        public static enum Inactive implements Unresolved,
        Resolved.ForMethodEnter,
        Resolved.ForMethodExit,
        Bound.ForMethodEnter,
        Bound.ForMethodExit
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public TypeDescription getTriggeringThrowable() {
                return NoExceptionHandler.DESCRIPTION;
            }

            @Override
            public TypeDescription getEnterType() {
                return TypeDescription.VOID;
            }

            @Override
            public boolean isPrependLineNumber() {
                return false;
            }

            @Override
            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                return this;
            }

            @Override
            public Resolved.ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, Resolved.ForMethodEnter dispatcher) {
                return this;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void apply() {
            }

            @Override
            public void apply(Bound.SkipHandler skipHandler) {
            }

            @Override
            public Inactive bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler) {
                return this;
            }

            public String toString() {
                return "Advice.Dispatcher.Inactive." + this.name();
            }
        }

        public static interface Bound {
            public void prepare();

            public static interface ForMethodExit
            extends Bound {
                public void apply();
            }

            public static interface ForMethodEnter
            extends Bound {
                public void apply(SkipHandler var1);
            }

            public static interface SkipHandler {
                public void apply(MethodVisitor var1);
            }
        }

        public static interface Resolved
        extends Dispatcher {
            public Bound bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, MethodSizeHandler.ForInstrumentedMethod var4, StackMapFrameHandler.ForInstrumentedMethod var5);

            public static interface ForMethodExit
            extends Resolved {
                public TypeDescription getTriggeringThrowable();

                @Override
                public Bound.ForMethodExit bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, MethodSizeHandler.ForInstrumentedMethod var4, StackMapFrameHandler.ForInstrumentedMethod var5);
            }

            public static interface ForMethodEnter
            extends Resolved {
                public TypeDescription getEnterType();

                public boolean isPrependLineNumber();

                @Override
                public Bound.ForMethodEnter bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, MethodSizeHandler.ForInstrumentedMethod var4, StackMapFrameHandler.ForInstrumentedMethod var5);

                public static interface SkipDispatcher {
                    public void apply(MethodVisitor var1, MethodSizeHandler.ForAdvice var2, StackMapFrameHandler.ForAdvice var3, MethodDescription var4, Bound.SkipHandler var5);

                    public static class ForType
                    implements SkipDispatcher {
                        private final TypeDescription typeDescription;

                        protected ForType(TypeDescription typeDescription) {
                            this.typeDescription = typeDescription;
                        }

                        public static SkipDispatcher of(MethodDescription adviceMethod) {
                            return ForType.of(adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class), adviceMethod);
                        }

                        protected static SkipDispatcher of(TypeDescription typeDescription, MethodDescription adviceMethod) {
                            if (typeDescription.represents(Void.TYPE)) {
                                return Disabled.INSTANCE;
                            }
                            if (typeDescription.represents((java.lang.reflect.Type)((Object)OnDefaultValue.class))) {
                                return ForValue.of(adviceMethod.getReturnType(), false);
                            }
                            if (typeDescription.represents((java.lang.reflect.Type)((Object)OnNonDefaultValue.class))) {
                                return ForValue.of(adviceMethod.getReturnType(), true);
                            }
                            if (typeDescription.isPrimitive() || adviceMethod.getReturnType().isPrimitive()) {
                                throw new IllegalStateException("Cannot skip method by instance type for primitive return value on " + adviceMethod);
                            }
                            return new ForType(typeDescription);
                        }

                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                            methodVisitor.visitVarInsn(25, instrumentedMethod.getStackSize());
                            methodVisitor.visitTypeInsn(193, this.typeDescription.getInternalName());
                            Label noSkip = new Label();
                            methodVisitor.visitJumpInsn(153, noSkip);
                            skipHandler.apply(methodVisitor);
                            methodVisitor.visitLabel(noSkip);
                            stackMapFrameHandler.injectCompletionFrame(methodVisitor, true);
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            ForType forType = (ForType)other;
                            return this.typeDescription.equals(forType.typeDescription);
                        }

                        public int hashCode() {
                            return this.typeDescription.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.ForType{typeDescription=" + this.typeDescription + '}';
                        }
                    }

                    public static enum ForValue implements SkipDispatcher
                    {
                        FOR_INTEGER(21, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                            }
                        }
                        ,
                        FOR_LONG(22, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(136);
                            }
                        }
                        ,
                        FOR_FLOAT(23, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitInsn(149);
                                methodSizeHandler.requireStackSize(2);
                            }
                        }
                        ,
                        FOR_DOUBLE(24, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitInsn(151);
                                methodSizeHandler.requireStackSize(4);
                            }
                        }
                        ,
                        FOR_REFERENCE(25, 199, 198){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                            }
                        };

                        private final int load;
                        private final int defaultJump;
                        private final int nonDefaultJump;

                        private ForValue(int load, int defaultJump, int nonDefaultJump) {
                            this.load = load;
                            this.defaultJump = defaultJump;
                            this.nonDefaultJump = nonDefaultJump;
                        }

                        protected static SkipDispatcher of(TypeDefinition typeDefinition, boolean inverted) {
                            ForValue skipDispatcher;
                            if (typeDefinition.represents(Long.TYPE)) {
                                skipDispatcher = FOR_LONG;
                            } else if (typeDefinition.represents(Float.TYPE)) {
                                skipDispatcher = FOR_FLOAT;
                            } else if (typeDefinition.represents(Double.TYPE)) {
                                skipDispatcher = FOR_DOUBLE;
                            } else {
                                if (typeDefinition.represents(Void.TYPE)) {
                                    throw new IllegalStateException("Cannot skip on default value for void return type");
                                }
                                skipDispatcher = typeDefinition.isPrimitive() ? FOR_INTEGER : FOR_REFERENCE;
                            }
                            return inverted ? skipDispatcher.inverted() : skipDispatcher;
                        }

                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                            this.doApply(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, skipHandler, false);
                        }

                        protected void doApply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler, boolean inverted) {
                            methodVisitor.visitVarInsn(this.load, instrumentedMethod.getStackSize());
                            this.convertValue(methodVisitor, methodSizeHandler);
                            Label noSkip = new Label();
                            methodVisitor.visitJumpInsn(inverted ? this.nonDefaultJump : this.defaultJump, noSkip);
                            skipHandler.apply(methodVisitor);
                            methodVisitor.visitLabel(noSkip);
                            stackMapFrameHandler.injectCompletionFrame(methodVisitor, true);
                        }

                        protected abstract void convertValue(MethodVisitor var1, MethodSizeHandler.ForAdvice var2);

                        private SkipDispatcher inverted() {
                            return new Inverted();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.ForValue." + this.name();
                        }

                        protected class Inverted
                        implements SkipDispatcher {
                            protected Inverted() {
                            }

                            @Override
                            public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                                ForValue.this.doApply(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, skipHandler, true);
                            }

                            private SkipDispatcher getOuter() {
                                return ForValue.this;
                            }

                            public int hashCode() {
                                return ForValue.this.hashCode();
                            }

                            public boolean equals(Object other) {
                                if (other == this) {
                                    return true;
                                }
                                if (!(other instanceof Inverted)) {
                                    return false;
                                }
                                Inverted inverted = (Inverted)other;
                                return inverted.getOuter().equals(ForValue.this);
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.ForValue.Inverted{outer=" + ForValue.this + "}";
                            }
                        }
                    }

                    public static enum Disabled implements SkipDispatcher
                    {
                        INSTANCE;


                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.Disabled." + this.name();
                        }
                    }
                }
            }
        }

        public static interface SuppressionHandler {
            public Bound bind();

            public static class Suppressing
            implements SuppressionHandler {
                private final TypeDescription suppressedType;

                protected Suppressing(TypeDescription suppressedType) {
                    this.suppressedType = suppressedType;
                }

                protected static SuppressionHandler of(TypeDescription suppressedType) {
                    return suppressedType.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? NoOp.INSTANCE : new Suppressing(suppressedType);
                }

                @Override
                public net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound bind() {
                    return new Bound(this.suppressedType);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Suppressing that = (Suppressing)other;
                    return this.suppressedType.equals(that.suppressedType);
                }

                public int hashCode() {
                    return this.suppressedType.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.SuppressionHandler.Suppressing{suppressedType=" + this.suppressedType + '}';
                }

                protected static class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound {
                    private final TypeDescription suppressedType;
                    private final Label startOfMethod;
                    private final Label endOfMethod;

                    protected Bound(TypeDescription suppressedType) {
                        this.suppressedType = suppressedType;
                        this.startOfMethod = new Label();
                        this.endOfMethod = new Label();
                    }

                    @Override
                    public void onPrepare(MethodVisitor methodVisitor) {
                        methodVisitor.visitTryCatchBlock(this.startOfMethod, this.endOfMethod, this.endOfMethod, this.suppressedType.getInternalName());
                    }

                    @Override
                    public void onStart(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                        methodVisitor.visitLabel(this.startOfMethod);
                        methodSizeHandler.requireStackSize(StackSize.SINGLE.getSize());
                    }

                    @Override
                    public void onEnd(MethodVisitor methodVisitor, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        methodVisitor.visitLabel(this.endOfMethod);
                        stackMapFrameHandler.injectExceptionFrame(methodVisitor);
                        methodVisitor.visitInsn(87);
                        returnValueProducer.onDefaultValue(methodVisitor);
                    }

                    @Override
                    public void onEndSkipped(MethodVisitor methodVisitor, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        Label endOfHandler = new Label();
                        methodVisitor.visitJumpInsn(167, endOfHandler);
                        this.onEnd(methodVisitor, stackMapFrameHandler, returnValueProducer);
                        methodVisitor.visitLabel(endOfHandler);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.SuppressionHandler.Suppressing.Bound{suppressedType=" + this.suppressedType + ", startOfMethod=" + this.startOfMethod + ", endOfMethod=" + this.endOfMethod + '}';
                    }
                }
            }

            public static enum NoOp implements SuppressionHandler,
            Bound
            {
                INSTANCE;


                @Override
                public Bound bind() {
                    return this;
                }

                @Override
                public void onPrepare(MethodVisitor methodVisitor) {
                }

                @Override
                public void onStart(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                }

                @Override
                public void onEnd(MethodVisitor methodVisitor, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }

                @Override
                public void onEndSkipped(MethodVisitor methodVisitor, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }

                public String toString() {
                    return "Advice.Dispatcher.SuppressionHandler.NoOp." + this.name();
                }
            }

            public static interface Bound {
                public void onPrepare(MethodVisitor var1);

                public void onStart(MethodVisitor var1, MethodSizeHandler.ForAdvice var2);

                public void onEnd(MethodVisitor var1, StackMapFrameHandler.ForAdvice var2, ReturnValueProducer var3);

                public void onEndSkipped(MethodVisitor var1, StackMapFrameHandler.ForAdvice var2, ReturnValueProducer var3);
            }

            public static interface ReturnValueProducer {
                public void onDefaultValue(MethodVisitor var1);
            }
        }

        public static interface OffsetMapping {
            public Target resolve(TypeDescription var1, MethodDescription var2, Context var3);

            public static class Illegal
            implements Factory {
                private final List<? extends Class<? extends Annotation>> annotations;

                protected Illegal(Class<? extends Annotation> ... annotation) {
                    this(Arrays.asList(annotation));
                }

                protected Illegal(List<? extends Class<? extends Annotation>> annotations) {
                    this.annotations = annotations;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                    for (Class<? extends Annotation> clazz : this.annotations) {
                        if (!parameterDescription.getDeclaredAnnotations().isAnnotationPresent(clazz)) continue;
                        throw new IllegalStateException("Illegal annotation " + clazz + " for " + parameterDescription);
                    }
                    return UNDEFINED;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Illegal illegal = (Illegal)other;
                    return this.annotations.equals(illegal.annotations);
                }

                public int hashCode() {
                    return this.annotations.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.Illegal{annotations=" + this.annotations + '}';
                }
            }

            public static class ForUserValue<T extends Annotation>
            implements OffsetMapping {
                private final ParameterDescription.InDefinedShape target;
                private final AnnotationDescription.Loadable<T> annotation;
                private final DynamicValue<T> dynamicValue;

                protected ForUserValue(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, DynamicValue<T> dynamicValue) {
                    this.target = target;
                    this.annotation = annotation;
                    this.dynamicValue = dynamicValue;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    Object value = this.dynamicValue.resolve(instrumentedType, instrumentedMethod, this.target, this.annotation, context.isInitialized());
                    if (value == null) {
                        if (this.target.getType().isPrimitive()) {
                            throw new IllegalStateException("Cannot map null to primitive type of " + this.target);
                        }
                        return Target.ForNullConstant.READ_ONLY;
                    }
                    if (this.target.getType().asErasure().isAssignableFrom(String.class) && value instanceof String || this.target.getType().isPrimitive() && this.target.getType().asErasure().isInstanceOrWrapper(value)) {
                        if (value instanceof Boolean) {
                            value = (Boolean)value != false ? 1 : 0;
                        } else if (value instanceof Byte) {
                            value = ((Byte)value).intValue();
                        } else if (value instanceof Short) {
                            value = ((Short)value).intValue();
                        } else if (value instanceof Character) {
                            value = (int)((Character)value).charValue();
                        }
                        return new Target.ForConstantPoolValue(value);
                    }
                    if (this.target.getType().asErasure().isAssignableFrom(Class.class) && value instanceof Class) {
                        return new Target.ForConstantPoolValue(Type.getType((Class)value));
                    }
                    if (this.target.getType().asErasure().isAssignableFrom(Class.class) && value instanceof TypeDescription) {
                        return new Target.ForConstantPoolValue(Type.getType(((TypeDescription)value).getDescriptor()));
                    }
                    if (!this.target.getType().isPrimitive() && !this.target.getType().isArray() && value instanceof Serializable && this.target.getType().asErasure().isInstance(value)) {
                        return Target.ForSerializedObject.of(this.target.getType().asErasure(), (Serializable)value);
                    }
                    throw new IllegalStateException("Cannot map " + value + " as constant value of " + this.target.getType());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForUserValue that = (ForUserValue)other;
                    return this.target.equals(that.target) && this.annotation.equals(that.annotation) && this.dynamicValue.equals(that.dynamicValue);
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.annotation.hashCode();
                    result = 31 * result + this.dynamicValue.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForUserValue{target=" + this.target + ", annotation=" + this.annotation + ", dynamicValue=" + this.dynamicValue + '}';
                }

                protected static class Factory<S extends Annotation>
                implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory {
                    private final Class<S> type;
                    private final DynamicValue<S> dynamicValue;

                    protected Factory(Class<S> type, DynamicValue<S> dynamicValue) {
                        this.type = type;
                        this.dynamicValue = dynamicValue;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory of(Class<? extends Annotation> type, DynamicValue<?> dynamicValue) {
                        return new Factory<Annotation>(type, dynamicValue);
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<S> annotation = parameterDescription.getDeclaredAnnotations().ofType(this.type);
                        return annotation == null ? UNDEFINED : new ForUserValue<S>(parameterDescription, annotation, this.dynamicValue);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Factory factory = (Factory)other;
                        return this.type.equals(factory.type) && this.dynamicValue.equals(factory.dynamicValue);
                    }

                    public int hashCode() {
                        int result = this.type.hashCode();
                        result = 31 * result + this.dynamicValue.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForUserValue.Factory{type=" + this.type + ", dynamicValue=" + this.dynamicValue + '}';
                    }
                }
            }

            public static class ForThrowable
            implements OffsetMapping {
                private final TypeDescription targetType;
                private final TypeDescription triggeringThrowable;
                private final boolean readOnly;

                protected ForThrowable(TypeDescription targetType, TypeDescription triggeringThrowable, boolean readOnly) {
                    this.targetType = targetType;
                    this.triggeringThrowable = triggeringThrowable;
                    this.readOnly = readOnly;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    int offset = instrumentedMethod.getStackSize() + context.getPadding() + instrumentedMethod.getReturnType().getStackSize().getSize();
                    return this.readOnly ? new Target.ForParameter.ReadOnly(offset) : new Target.ForParameter.ReadWrite(offset);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForThrowable forThrowable = (ForThrowable)other;
                    return this.readOnly == forThrowable.readOnly && this.targetType.equals(forThrowable.targetType) && this.triggeringThrowable.equals(forThrowable.triggeringThrowable);
                }

                public int hashCode() {
                    int result = this.triggeringThrowable.hashCode();
                    result = 31 * result + this.targetType.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForThrowable{targetType=" + this.targetType + ", triggeringThrowable=" + this.triggeringThrowable + ", readOnly=" + this.readOnly + '}';
                }

                protected static class Factory
                implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory {
                    private final TypeDescription triggeringThrowable;
                    private final boolean readOnly;

                    protected Factory(TypeDescription triggeringThrowable, boolean readOnly) {
                        this.triggeringThrowable = triggeringThrowable;
                        this.readOnly = readOnly;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory of(MethodDescription.InDefinedShape adviceMethod, boolean readOnly) {
                        TypeDescription triggeringThrowable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return triggeringThrowable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new Illegal(Thrown.class) : new Factory(triggeringThrowable, readOnly);
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Thrown> annotation = parameterDescription.getDeclaredAnnotations().ofType(Thrown.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (!parameterDescription.getType().represents((java.lang.reflect.Type)((Object)Throwable.class))) {
                            throw new IllegalStateException("Parameter must be a throwable type for " + parameterDescription);
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write exception value for " + parameterDescription + " in read-only context");
                        }
                        return new ForThrowable(parameterDescription.getType().asErasure(), this.triggeringThrowable, annotation.loadSilent().readOnly());
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Factory factory = (Factory)other;
                        return this.readOnly == factory.readOnly && this.triggeringThrowable.equals(factory.triggeringThrowable);
                    }

                    public int hashCode() {
                        int result = this.triggeringThrowable.hashCode();
                        result = 31 * result + (this.readOnly ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForThrowable.Factory{triggeringThrowable=" + this.triggeringThrowable + ", readOnly=" + this.readOnly + '}';
                    }
                }
            }

            public static enum ForBoxedArguments implements OffsetMapping
            {
                READ_ONLY(true),
                READ_WRITE(false);

                private final boolean readOnly;

                private ForBoxedArguments(boolean readOnly) {
                    this.readOnly = readOnly;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    return this.readOnly ? new Target.ForBoxedArguments.ReadOnly(instrumentedMethod.getParameters()) : new Target.ForBoxedArguments.ReadWrite(instrumentedMethod.getParameters());
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForBoxedArguments." + this.name();
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<BoxedArguments> annotation = parameterDescription.getDeclaredAnnotations().ofType(BoxedArguments.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write return value from a non-writable context for " + parameterDescription);
                        }
                        if (parameterDescription.getType().represents((java.lang.reflect.Type)((Object)Object[].class))) {
                            return annotation.loadSilent().readOnly() ? READ_ONLY : READ_WRITE;
                        }
                        throw new IllegalStateException("Can only assign a boxed return value to an Object[] type for " + parameterDescription);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForBoxedArguments.Factory." + this.name();
                    }
                }
            }

            public static enum ForBoxedReturnValue implements OffsetMapping
            {
                READ_ONLY(true),
                READ_WRITE(false);

                private final boolean readOnly;

                private ForBoxedReturnValue(boolean readOnly) {
                    this.readOnly = readOnly;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    if (instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        return this.readOnly ? Target.ForNullConstant.READ_ONLY : Target.ForNullConstant.READ_WRITE;
                    }
                    if (instrumentedMethod.getReturnType().isPrimitive()) {
                        return this.readOnly ? Target.ForBoxedArgument.ReadOnly.of(instrumentedMethod.getStackSize() + context.getPadding(), instrumentedMethod.getReturnType()) : Target.ForBoxedArgument.ReadWrite.of(instrumentedMethod.getStackSize() + context.getPadding(), instrumentedMethod.getReturnType());
                    }
                    return this.readOnly ? new Target.ForParameter.ReadOnly(instrumentedMethod.getStackSize() + context.getPadding()) : new Target.ForParameter.ReadWrite(instrumentedMethod.getStackSize() + context.getPadding()).casted(instrumentedMethod.getReturnType().asErasure());
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForBoxedReturnValue." + this.name();
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<BoxedReturn> annotation = parameterDescription.getDeclaredAnnotations().ofType(BoxedReturn.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write return value from a non-writable context for " + parameterDescription);
                        }
                        if (parameterDescription.getType().represents((java.lang.reflect.Type)((Object)Object.class))) {
                            return annotation.loadSilent().readOnly() ? READ_ONLY : READ_WRITE;
                        }
                        throw new IllegalStateException("Can only assign a boxed return value to an Object type for " + parameterDescription);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForBoxedReturnValue.Factory." + this.name();
                    }
                }
            }

            public static class ForReturnValue
            implements OffsetMapping {
                private final boolean readOnly;
                private final TypeDescription targetType;

                protected ForReturnValue(boolean readOnly, TypeDescription targetType) {
                    this.readOnly = readOnly;
                    this.targetType = targetType;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    if (!this.readOnly && !instrumentedMethod.getReturnType().asErasure().equals(this.targetType)) {
                        throw new IllegalStateException("Non read-only return type of " + instrumentedMethod + " is not equal to " + this.targetType);
                    }
                    if (this.readOnly && !instrumentedMethod.getReturnType().asErasure().isAssignableTo(this.targetType)) {
                        throw new IllegalStateException("Cannot assign return type of " + instrumentedMethod + " to " + this.targetType);
                    }
                    return this.readOnly ? new Target.ForParameter.ReadOnly(instrumentedMethod.getStackSize() + context.getPadding()) : new Target.ForParameter.ReadWrite(instrumentedMethod.getStackSize() + context.getPadding());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForReturnValue that = (ForReturnValue)other;
                    return this.readOnly == that.readOnly && this.targetType.equals(that.targetType);
                }

                public int hashCode() {
                    return (this.readOnly ? 1 : 0) + 31 * this.targetType.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForReturnValue{readOnly=" + this.readOnly + ", targetType=" + this.targetType + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Return> annotation = parameterDescription.getDeclaredAnnotations().ofType(Return.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write return value for " + parameterDescription + " in read-only context");
                        }
                        return new ForReturnValue(annotation.loadSilent().readOnly(), parameterDescription.getType().asErasure());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForReturnValue.Factory." + this.name();
                    }
                }
            }

            public static enum ForEnterValue implements OffsetMapping
            {
                WRITABLE(false),
                READ_ONLY(true);

                private final boolean readOnly;

                private ForEnterValue(boolean readOnly) {
                    this.readOnly = readOnly;
                }

                public static OffsetMapping of(boolean readOnly) {
                    return readOnly ? READ_ONLY : WRITABLE;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    return this.readOnly ? new Target.ForParameter.ReadOnly(instrumentedMethod.getStackSize()) : new Target.ForParameter.ReadWrite(instrumentedMethod.getStackSize());
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForEnterValue." + this.name();
                }

                protected static class Factory
                implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory {
                    private final TypeDescription enterType;
                    private final boolean readOnly;

                    protected Factory(TypeDescription enterType, boolean readOnly) {
                        this.enterType = enterType;
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Enter> annotation = parameterDescription.getDeclaredAnnotations().ofType(Enter.class);
                        if (annotation != null) {
                            boolean readOnly = annotation.loadSilent().readOnly();
                            if (!readOnly && !this.enterType.equals(parameterDescription.getType().asErasure())) {
                                throw new IllegalStateException("read-only type of " + parameterDescription + " does not equal " + this.enterType);
                            }
                            if (readOnly && !this.enterType.isAssignableTo(parameterDescription.getType().asErasure())) {
                                throw new IllegalStateException("Cannot assign the type of " + parameterDescription + " to supplied type " + this.enterType);
                            }
                            if (this.readOnly && !readOnly) {
                                throw new IllegalStateException("Cannot write to enter value field for " + parameterDescription + " in read only context");
                            }
                            return ForEnterValue.of(readOnly);
                        }
                        return UNDEFINED;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Factory factory = (Factory)other;
                        return this.readOnly == factory.readOnly && this.enterType.equals(factory.enterType);
                    }

                    public int hashCode() {
                        int result = this.enterType.hashCode();
                        result = 31 * result + (this.readOnly ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForEnterValue.Factory{enterType=" + this.enterType + "m readOnly=" + this.readOnly + '}';
                    }
                }
            }

            public static enum ForStubValue implements OffsetMapping,
            Factory
            {
                INSTANCE;


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    return instrumentedMethod.getReturnType().isPrimitive() && !instrumentedMethod.getReturnType().represents(Void.TYPE) ? Target.ForBoxedDefaultValue.of(instrumentedMethod.getReturnType()) : Target.ForNullConstant.READ_WRITE;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                    if (!parameterDescription.getDeclaredAnnotations().isAnnotationPresent(StubValue.class)) {
                        return UNDEFINED;
                    }
                    if (!parameterDescription.getType().represents((java.lang.reflect.Type)((Object)Object.class))) {
                        throw new IllegalStateException("Cannot use StubValue on non-Object parameter type " + parameterDescription);
                    }
                    return this;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForStubValue." + this.name();
                }
            }

            public static enum ForUnusedValue implements OffsetMapping,
            Factory
            {
                INSTANCE;


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    return Target.ForDefaultValue.INSTANCE;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                    return parameterDescription.getDeclaredAnnotations().isAnnotationPresent(Unused.class) ? this : UNDEFINED;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForUnusedValue." + this.name();
                }
            }

            public static class ForOrigin
            implements OffsetMapping {
                private static final char DELIMITER = '#';
                private static final char ESCAPE = '\\';
                private final List<Renderer> renderers;

                protected ForOrigin(List<Renderer> renderers) {
                    this.renderers = renderers;
                }

                protected static OffsetMapping parse(String pattern) {
                    if (pattern.equals("")) {
                        return new ForOrigin(Collections.singletonList(Renderer.ForStringRepresentation.INSTANCE));
                    }
                    ArrayList<Renderer> renderers = new ArrayList<Renderer>(pattern.length());
                    int from = 0;
                    int to = pattern.indexOf(35);
                    while (to != -1) {
                        if (to != 0 && pattern.charAt(to - 1) == '\\' && (to == 1 || pattern.charAt(to - 2) != '\\')) {
                            renderers.add(new Renderer.ForConstantValue(pattern.substring(from, Math.max(0, to - 1)) + '#'));
                            from = to + 1;
                        } else {
                            if (pattern.length() == to + 1) {
                                throw new IllegalStateException("Missing sort descriptor for " + pattern + " at index " + to);
                            }
                            renderers.add(new Renderer.ForConstantValue(pattern.substring(from, to).replace("\\\\", "\\")));
                            switch (pattern.charAt(to + 1)) {
                                case 'm': {
                                    renderers.add(Renderer.ForMethodName.INSTANCE);
                                    break;
                                }
                                case 't': {
                                    renderers.add(Renderer.ForTypeName.INSTANCE);
                                    break;
                                }
                                case 'd': {
                                    renderers.add(Renderer.ForDescriptor.INSTANCE);
                                    break;
                                }
                                case 'r': {
                                    renderers.add(Renderer.ForReturnTypeName.INSTANCE);
                                    break;
                                }
                                case 's': {
                                    renderers.add(Renderer.ForJavaSignature.INSTANCE);
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Illegal sort descriptor " + pattern.charAt(to + 1) + " for " + pattern);
                                }
                            }
                            from = to + 2;
                        }
                        to = pattern.indexOf(35, from);
                    }
                    renderers.add(new Renderer.ForConstantValue(pattern.substring(from)));
                    return new ForOrigin(renderers);
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Renderer renderer : this.renderers) {
                        stringBuilder.append(renderer.apply(instrumentedType, instrumentedMethod));
                    }
                    return new Target.ForConstantPoolValue(stringBuilder.toString());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForOrigin forOrigin = (ForOrigin)other;
                    return this.renderers.equals(forOrigin.renderers);
                }

                public int hashCode() {
                    return this.renderers.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForOrigin{renderers=" + this.renderers + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    INSTANCE;


                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Origin> origin = parameterDescription.getDeclaredAnnotations().ofType(Origin.class);
                        if (origin == null) {
                            return UNDEFINED;
                        }
                        if (parameterDescription.getType().asErasure().represents((java.lang.reflect.Type)((Object)Class.class))) {
                            return ForInstrumentedType.INSTANCE;
                        }
                        if (parameterDescription.getType().asErasure().represents((java.lang.reflect.Type)((Object)Method.class))) {
                            return ForInstrumentedMethod.METHOD;
                        }
                        if (parameterDescription.getType().asErasure().represents((java.lang.reflect.Type)((Object)Constructor.class))) {
                            return ForInstrumentedMethod.CONSTRUCTOR;
                        }
                        if (JavaType.EXECUTABLE.getTypeStub().equals(parameterDescription.getType().asErasure())) {
                            return ForInstrumentedMethod.EXECUTABLE;
                        }
                        if (parameterDescription.getType().asErasure().isAssignableFrom(String.class)) {
                            return ForOrigin.parse(origin.loadSilent().value());
                        }
                        throw new IllegalStateException("Non-supported type " + parameterDescription.getType() + " for @Origin annotation");
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForOrigin.Factory." + this.name();
                    }
                }

                protected static interface Renderer {
                    public String apply(TypeDescription var1, MethodDescription var2);

                    public static class ForConstantValue
                    implements Renderer {
                        private final String value;

                        protected ForConstantValue(String value) {
                            this.value = value;
                        }

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return this.value;
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            ForConstantValue that = (ForConstantValue)other;
                            return this.value.equals(that.value);
                        }

                        public int hashCode() {
                            return this.value.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForConstantValue{value='" + this.value + '\'' + '}';
                        }
                    }

                    public static enum ForStringRepresentation implements Renderer
                    {
                        INSTANCE;


                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.toString();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForStringRepresentation." + this.name();
                        }
                    }

                    public static enum ForReturnTypeName implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 'r';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.getReturnType().asErasure().getName();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForReturnTypeName." + this.name();
                        }
                    }

                    public static enum ForJavaSignature implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 's';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            StringBuilder stringBuilder = new StringBuilder("(");
                            boolean comma = false;
                            for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                if (comma) {
                                    stringBuilder.append(',');
                                } else {
                                    comma = true;
                                }
                                stringBuilder.append(typeDescription.getName());
                            }
                            return stringBuilder.append(')').toString();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForJavaSignature." + this.name();
                        }
                    }

                    public static enum ForDescriptor implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 'd';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.getDescriptor();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForDescriptor." + this.name();
                        }
                    }

                    public static enum ForTypeName implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 't';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedType.getName();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForTypeName." + this.name();
                        }
                    }

                    public static enum ForMethodName implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 'm';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.getInternalName();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForMethodName." + this.name();
                        }
                    }
                }
            }

            public static abstract class ForField
            implements OffsetMapping {
                private static final MethodDescription.InDefinedShape VALUE;
                private static final MethodDescription.InDefinedShape DECLARING_TYPE;
                private static final MethodDescription.InDefinedShape READ_ONLY;
                protected final String name;
                protected final TypeDescription targetType;
                protected final boolean readOnly;

                protected ForField(String name, TypeDescription targetType, boolean readOnly) {
                    this.name = name;
                    this.targetType = targetType;
                    this.readOnly = readOnly;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    FieldLocator.Resolution resolution = this.fieldLocator(instrumentedType).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot locate field named " + this.name + " for " + instrumentedMethod);
                    }
                    if (this.readOnly && !((FieldDescription.InDefinedShape)resolution.getField().asDefined()).getType().asErasure().isAssignableTo(this.targetType)) {
                        throw new IllegalStateException("Cannot assign type of read-only field " + resolution.getField() + " to " + this.targetType);
                    }
                    if (!this.readOnly && !((FieldDescription.InDefinedShape)resolution.getField().asDefined()).getType().asErasure().equals(this.targetType)) {
                        throw new IllegalStateException("Type of field " + resolution.getField() + " is not equal to " + this.targetType);
                    }
                    if (!resolution.getField().isStatic() && instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot read non-static field " + resolution.getField() + " from static method " + instrumentedMethod);
                    }
                    if (!context.isInitialized() && !resolution.getField().isStatic()) {
                        throw new IllegalStateException("Cannot access non-static field before calling constructor: " + instrumentedMethod);
                    }
                    return this.readOnly ? new Target.ForField.ReadOnly((FieldDescription.InDefinedShape)resolution.getField().asDefined()) : new Target.ForField.ReadWrite((FieldDescription.InDefinedShape)resolution.getField().asDefined());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForField forField = (ForField)other;
                    return this.name.equals(forField.name) && this.targetType.equals(forField.targetType) && this.readOnly == forField.readOnly;
                }

                public int hashCode() {
                    int result = this.name.hashCode();
                    result = 31 * result + this.targetType.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    return result;
                }

                protected abstract FieldLocator fieldLocator(TypeDescription var1);

                static {
                    MethodList<MethodDescription.InDefinedShape> methods = new TypeDescription.ForLoadedType(FieldValue.class).getDeclaredMethods();
                    VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                    DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("declaringType"))).getOnly();
                    READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<FieldValue> annotation = parameterDescription.getDeclaredAnnotations().ofType(FieldValue.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.getValue(READ_ONLY).resolve(Boolean.class).booleanValue()) {
                            throw new IllegalStateException("Cannot write to field for " + parameterDescription + " in read-only context");
                        }
                        TypeDescription declaringType = annotation.getValue(DECLARING_TYPE).resolve(TypeDescription.class);
                        String name = annotation.getValue(VALUE).resolve(String.class);
                        TypeDescription targetType = parameterDescription.getType().asErasure();
                        return declaringType.represents(Void.TYPE) ? new WithImplicitType(name, targetType, annotation.getValue(READ_ONLY).resolve(Boolean.class)) : new WithExplicitType(name, targetType, declaringType, annotation.getValue(READ_ONLY).resolve(Boolean.class));
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForField.Factory." + this.name();
                    }
                }

                protected static class WithExplicitType
                extends ForField {
                    private final TypeDescription explicitType;

                    protected WithExplicitType(String name, TypeDescription targetType, TypeDescription locatedType, boolean readOnly) {
                        super(name, targetType, readOnly);
                        this.explicitType = locatedType;
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        if (!instrumentedType.isAssignableTo(this.explicitType)) {
                            throw new IllegalStateException(this.explicitType + " is no super type of " + instrumentedType);
                        }
                        return new FieldLocator.ForExactType(this.explicitType);
                    }

                    @Override
                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        if (!super.equals(other)) {
                            return false;
                        }
                        WithExplicitType that = (WithExplicitType)other;
                        return this.explicitType.equals(that.explicitType);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.explicitType.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForField.WithExplicitType{name=" + this.name + ", targetType=" + this.targetType + ", explicitType=" + this.explicitType + '}';
                    }
                }

                protected static class WithImplicitType
                extends ForField {
                    protected WithImplicitType(String name, TypeDescription targetType, boolean readOnly) {
                        super(name, targetType, readOnly);
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        return new FieldLocator.ForClassHierarchy(instrumentedType);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForField.WithImplicitType{name=" + this.name + ", targetType=" + this.targetType + '}';
                    }
                }
            }

            public static enum ForInstrumentedMethod implements OffsetMapping
            {
                METHOD{

                    @Override
                    protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                        return instrumentedMethod.isMethod();
                    }
                }
                ,
                CONSTRUCTOR{

                    @Override
                    protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                        return instrumentedMethod.isConstructor();
                    }
                }
                ,
                EXECUTABLE{

                    @Override
                    protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                        return false;
                    }
                };


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    if (!this.isRepresentable(instrumentedMethod)) {
                        throw new IllegalStateException("Cannot represent " + instrumentedMethod + " as given method constant");
                    }
                    return Target.ForExecutable.of((MethodDescription.InDefinedShape)instrumentedMethod.asDefined());
                }

                protected abstract boolean isRepresentable(MethodDescription var1);

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForInstrumentedMethod." + this.name();
                }
            }

            public static enum ForInstrumentedType implements OffsetMapping
            {
                INSTANCE;


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    return new Target.ForType(instrumentedType);
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForInstrumentedType." + this.name();
                }
            }

            public static class ForThisReference
            implements OffsetMapping {
                private static final int THIS_REFERENCE = 0;
                private final boolean readOnly;
                private final boolean optional;
                private final TypeDescription targetType;

                protected ForThisReference(boolean readOnly, boolean optional, TypeDescription targetType) {
                    this.readOnly = readOnly;
                    this.optional = optional;
                    this.targetType = targetType;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    if (!this.readOnly && !instrumentedType.equals(this.targetType)) {
                        throw new IllegalStateException("Declaring type of " + instrumentedMethod + " is not equal to read-only " + this.targetType);
                    }
                    if (this.readOnly && !instrumentedType.isAssignableTo(this.targetType)) {
                        throw new IllegalStateException("Declaring type of " + instrumentedMethod + " is not assignable to " + this.targetType);
                    }
                    if (instrumentedMethod.isStatic() && this.optional) {
                        return this.readOnly ? Target.ForNullConstant.READ_ONLY : Target.ForNullConstant.READ_WRITE;
                    }
                    if (instrumentedMethod.isStatic() && !this.optional) {
                        throw new IllegalStateException("Cannot map this reference for static method " + instrumentedMethod);
                    }
                    if (!context.isInitialized()) {
                        throw new IllegalStateException("Cannot access this reference before calling constructor: " + instrumentedMethod);
                    }
                    return this.readOnly ? new Target.ForParameter.ReadOnly(0) : new Target.ForParameter.ReadWrite(0);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForThisReference that = (ForThisReference)other;
                    return this.readOnly == that.readOnly && this.optional == that.optional && this.targetType.equals(that.targetType);
                }

                public int hashCode() {
                    int result = this.readOnly ? 1 : 0;
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.targetType.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForThisReference{readOnly=" + this.readOnly + ", optional=" + this.optional + ", targetType=" + this.targetType + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<This> annotation = parameterDescription.getDeclaredAnnotations().ofType(This.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write to this reference for " + parameterDescription + " in read-only context");
                        }
                        return new ForThisReference(annotation.loadSilent().readOnly(), annotation.loadSilent().optional(), parameterDescription.getType().asErasure());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForThisReference.Factory." + this.name();
                    }
                }
            }

            public static class ForParameter
            implements OffsetMapping {
                private final int index;
                private final boolean readOnly;
                private final TypeDescription targetType;

                protected ForParameter(Argument argument, TypeDescription targetType) {
                    this(argument.value(), argument.readOnly(), targetType);
                }

                protected ForParameter(int index, boolean readOnly, TypeDescription targetType) {
                    this.index = index;
                    this.readOnly = readOnly;
                    this.targetType = targetType;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Context context) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (parameters.size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not define an index " + this.index);
                    }
                    if (!this.readOnly && !((ParameterDescription)parameters.get(this.index)).getType().asErasure().equals(this.targetType)) {
                        throw new IllegalStateException("read-only " + this.targetType + " is not equal to type of " + parameters.get(this.index));
                    }
                    if (this.readOnly && !((ParameterDescription)parameters.get(this.index)).getType().asErasure().isAssignableTo(this.targetType)) {
                        throw new IllegalStateException(this.targetType + " is not assignable to " + parameters.get(this.index));
                    }
                    return this.readOnly ? new Target.ForParameter.ReadOnly(((ParameterDescription)parameters.get(this.index)).getOffset()) : new Target.ForParameter.ReadWrite(((ParameterDescription)parameters.get(this.index)).getOffset());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForParameter that = (ForParameter)other;
                    return this.index == that.index && this.readOnly == that.readOnly && this.targetType.equals(that.targetType);
                }

                public int hashCode() {
                    int result = this.index;
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.targetType.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForParameter{index=" + this.index + ", readOnly=" + this.readOnly + ", targetType=" + this.targetType + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Argument> annotation = parameterDescription.getDeclaredAnnotations().ofType(Argument.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot define writable field access for " + parameterDescription);
                        }
                        return new ForParameter(annotation.loadSilent(), parameterDescription.getType().asErasure());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForParameter.Factory." + this.name();
                    }
                }
            }

            public static interface Factory {
                public static final OffsetMapping UNDEFINED = null;

                public OffsetMapping make(ParameterDescription.InDefinedShape var1);
            }

            public static interface Target {
                public static final int NO_PADDING = 0;

                public int resolveAccess(MethodVisitor var1, int var2);

                public int resolveIncrement(MethodVisitor var1, int var2);

                public static class ForSerializedObject
                implements Target {
                    private static final String CHARSET = "ISO-8859-1";
                    private final TypeDescription target;
                    private final String serialized;

                    protected ForSerializedObject(TypeDescription target, String serialized) {
                        this.target = target;
                        this.serialized = serialized;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected static Target of(TypeDescription target, Serializable value) {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                            try {
                                objectOutputStream.writeObject(value);
                            }
                            finally {
                                objectOutputStream.close();
                            }
                            return new ForSerializedObject(target, byteArrayOutputStream.toString(CHARSET));
                        }
                        catch (IOException exception) {
                            throw new IllegalStateException("Cannot serialize " + value, exception);
                        }
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                methodVisitor.visitTypeInsn(187, Type.getInternalName(ObjectInputStream.class));
                                methodVisitor.visitInsn(89);
                                methodVisitor.visitTypeInsn(187, Type.getInternalName(ByteArrayInputStream.class));
                                methodVisitor.visitInsn(89);
                                methodVisitor.visitLdcInsn(this.serialized);
                                methodVisitor.visitLdcInsn(CHARSET);
                                methodVisitor.visitMethodInsn(182, Type.getInternalName(String.class), "getBytes", Type.getMethodType(Type.getType(byte[].class), Type.getType(String.class)).toString(), false);
                                methodVisitor.visitMethodInsn(183, Type.getInternalName(ByteArrayInputStream.class), "<init>", Type.getMethodType(Type.VOID_TYPE, Type.getType(byte[].class)).toString(), false);
                                methodVisitor.visitMethodInsn(183, Type.getInternalName(ObjectInputStream.class), "<init>", Type.getMethodType(Type.VOID_TYPE, Type.getType(InputStream.class)).toString(), false);
                                methodVisitor.visitMethodInsn(182, Type.getInternalName(ObjectInputStream.class), "readObject", Type.getMethodType(Type.getType(Object.class), new Type[0]).toString(), false);
                                methodVisitor.visitTypeInsn(192, this.target.getInternalName());
                                return 5;
                            }
                        }
                        throw new IllegalStateException("Unexpected opcode: " + opcode);
                    }

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Cannot increment serialized object");
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForSerializedObject that = (ForSerializedObject)other;
                        return this.target.equals(that.target) && this.serialized.equals(that.serialized);
                    }

                    public int hashCode() {
                        int result = this.target.hashCode();
                        result = 31 * result + this.serialized.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForSerializedObject{target=" + this.target + ", serialized='" + this.serialized + '\'' + '}';
                    }
                }

                public static enum ForNullConstant implements Target
                {
                    READ_ONLY{

                        @Override
                        protected void onWrite(MethodVisitor methodVisitor) {
                            throw new IllegalStateException("Cannot write to read-only value");
                        }
                    }
                    ,
                    READ_WRITE{

                        @Override
                        protected void onWrite(MethodVisitor methodVisitor) {
                            methodVisitor.visitInsn(87);
                        }
                    };


                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                methodVisitor.visitInsn(1);
                                break;
                            }
                            case 58: {
                                this.onWrite(methodVisitor);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected opcode: " + opcode);
                            }
                        }
                        return 0;
                    }

                    protected abstract void onWrite(MethodVisitor var1);

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Cannot increment a null constant");
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForNullConstant." + this.name();
                    }
                }

                public static abstract class ForExecutable
                implements Target {
                    protected final MethodDescription.InDefinedShape methodDescription;

                    protected ForExecutable(MethodDescription.InDefinedShape methodDescription) {
                        this.methodDescription = methodDescription;
                    }

                    public static Target of(MethodDescription.InDefinedShape methodDescription) {
                        if (methodDescription.isMethod()) {
                            return new ForMethod(methodDescription);
                        }
                        if (methodDescription.isConstructor()) {
                            return new ForConstructor(methodDescription);
                        }
                        throw new IllegalStateException("Cannot represent type initializer of " + methodDescription.getDeclaringType() + " as constant");
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                ForType.load(methodVisitor, this.methodDescription.getDeclaringType());
                                this.loadMethodName(methodVisitor);
                                PrimitiveDispatcher.loadInteger(methodVisitor, this.methodDescription.getParameters().size());
                                methodVisitor.visitTypeInsn(189, TypeDescription.CLASS.getInternalName());
                                for (ParameterDescription parameterDescription : this.methodDescription.getParameters()) {
                                    methodVisitor.visitInsn(89);
                                    PrimitiveDispatcher.loadInteger(methodVisitor, parameterDescription.getIndex());
                                    if (parameterDescription.getType().isPrimitive()) {
                                        PrimitiveDispatcher.of(parameterDescription.getType()).loadType(methodVisitor);
                                    } else {
                                        ForType.load(methodVisitor, parameterDescription.getType().asErasure());
                                    }
                                    methodVisitor.visitInsn(83);
                                }
                                methodVisitor.visitMethodInsn(182, TypeDescription.CLASS.getInternalName(), this.getInvokedMethod(), this.getInvokedSignature(), false);
                                return this.getAdditionalOffset() + (this.methodDescription.getParameters().isEmpty() ? 0 : 3);
                            }
                        }
                        throw new IllegalStateException("Unexpected opcode: " + opcode);
                    }

                    protected abstract void loadMethodName(MethodVisitor var1);

                    protected abstract String getInvokedMethod();

                    protected abstract String getInvokedSignature();

                    protected abstract int getAdditionalOffset();

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Unexpected increment");
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForExecutable that = (ForExecutable)object;
                        return this.methodDescription.equals(that.methodDescription);
                    }

                    public int hashCode() {
                        return this.methodDescription.hashCode();
                    }

                    protected static class ForConstructor
                    extends ForExecutable {
                        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
                            super(methodDescription);
                        }

                        @Override
                        protected void loadMethodName(MethodVisitor methodVisitor) {
                        }

                        @Override
                        protected String getInvokedMethod() {
                            return "getDeclaredConstructor";
                        }

                        @Override
                        protected String getInvokedSignature() {
                            return Type.getMethodDescriptor(Type.getType(Constructor.class), Type.getType(Class[].class));
                        }

                        @Override
                        protected int getAdditionalOffset() {
                            return 1;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForExecutable.ForConstructor{methodDescription=" + this.methodDescription + "}";
                        }
                    }

                    protected static class ForMethod
                    extends ForExecutable {
                        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
                            super(methodDescription);
                        }

                        @Override
                        protected void loadMethodName(MethodVisitor methodVisitor) {
                            methodVisitor.visitLdcInsn(this.methodDescription.getInternalName());
                        }

                        @Override
                        protected String getInvokedMethod() {
                            return "getDeclaredMethod";
                        }

                        @Override
                        protected String getInvokedSignature() {
                            return Type.getMethodDescriptor(Type.getType(Method.class), Type.getType(String.class), Type.getType(Class[].class));
                        }

                        @Override
                        protected int getAdditionalOffset() {
                            return 2;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForExecutable.ForMethod{methodDescription=" + this.methodDescription + "}";
                        }
                    }
                }

                public static abstract class ForBoxedArguments
                implements Target {
                    protected final List<? extends ParameterDescription> parameters;

                    protected ForBoxedArguments(List<? extends ParameterDescription> parameters) {
                        this.parameters = parameters;
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                PrimitiveDispatcher.loadInteger(methodVisitor, this.parameters.size());
                                methodVisitor.visitTypeInsn(189, TypeDescription.OBJECT.getInternalName());
                                StackSize stackSize = StackSize.ZERO;
                                for (ParameterDescription parameterDescription : this.parameters) {
                                    methodVisitor.visitInsn(89);
                                    PrimitiveDispatcher.loadInteger(methodVisitor, parameterDescription.getIndex());
                                    if (parameterDescription.getType().isPrimitive()) {
                                        PrimitiveDispatcher.of(parameterDescription.getType()).loadBoxed(methodVisitor, parameterDescription.getOffset());
                                    } else {
                                        methodVisitor.visitVarInsn(25, parameterDescription.getOffset());
                                    }
                                    methodVisitor.visitInsn(83);
                                    stackSize = stackSize.maximum(parameterDescription.getType().getStackSize());
                                }
                                return stackSize.getSize() + (this.parameters.isEmpty() ? 0 : 2);
                            }
                            case 58: {
                                return this.onStore(methodVisitor);
                            }
                        }
                        throw new IllegalStateException("Unexpected opcode: " + opcode);
                    }

                    protected abstract int onStore(MethodVisitor var1);

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Cannot increment a boxed argument");
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForBoxedArguments that = (ForBoxedArguments)other;
                        return this.parameters.equals(that.parameters);
                    }

                    public int hashCode() {
                        return this.parameters.hashCode();
                    }

                    protected static class ReadWrite
                    extends ForBoxedArguments {
                        protected ReadWrite(List<? extends ParameterDescription> parameters) {
                            super(parameters);
                        }

                        @Override
                        protected int onStore(MethodVisitor methodVisitor) {
                            StackSize stackSize = StackSize.ZERO;
                            for (ParameterDescription parameter : this.parameters) {
                                methodVisitor.visitInsn(89);
                                PrimitiveDispatcher.loadInteger(methodVisitor, parameter.getIndex());
                                methodVisitor.visitInsn(50);
                                if (parameter.getType().isPrimitive()) {
                                    PrimitiveDispatcher.of(parameter.getType()).storeUnboxed(methodVisitor, parameter.getOffset());
                                } else {
                                    if (!parameter.getType().represents((java.lang.reflect.Type)((Object)Object.class))) {
                                        methodVisitor.visitTypeInsn(192, parameter.getType().asErasure().getInternalName());
                                    }
                                    methodVisitor.visitVarInsn(58, parameter.getOffset());
                                }
                                stackSize = stackSize.maximum(parameter.getType().getStackSize());
                            }
                            methodVisitor.visitInsn(87);
                            return stackSize.getSize() + (this.parameters.isEmpty() ? 0 : 2);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForBoxedArguments.ReadWrite{parameters=" + this.parameters + '}';
                        }
                    }

                    protected static class ReadOnly
                    extends ForBoxedArguments {
                        protected ReadOnly(List<? extends ParameterDescription> parameters) {
                            super(parameters);
                        }

                        @Override
                        protected int onStore(MethodVisitor methodVisitor) {
                            throw new IllegalStateException("Cannot write to read-only parameter");
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForBoxedArguments.ReadOnly{parameters=" + this.parameters + '}';
                        }
                    }
                }

                public static abstract class ForBoxedArgument
                implements Target {
                    protected final int offset;
                    protected final PrimitiveDispatcher primitiveDispatcher;

                    protected ForBoxedArgument(int offset, PrimitiveDispatcher primitiveDispatcher) {
                        this.offset = offset;
                        this.primitiveDispatcher = primitiveDispatcher;
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                this.primitiveDispatcher.loadBoxed(methodVisitor, this.offset);
                                return this.primitiveDispatcher.getStackSize().getSize() - 1;
                            }
                            case 58: {
                                this.onStore(methodVisitor);
                                return 0;
                            }
                        }
                        throw new IllegalStateException("Unexpected opcode: " + opcode);
                    }

                    protected abstract void onStore(MethodVisitor var1);

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Cannot increment a boxed parameter");
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForBoxedArgument that = (ForBoxedArgument)other;
                        return this.offset == that.offset && this.primitiveDispatcher == that.primitiveDispatcher;
                    }

                    public int hashCode() {
                        int result = this.offset;
                        result = 31 * result + this.primitiveDispatcher.hashCode();
                        return result;
                    }

                    protected static class ReadWrite
                    extends ForBoxedArgument {
                        protected ReadWrite(int offset, PrimitiveDispatcher primitiveDispatcher) {
                            super(offset, primitiveDispatcher);
                        }

                        protected static Target of(int offset, TypeDefinition type) {
                            return new ReadWrite(offset, PrimitiveDispatcher.of(type));
                        }

                        @Override
                        protected void onStore(MethodVisitor methodVisitor) {
                            this.primitiveDispatcher.storeUnboxed(methodVisitor, this.offset);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForBoxedArgument.ReadWrite{offset=" + this.offset + ", primitiveDispatcher=" + (Object)((Object)this.primitiveDispatcher) + '}';
                        }
                    }

                    protected static class ReadOnly
                    extends ForBoxedArgument {
                        protected ReadOnly(int offset, PrimitiveDispatcher primitiveDispatcher) {
                            super(offset, primitiveDispatcher);
                        }

                        protected static Target of(int offset, TypeDefinition type) {
                            return new ReadOnly(offset, PrimitiveDispatcher.of(type));
                        }

                        @Override
                        protected void onStore(MethodVisitor methodVisitor) {
                            throw new IllegalStateException("Cannot write to read-only boxed parameter");
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForBoxedArgument.ReadOnly{offset=" + this.offset + ", primitiveDispatcher=" + (Object)((Object)this.primitiveDispatcher) + '}';
                        }
                    }
                }

                public static class ForType
                implements Target {
                    private final TypeDescription typeDescription;

                    public ForType(TypeDescription typeDescription) {
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                ForType.load(methodVisitor, this.typeDescription);
                                return 0;
                            }
                        }
                        throw new IllegalStateException("Cannot write to fixed value: " + this.typeDescription);
                    }

                    protected static void load(MethodVisitor methodVisitor, TypeDescription typeDescription) {
                        methodVisitor.visitLdcInsn(typeDescription.getName());
                        methodVisitor.visitMethodInsn(184, TypeDescription.CLASS.getInternalName(), "forName", Type.getMethodDescriptor(Type.getType(Class.class), Type.getType(String.class)), false);
                    }

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Unexpected increment");
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForType forType = (ForType)object;
                        return this.typeDescription.equals(forType.typeDescription);
                    }

                    public int hashCode() {
                        return this.typeDescription.hashCode();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForType{typeDescription=" + this.typeDescription + '}';
                    }
                }

                public static class ForConstantPoolValue
                implements Target {
                    private final Object value;

                    protected ForConstantPoolValue(Object value) {
                        this.value = value;
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                throw new IllegalStateException("Cannot write to fixed value: " + this.value);
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                methodVisitor.visitLdcInsn(this.value);
                                return 0;
                            }
                        }
                        throw new IllegalArgumentException("Did not expect opcode: " + opcode);
                    }

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Cannot write to fixed value: " + this.value);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForConstantPoolValue that = (ForConstantPoolValue)other;
                        return this.value.equals(that.value);
                    }

                    public int hashCode() {
                        return this.value.hashCode();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForConstantPoolValue{value=" + this.value + '}';
                    }
                }

                public static abstract class ForField
                implements Target {
                    protected final FieldDescription.InDefinedShape fieldDescription;

                    protected ForField(FieldDescription.InDefinedShape fieldDescription) {
                        this.fieldDescription = fieldDescription;
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 54: 
                            case 56: 
                            case 58: {
                                return this.onWriteSingle(methodVisitor);
                            }
                            case 55: 
                            case 57: {
                                return this.onWriteDouble(methodVisitor);
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                if (this.fieldDescription.isStatic()) {
                                    this.accessField(methodVisitor, 178);
                                } else {
                                    methodVisitor.visitVarInsn(25, 0);
                                    this.accessField(methodVisitor, 180);
                                }
                                return 0;
                            }
                        }
                        throw new IllegalArgumentException("Did not expect opcode: " + opcode);
                    }

                    protected abstract int onWriteSingle(MethodVisitor var1);

                    protected abstract int onWriteDouble(MethodVisitor var1);

                    protected void accessField(MethodVisitor methodVisitor, int opcode) {
                        methodVisitor.visitFieldInsn(opcode, this.fieldDescription.getDeclaringType().asErasure().getInternalName(), this.fieldDescription.getInternalName(), this.fieldDescription.getDescriptor());
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForField forField = (ForField)other;
                        return this.fieldDescription.equals(forField.fieldDescription);
                    }

                    public int hashCode() {
                        return this.fieldDescription.hashCode();
                    }

                    protected static class ReadWrite
                    extends ForField {
                        protected ReadWrite(FieldDescription.InDefinedShape fieldDescription) {
                            super(fieldDescription);
                        }

                        @Override
                        protected int onWriteSingle(MethodVisitor methodVisitor) {
                            if (!this.fieldDescription.isStatic()) {
                                methodVisitor.visitVarInsn(25, 0);
                                methodVisitor.visitInsn(90);
                                methodVisitor.visitInsn(87);
                                this.accessField(methodVisitor, 181);
                                return 2;
                            }
                            this.accessField(methodVisitor, 179);
                            return 0;
                        }

                        @Override
                        protected int onWriteDouble(MethodVisitor methodVisitor) {
                            if (!this.fieldDescription.isStatic()) {
                                methodVisitor.visitVarInsn(25, 0);
                                methodVisitor.visitInsn(91);
                                methodVisitor.visitInsn(87);
                                this.accessField(methodVisitor, 181);
                                return 2;
                            }
                            this.accessField(methodVisitor, 179);
                            return 0;
                        }

                        @Override
                        public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                            if (this.fieldDescription.isStatic()) {
                                this.accessField(methodVisitor, 178);
                                methodVisitor.visitInsn(4);
                                methodVisitor.visitInsn(96);
                                this.accessField(methodVisitor, 179);
                                return 0;
                            }
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitInsn(89);
                            this.accessField(methodVisitor, 180);
                            methodVisitor.visitInsn(4);
                            methodVisitor.visitInsn(96);
                            this.accessField(methodVisitor, 181);
                            return 2;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForField.ReadWrite{fieldDescription=" + this.fieldDescription + "}";
                        }
                    }

                    protected static class ReadOnly
                    extends ForField {
                        protected ReadOnly(FieldDescription.InDefinedShape fieldDescription) {
                            super(fieldDescription);
                        }

                        @Override
                        protected int onWriteSingle(MethodVisitor methodVisitor) {
                            throw new IllegalStateException("Cannot write to read-only field " + this.fieldDescription);
                        }

                        @Override
                        protected int onWriteDouble(MethodVisitor methodVisitor) {
                            throw new IllegalStateException("Cannot write to read-only field " + this.fieldDescription);
                        }

                        @Override
                        public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                            throw new IllegalStateException("Cannot write to read-only field " + this.fieldDescription);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForField.ReadOnly{fieldDescription=" + this.fieldDescription + "}";
                        }
                    }
                }

                public static abstract class ForParameter
                implements Target {
                    protected final int offset;

                    protected ForParameter(int offset) {
                        this.offset = offset;
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                this.onWrite(methodVisitor, opcode);
                                break;
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                methodVisitor.visitVarInsn(opcode, this.offset);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Did not expect opcode: " + opcode);
                            }
                        }
                        return 0;
                    }

                    protected abstract void onWrite(MethodVisitor var1, int var2);

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForParameter forParameter = (ForParameter)other;
                        return this.offset == forParameter.offset;
                    }

                    public int hashCode() {
                        return this.offset;
                    }

                    protected static class ReadWrite
                    extends ForParameter {
                        protected ReadWrite(int offset) {
                            super(offset);
                        }

                        @Override
                        protected void onWrite(MethodVisitor methodVisitor, int opcode) {
                            methodVisitor.visitVarInsn(opcode, this.offset);
                        }

                        protected Target casted(TypeDescription targetType) {
                            return targetType.represents((java.lang.reflect.Type)((Object)Object.class)) ? this : new WithCasting(this.offset, targetType);
                        }

                        @Override
                        public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                            methodVisitor.visitIincInsn(this.offset, increment);
                            return 0;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForParameter.ReadWrite{offset=" + this.offset + "}";
                        }

                        protected static class WithCasting
                        extends ReadWrite {
                            private final TypeDescription targetType;

                            protected WithCasting(int offset, TypeDescription targetType) {
                                super(offset);
                                this.targetType = targetType;
                            }

                            @Override
                            protected void onWrite(MethodVisitor methodVisitor, int opcode) {
                                methodVisitor.visitTypeInsn(192, this.targetType.getInternalName());
                                super.onWrite(methodVisitor, opcode);
                            }

                            @Override
                            public boolean equals(Object other) {
                                if (this == other) {
                                    return true;
                                }
                                if (other == null || this.getClass() != other.getClass()) {
                                    return false;
                                }
                                if (!super.equals(other)) {
                                    return false;
                                }
                                WithCasting that = (WithCasting)other;
                                return this.targetType.equals(that.targetType);
                            }

                            @Override
                            public int hashCode() {
                                int result = super.hashCode();
                                result = 31 * result + this.targetType.hashCode();
                                return result;
                            }

                            @Override
                            public String toString() {
                                return "Advice.Dispatcher.OffsetMapping.Target.ForParameter.ReadWrite.WithCasting{offset=" + this.offset + ", targetType=" + this.targetType + "}";
                            }
                        }
                    }

                    protected static class ReadOnly
                    extends ForParameter {
                        protected ReadOnly(int offset) {
                            super(offset);
                        }

                        @Override
                        protected void onWrite(MethodVisitor methodVisitor, int opcode) {
                            throw new IllegalStateException("Cannot write to read-only value");
                        }

                        @Override
                        public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                            throw new IllegalStateException("Cannot write to read-only parameter at offset " + this.offset);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForParameter.ReadOnly{offset=" + this.offset + "}";
                        }
                    }
                }

                public static class ForBoxedDefaultValue
                implements Target {
                    private final PrimitiveDispatcher primitiveDispatcher;

                    protected ForBoxedDefaultValue(PrimitiveDispatcher primitiveDispatcher) {
                        this.primitiveDispatcher = primitiveDispatcher;
                    }

                    protected static Target of(TypeDefinition typeDefinition) {
                        return new ForBoxedDefaultValue(PrimitiveDispatcher.of(typeDefinition));
                    }

                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                this.primitiveDispatcher.pushBoxedDefault(methodVisitor);
                                return this.primitiveDispatcher.getStackSize().getSize() - 1;
                            }
                            case 58: {
                                methodVisitor.visitInsn(87);
                                return 0;
                            }
                        }
                        throw new IllegalStateException("Unexpected opcode: " + opcode);
                    }

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        throw new IllegalStateException("Unexpected incrementation for boxed default value");
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        ForBoxedDefaultValue that = (ForBoxedDefaultValue)other;
                        return this.primitiveDispatcher == that.primitiveDispatcher;
                    }

                    public int hashCode() {
                        return this.primitiveDispatcher.hashCode();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForBoxedDefaultValue{primitiveDispatcher=" + (Object)((Object)this.primitiveDispatcher) + '}';
                    }
                }

                public static enum ForDefaultValue implements Target
                {
                    INSTANCE;


                    @Override
                    public int resolveAccess(MethodVisitor methodVisitor, int opcode) {
                        switch (opcode) {
                            case 25: {
                                methodVisitor.visitInsn(1);
                                break;
                            }
                            case 21: {
                                methodVisitor.visitInsn(3);
                                break;
                            }
                            case 22: {
                                methodVisitor.visitInsn(9);
                                break;
                            }
                            case 23: {
                                methodVisitor.visitInsn(11);
                                break;
                            }
                            case 24: {
                                methodVisitor.visitInsn(14);
                                break;
                            }
                            case 54: 
                            case 56: 
                            case 58: {
                                methodVisitor.visitInsn(87);
                                break;
                            }
                            case 55: 
                            case 57: {
                                methodVisitor.visitInsn(88);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected opcode: " + opcode);
                            }
                        }
                        return 0;
                    }

                    @Override
                    public int resolveIncrement(MethodVisitor methodVisitor, int increment) {
                        return 0;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForDefaultValue." + this.name();
                    }
                }

                public static enum PrimitiveDispatcher {
                    BOOLEAN(3, 21, 54, Boolean.class, Boolean.TYPE, "booleanValue"),
                    BYTE(3, 21, 54, Byte.class, Byte.TYPE, "byteValue"),
                    SHORT(3, 21, 54, Short.class, Short.TYPE, "shortValue"),
                    CHARACTER(3, 21, 54, Character.class, Character.TYPE, "charValue"),
                    INTEGER(3, 21, 54, Integer.class, Integer.TYPE, "intValue"),
                    LONG(9, 22, 55, Long.class, Long.TYPE, "longValue"),
                    FLOAT(11, 23, 56, Float.class, Float.TYPE, "floatValue"),
                    DOUBLE(14, 24, 57, Double.class, Double.TYPE, "doubleValue");

                    private static final String VALUE_OF = "valueOf";
                    private final int defaultValue;
                    private final int load;
                    private final int store;
                    private final String unboxingMethod;
                    private final String owner;
                    private final String boxingDescriptor;
                    private final String unboxingDescriptor;
                    private final StackSize stackSize;

                    private PrimitiveDispatcher(int defaultValue, int load, int store, Class<?> wrapperType, Class<?> primitiveType, String unboxingMethod) {
                        this.defaultValue = defaultValue;
                        this.load = load;
                        this.store = store;
                        this.unboxingMethod = unboxingMethod;
                        this.owner = Type.getInternalName(wrapperType);
                        this.boxingDescriptor = Type.getMethodDescriptor(Type.getType(wrapperType), Type.getType(primitiveType));
                        this.unboxingDescriptor = Type.getMethodDescriptor(Type.getType(primitiveType), new Type[0]);
                        this.stackSize = StackSize.of(primitiveType);
                    }

                    protected static PrimitiveDispatcher of(TypeDefinition typeDefinition) {
                        if (typeDefinition.represents(Boolean.TYPE)) {
                            return BOOLEAN;
                        }
                        if (typeDefinition.represents(Byte.TYPE)) {
                            return BYTE;
                        }
                        if (typeDefinition.represents(Short.TYPE)) {
                            return SHORT;
                        }
                        if (typeDefinition.represents(Character.TYPE)) {
                            return CHARACTER;
                        }
                        if (typeDefinition.represents(Integer.TYPE)) {
                            return INTEGER;
                        }
                        if (typeDefinition.represents(Long.TYPE)) {
                            return LONG;
                        }
                        if (typeDefinition.represents(Float.TYPE)) {
                            return FLOAT;
                        }
                        if (typeDefinition.represents(Double.TYPE)) {
                            return DOUBLE;
                        }
                        throw new IllegalArgumentException("Cannot box: " + typeDefinition);
                    }

                    protected static void loadInteger(MethodVisitor methodVisitor, int value) {
                        switch (value) {
                            case 0: {
                                methodVisitor.visitInsn(3);
                                break;
                            }
                            case 1: {
                                methodVisitor.visitInsn(4);
                                break;
                            }
                            case 2: {
                                methodVisitor.visitInsn(5);
                                break;
                            }
                            case 3: {
                                methodVisitor.visitInsn(6);
                                break;
                            }
                            case 4: {
                                methodVisitor.visitInsn(7);
                                break;
                            }
                            case 5: {
                                methodVisitor.visitInsn(8);
                                break;
                            }
                            default: {
                                if (value < 127) {
                                    methodVisitor.visitIntInsn(16, value);
                                    break;
                                }
                                if (value < Short.MAX_VALUE) {
                                    methodVisitor.visitIntInsn(17, value);
                                    break;
                                }
                                methodVisitor.visitLdcInsn(value);
                            }
                        }
                    }

                    protected void loadBoxed(MethodVisitor methodVisitor, int offset) {
                        methodVisitor.visitVarInsn(this.load, offset);
                        methodVisitor.visitMethodInsn(184, this.owner, VALUE_OF, this.boxingDescriptor, false);
                    }

                    protected void storeUnboxed(MethodVisitor methodVisitor, int offset) {
                        methodVisitor.visitTypeInsn(192, this.owner);
                        methodVisitor.visitMethodInsn(182, this.owner, this.unboxingMethod, this.unboxingDescriptor, false);
                        methodVisitor.visitVarInsn(this.store, offset);
                    }

                    protected void pushBoxedDefault(MethodVisitor methodVisitor) {
                        methodVisitor.visitInsn(this.defaultValue);
                        methodVisitor.visitMethodInsn(184, this.owner, VALUE_OF, this.boxingDescriptor, false);
                    }

                    protected void loadType(MethodVisitor methodVisitor) {
                        methodVisitor.visitFieldInsn(178, this.owner, "TYPE", Type.getDescriptor(Class.class));
                    }

                    protected StackSize getStackSize() {
                        return this.stackSize;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.PrimitiveDispatcher." + this.name();
                    }
                }
            }

            public static interface Context {
                public boolean isInitialized();

                public int getPadding();

                public static enum ForMethodExit implements Context
                {
                    ZERO(StackSize.ZERO),
                    SINGLE(StackSize.SINGLE),
                    DOUBLE(StackSize.DOUBLE);

                    private final StackSize stackSize;

                    private ForMethodExit(StackSize stackSize) {
                        this.stackSize = stackSize;
                    }

                    protected static Context of(TypeDescription typeDescription) {
                        switch (typeDescription.getStackSize()) {
                            case ZERO: {
                                return ZERO;
                            }
                            case SINGLE: {
                                return SINGLE;
                            }
                            case DOUBLE: {
                                return DOUBLE;
                            }
                        }
                        throw new IllegalStateException("Unknown stack size: " + typeDescription);
                    }

                    @Override
                    public boolean isInitialized() {
                        return true;
                    }

                    @Override
                    public int getPadding() {
                        return this.stackSize.getSize();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Context.ForMethodExit." + this.name();
                    }
                }

                public static enum ForMethodEntry implements Context
                {
                    INITIALIZED(true),
                    NON_INITIALIZED(false);

                    private final boolean initialized;

                    protected static Context of(MethodDescription instrumentedMethod) {
                        return instrumentedMethod.isConstructor() ? NON_INITIALIZED : INITIALIZED;
                    }

                    private ForMethodEntry(boolean initialized) {
                        this.initialized = initialized;
                    }

                    @Override
                    public boolean isInitialized() {
                        return this.initialized;
                    }

                    @Override
                    public int getPadding() {
                        return StackSize.ZERO.getSize();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Context.ForMethodEntry." + this.name();
                    }
                }
            }
        }

        public static interface Unresolved
        extends Dispatcher {
            public boolean isBinary();

            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> var1, ClassReader var2);

            public Resolved.ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> var1, ClassReader var2, Resolved.ForMethodEnter var3);
        }
    }

    protected static interface StackMapFrameHandler {
        public void translateFrame(MethodVisitor var1, int var2, int var3, Object[] var4, int var5, Object[] var6);

        public void injectReturnFrame(MethodVisitor var1);

        public void injectExceptionFrame(MethodVisitor var1);

        public void injectCompletionFrame(MethodVisitor var1, boolean var2);

        public static class Default
        implements ForInstrumentedMethod {
            private static final Object[] EMPTY = new Object[0];
            private final TypeDescription instrumentedType;
            protected final MethodDescription instrumentedMethod;
            protected final TypeList requiredTypes;
            protected final TypeList yieldedTypes;
            private final boolean expandFrames;
            private int currentFrameDivergence;

            protected Default(TypeDescription instrumentedType, MethodDescription instrumentedMethod, TypeList requiredTypes, TypeList yieldedTypes, boolean expandFrames) {
                this.instrumentedType = instrumentedType;
                this.instrumentedMethod = instrumentedMethod;
                this.requiredTypes = requiredTypes;
                this.yieldedTypes = yieldedTypes;
                this.expandFrames = expandFrames;
            }

            protected static ForInstrumentedMethod of(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> requiredTypes, List<? extends TypeDescription> yieldedTypes, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                return (writerFlags & 2) != 0 || classFileVersion.isLessThan(ClassFileVersion.JAVA_V6) ? NoOp.INSTANCE : new Default(instrumentedType, instrumentedMethod, new TypeList.Explicit(requiredTypes), new TypeList.Explicit(yieldedTypes), (readerFlags & 8) != 0);
            }

            protected static Object toFrame(TypeDescription typeDescription) {
                if (typeDescription.represents(Boolean.TYPE) || typeDescription.represents(Byte.TYPE) || typeDescription.represents(Short.TYPE) || typeDescription.represents(Character.TYPE) || typeDescription.represents(Integer.TYPE)) {
                    return Opcodes.INTEGER;
                }
                if (typeDescription.represents(Long.TYPE)) {
                    return Opcodes.LONG;
                }
                if (typeDescription.represents(Float.TYPE)) {
                    return Opcodes.FLOAT;
                }
                if (typeDescription.represents(Double.TYPE)) {
                    return Opcodes.DOUBLE;
                }
                return typeDescription.getInternalName();
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, new TypeList.Empty(), this.requiredTypes, TranslationMode.ENTRY);
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, new TypeList.Explicit(CompoundList.of(this.requiredTypes, this.yieldedTypes)), new TypeList.Empty(), TranslationMode.EXIT);
            }

            @Override
            public int getReaderHint() {
                return this.expandFrames ? 8 : 0;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                this.translateFrame(methodVisitor, TranslationMode.COPY, this.instrumentedMethod, this.requiredTypes, type, localVariableLength, localVariable, stackSize, stack);
            }

            protected void translateFrame(MethodVisitor methodVisitor, TranslationMode translationMode, MethodDescription methodDescription, TypeList additionalTypes, int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                switch (frameType) {
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        this.currentFrameDivergence += localVariableLength;
                        break;
                    }
                    case 2: {
                        this.currentFrameDivergence -= localVariableLength;
                        break;
                    }
                    case -1: 
                    case 0: {
                        Object[] translated = new Object[localVariableLength - methodDescription.getParameters().size() - (methodDescription.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + additionalTypes.size()];
                        int index = translationMode.copy(this.instrumentedType, this.instrumentedMethod, methodDescription, localVariable, translated);
                        for (TypeDescription typeDescription : additionalTypes) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        System.arraycopy(localVariable, methodDescription.getParameters().size() + (methodDescription.isStatic() ? 0 : 1), translated, index, translated.length - index);
                        localVariableLength = translated.length;
                        localVariable = translated;
                        this.currentFrameDivergence = translated.length - index;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected frame frameType: " + frameType);
                    }
                }
                methodVisitor.visitFrame(frameType, localVariableLength, localVariable, stackSize, stack);
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
                if (!this.expandFrames && this.currentFrameDivergence == 0 && !this.instrumentedMethod.isConstructor()) {
                    if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                    } else {
                        methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Default.toFrame(this.instrumentedMethod.getReturnType().asErasure())});
                    }
                } else {
                    this.injectFullFrame(methodVisitor, this.requiredTypes, this.instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.instrumentedMethod.getReturnType().asErasure()));
                }
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
                if (!this.expandFrames && this.currentFrameDivergence == 0) {
                    methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                } else {
                    this.injectFullFrame(methodVisitor, this.requiredTypes, Collections.singletonList(TypeDescription.THROWABLE));
                }
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                if (!(this.expandFrames || this.currentFrameDivergence != 0 || !secondary && this.instrumentedMethod.isConstructor())) {
                    if (secondary) {
                        methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                    } else {
                        Object[] local = new Object[this.yieldedTypes.size()];
                        int index = 0;
                        for (TypeDescription typeDescription : this.yieldedTypes) {
                            local[index++] = Default.toFrame(typeDescription);
                        }
                        methodVisitor.visitFrame(1, local.length, local, 0, EMPTY);
                    }
                } else {
                    this.injectFullFrame(methodVisitor, CompoundList.of(this.requiredTypes, this.yieldedTypes), Collections.emptyList());
                }
            }

            protected void injectFullFrame(MethodVisitor methodVisitor, List<? extends TypeDescription> typesInArray, List<? extends TypeDescription> typesOnStack) {
                Object[] localVariable = new Object[this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + typesInArray.size()];
                int index = 0;
                if (!this.instrumentedMethod.isStatic()) {
                    localVariable[index++] = Default.toFrame(this.instrumentedType);
                }
                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                for (TypeDescription typeDescription : typesInArray) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                index = 0;
                Object[] stackType = new Object[typesOnStack.size()];
                for (TypeDescription typeDescription : typesOnStack) {
                    stackType[index++] = Default.toFrame(typeDescription);
                }
                methodVisitor.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, localVariable, stackType.length, stackType);
                this.currentFrameDivergence = 0;
            }

            public String toString() {
                return "Advice.StackMapFrameHandler.Default{instrumentedType=" + this.instrumentedType + ", instrumentedMethod=" + this.instrumentedMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", expandFrames=" + this.expandFrames + ", currentFrameDivergence=" + this.currentFrameDivergence + '}';
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final TypeList requiredTypes;
                private final TypeList yieldedTypes;
                protected final TranslationMode translationMode;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, TypeList requiredTypes, TypeList yieldedTypes, TranslationMode translationMode) {
                    this.adviceMethod = adviceMethod;
                    this.requiredTypes = requiredTypes;
                    this.yieldedTypes = yieldedTypes;
                    this.translationMode = translationMode;
                }

                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    Default.this.translateFrame(methodVisitor, this.translationMode, this.adviceMethod, this.requiredTypes, type, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        if (this.yieldedTypes.isEmpty() || this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                        } else {
                            methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Default.toFrame(this.adviceMethod.getReturnType().asErasure())});
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.requiredTypes, this.yieldedTypes.isEmpty() || this.adviceMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.adviceMethod.getReturnType().asErasure()));
                    }
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.requiredTypes, Collections.singletonList(TypeDescription.THROWABLE));
                    }
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0 && this.yieldedTypes.size() < 4) {
                        if (secondary || this.yieldedTypes.isEmpty()) {
                            methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                        } else {
                            Object[] local = new Object[this.yieldedTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.yieldedTypes) {
                                local[index++] = Default.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, local, 0, EMPTY);
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, CompoundList.of(this.requiredTypes, this.yieldedTypes), Collections.emptyList());
                    }
                }

                public String toString() {
                    return "Advice.StackMapFrameHandler.Default.ForAdvice{adviceMethod=" + this.adviceMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", translationMode=" + (Object)((Object)this.translationMode) + '}';
                }
            }

            protected static enum TranslationMode {
                COPY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int length = instrumentedMethod.getParameters().size() + (instrumentedMethod.isStatic() ? 0 : 1);
                        System.arraycopy(localVariable, 0, translated, 0, length);
                        return length;
                    }
                }
                ,
                ENTRY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS : Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }
                }
                ,
                EXIT{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }
                };


                protected abstract int copy(TypeDescription var1, MethodDescription var2, MethodDescription var3, Object[] var4, Object[] var5);

                public String toString() {
                    return "Advice.StackMapFrameHandler.Default.TranslationMode." + this.name();
                }
            }
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public int getReaderHint() {
                return 4;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
            }

            public String toString() {
                return "Advice.StackMapFrameHandler.NoOp." + this.name();
            }
        }

        public static interface ForAdvice
        extends StackMapFrameHandler {
        }

        public static interface ForInstrumentedMethod
        extends StackMapFrameHandler {
            public ForAdvice bindEntry(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1);

            public int getReaderHint();
        }
    }

    protected static interface MethodSizeHandler {
        public static final int UNDEFINED_SIZE = Short.MAX_VALUE;

        public void requireLocalVariableLength(int var1);

        public static class Default
        implements ForInstrumentedMethod {
            private final MethodDescription instrumentedMethod;
            private final TypeList requiredTypes;
            private final TypeList yieldedTypes;
            private int stackSize;
            private int localVariableLength;

            protected Default(MethodDescription instrumentedMethod, TypeList requiredTypes, TypeList yieldedTypes) {
                this.instrumentedMethod = instrumentedMethod;
                this.requiredTypes = requiredTypes;
                this.yieldedTypes = yieldedTypes;
            }

            protected static ForInstrumentedMethod of(MethodDescription instrumentedMethod, List<? extends TypeDescription> requiredTypes, List<? extends TypeDescription> yieldedTypes, int writerFlags) {
                return (writerFlags & 3) != 0 ? NoOp.INSTANCE : new Default(instrumentedMethod, new TypeList.Explicit(requiredTypes), new TypeList.Explicit(yieldedTypes));
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                return new ForAdvice(adviceMethod, new TypeList.Empty(), new TypeList.Explicit(this.requiredTypes));
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().maximum(skipThrowable ? StackSize.ZERO : StackSize.SINGLE).getSize());
                return new ForAdvice(adviceMethod, new TypeList.Explicit(CompoundList.of(this.requiredTypes, this.yieldedTypes)), new TypeList.Empty());
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Math.max(this.stackSize, stackSize);
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Math.max(this.localVariableLength, localVariableLength + this.requiredTypes.getStackSize() + this.yieldedTypes.getStackSize());
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
                this.localVariableLength = Math.max(this.localVariableLength, localVariableLength);
            }

            public String toString() {
                return "Advice.MethodSizeHandler.Default{instrumentedMethod=" + this.instrumentedMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", stackSize=" + this.stackSize + ", localVariableLength=" + this.localVariableLength + '}';
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice {
                private final MethodDescription.InDefinedShape adviceMethod;
                private final TypeList requiredTypes;
                private final TypeList yieldedTypes;
                private int padding;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, TypeList requiredTypes, TypeList yieldedTypes) {
                    this.adviceMethod = adviceMethod;
                    this.requiredTypes = requiredTypes;
                    this.yieldedTypes = yieldedTypes;
                    Default.this.stackSize = Math.max(Default.this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                }

                @Override
                public void requireLocalVariableLength(int localVariableLength) {
                    Default.this.requireLocalVariableLength(localVariableLength);
                }

                @Override
                public void requireStackSize(int stackSize) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize);
                }

                @Override
                public void recordMaxima(int stackSize, int localVariableLength) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize) + this.padding;
                    Default.this.localVariableLength = Math.max(Default.this.localVariableLength, localVariableLength - this.adviceMethod.getStackSize() + Default.this.instrumentedMethod.getStackSize() + this.requiredTypes.getStackSize() + this.yieldedTypes.getStackSize());
                }

                @Override
                public void recordPadding(int padding) {
                    this.padding = Math.max(this.padding, padding);
                }

                public String toString() {
                    return "Advice.MethodSizeHandler.Default.ForAdvice{adviceMethod=" + this.adviceMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", padding=" + this.padding + '}';
                }
            }
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                return this;
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Short.MAX_VALUE;
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Short.MAX_VALUE;
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
            }

            @Override
            public void requireStackSize(int stackSize) {
            }

            @Override
            public void recordMaxima(int stackSize, int localVariableLength) {
            }

            @Override
            public void recordPadding(int padding) {
            }

            public String toString() {
                return "Advice.MethodSizeHandler.NoOp." + this.name();
            }
        }

        public static interface ForAdvice
        extends MethodSizeHandler {
            public void requireStackSize(int var1);

            public void recordMaxima(int var1, int var2);

            public void recordPadding(int var1);
        }

        public static interface ForInstrumentedMethod
        extends MethodSizeHandler {
            public ForAdvice bindEntry(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1, boolean var2);

            public int compoundStackSize(int var1);

            public int compoundLocalVariableLength(int var1);
        }
    }
}

