/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.Nexus;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public enum NexusAccessor {
    INSTANCE;

    private final Dispatcher dispatcher;
    private final MethodDescription.InDefinedShape getSystemClassLoader;
    private final MethodDescription.InDefinedShape loadClass;
    private final MethodDescription.InDefinedShape valueOf;
    private final MethodDescription getDeclaredMethod;
    private final MethodDescription invokeMethod;

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Explicit delegation of the exception")
    private NexusAccessor() {
        Dispatcher dispatcher;
        try {
            TypeDescription.ForLoadedType nexusType = new TypeDescription.ForLoadedType(Nexus.class);
            dispatcher = new Dispatcher.Available(ClassInjector.UsingReflection.ofSystemClassLoader().inject(Collections.singletonMap(nexusType, ClassFileLocator.ForClassLoader.read(Nexus.class).resolve())).get(nexusType).getDeclaredMethod("register", String.class, ClassLoader.class, Integer.TYPE, Object.class));
        }
        catch (Exception exception) {
            try {
                dispatcher = new Dispatcher.Available(ClassLoader.getSystemClassLoader().loadClass(Nexus.class.getName()).getDeclaredMethod("register", String.class, ClassLoader.class, Integer.TYPE, Object.class));
            }
            catch (Exception ignored) {
                dispatcher = new Dispatcher.Unavailable(exception);
            }
        }
        this.dispatcher = dispatcher;
        this.getSystemClassLoader = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("getSystemClassLoader").and(ElementMatchers.takesArguments(0)))).getOnly();
        this.loadClass = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("loadClass").and(ElementMatchers.takesArguments(String.class)))).getOnly();
        this.getDeclaredMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredMethod").and(ElementMatchers.takesArguments(String.class, Class[].class)))).getOnly();
        this.invokeMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Method.class).getDeclaredMethods().filter(ElementMatchers.named("invoke").and(ElementMatchers.takesArguments(Object.class, Object[].class)))).getOnly();
        this.valueOf = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Integer.class).getDeclaredMethods().filter(ElementMatchers.named("valueOf").and(ElementMatchers.takesArguments(Integer.TYPE)))).getOnly();
    }

    public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
        if (loadedTypeInitializer.isAlive()) {
            this.dispatcher.register(name, classLoader, identification, loadedTypeInitializer);
        }
    }

    public String toString() {
        return "NexusAccessor." + this.name();
    }

    protected static interface Dispatcher {
        public void register(String var1, ClassLoader var2, int var3, LoadedTypeInitializer var4);

        public static class Unavailable
        implements Dispatcher {
            private final Exception exception;

            protected Unavailable(Exception exception) {
                this.exception = exception;
            }

            @Override
            public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                throw new IllegalStateException("Could not locate registration method", this.exception);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Unavailable)other).exception);
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public String toString() {
                return "NexusAccessor.Dispatcher.Unavailable{exception=" + this.exception + '}';
            }
        }

        public static class Available
        implements Dispatcher {
            private static final Object STATIC_METHOD = null;
            private final Method registration;

            protected Available(Method registration) {
                this.registration = registration;
            }

            @Override
            public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                try {
                    this.registration.invoke(STATIC_METHOD, name, classLoader, identification, loadedTypeInitializer);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot register type initializer for " + name, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot register type initializer for " + name, exception.getCause());
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.registration.equals(((Available)other).registration);
            }

            public int hashCode() {
                return this.registration.hashCode();
            }

            public String toString() {
                return "NexusAccessor.Dispatcher.Available{registration=" + this.registration + '}';
            }
        }
    }

    public static class InitializationAppender
    implements ByteCodeAppender {
        private final int identification;

        public InitializationAppender(int identification) {
            this.identification = identification;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(INSTANCE.getSystemClassLoader), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(INSTANCE.loadClass), new TextConstant("initialize"), ArrayFactory.forType(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class)).withValues(Arrays.asList(ClassConstant.of(TypeDescription.CLASS), ClassConstant.of(new TypeDescription.ForLoadedType(Integer.TYPE)))), MethodInvocation.invoke(INSTANCE.getDeclaredMethod), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(Arrays.asList(ClassConstant.of(instrumentedMethod.getDeclaringType().asErasure()), new StackManipulation.Compound(IntegerConstant.forValue(this.identification), MethodInvocation.invoke(INSTANCE.valueOf)))), MethodInvocation.invoke(INSTANCE.invokeMethod), Removal.SINGLE)).apply(methodVisitor, implementationContext, instrumentedMethod);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InitializationAppender that = (InitializationAppender)object;
            return this.identification == that.identification;
        }

        public int hashCode() {
            return this.identification;
        }

        public String toString() {
            return "NexusAccessor.InitializationAppender{identification=" + this.identification + '}';
        }
    }
}

