/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.utility.AccessAction;

public interface LoadedTypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Serialization is considered opt-in for a rare use case")
    public static class Compound
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LoadedTypeInitializer[] loadedTypeInitializer;

        public Compound(LoadedTypeInitializer ... loadedTypeInitializer) {
            this.loadedTypeInitializer = loadedTypeInitializer;
        }

        public Compound(List<? extends LoadedTypeInitializer> loadedTypeInitializers) {
            this.loadedTypeInitializer = loadedTypeInitializers.toArray(new LoadedTypeInitializer[loadedTypeInitializers.size()]);
        }

        @Override
        public void onLoad(Class<?> type) {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializer) {
                loadedTypeInitializer.onLoad(type);
            }
        }

        @Override
        public boolean isAlive() {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializer) {
                if (!loadedTypeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.loadedTypeInitializer, ((Compound)other).loadedTypeInitializer);
        }

        public int hashCode() {
            return Arrays.hashCode(this.loadedTypeInitializer);
        }

        public String toString() {
            return "LoadedTypeInitializer.Compound{loadedTypeInitializer=" + Arrays.toString(this.loadedTypeInitializer) + '}';
        }
    }

    public static class ForStaticField
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Object STATIC_FIELD = null;
        private final String fieldName;
        private final Object value;

        protected ForStaticField(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        public void onLoad(Class<?> type) {
            try {
                Field field = type.getDeclaredField(this.fieldName);
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                    AccessController.doPrivileged(AccessAction.of(field));
                }
                try {
                    field.set(STATIC_FIELD, this.value);
                }
                catch (IllegalArgumentException exception) {
                    throw new IllegalStateException("cannot assign runtime type " + this.value.getClass() + " (" + this.value.getClass().getClassLoader() + ")" + " to " + field.getType() + " (" + field.getType().getClassLoader() + ")", exception);
                }
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Cannot access " + this.fieldName + " from " + type, exception);
            }
            catch (NoSuchFieldException exception) {
                throw new IllegalStateException("There is no field " + this.fieldName + " defined on " + type, exception);
            }
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForStaticField that = (ForStaticField)other;
            return this.fieldName.equals(that.fieldName) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "LoadedTypeInitializer.ForStaticField{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }

    public static enum NoOp implements LoadedTypeInitializer
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }

        public String toString() {
            return "LoadedTypeInitializer.NoOp." + this.name();
        }
    }
}

