/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.FieldTransformer;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.attribute.FieldAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.LatentMatcher;

public interface FieldRegistry {
    public FieldRegistry prepend(LatentMatcher<? super FieldDescription> var1, FieldAttributeAppender.Factory var2, Object var3, FieldTransformer var4);

    public Compiled compile(TypeDescription var1);

    public static class Default
    implements FieldRegistry {
        private final List<Entry> entries;

        public Default() {
            this(Collections.emptyList());
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public FieldRegistry prepend(LatentMatcher<? super FieldDescription> matcher, FieldAttributeAppender.Factory fieldAttributeAppenderFactory, Object defaultValue, FieldTransformer fieldTransformer) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.entries.size() + 1);
            entries.add(new Entry(matcher, fieldAttributeAppenderFactory, defaultValue, fieldTransformer));
            entries.addAll(this.entries);
            return new Default(entries);
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled compile(TypeDescription instrumentedType) {
            ArrayList<Compiled.Entry> entries = new ArrayList<Compiled.Entry>(this.entries.size());
            HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender> fieldAttributeAppenders = new HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender>();
            for (Entry entry : this.entries) {
                FieldAttributeAppender fieldAttributeAppender = (FieldAttributeAppender)fieldAttributeAppenders.get(entry.getFieldAttributeAppenderFactory());
                if (fieldAttributeAppender == null) {
                    fieldAttributeAppender = entry.getFieldAttributeAppenderFactory().make(instrumentedType);
                    fieldAttributeAppenders.put(entry.getFieldAttributeAppenderFactory(), fieldAttributeAppender);
                }
                entries.add(new Compiled.Entry(entry.resolve(instrumentedType), fieldAttributeAppender, entry.getDefaultValue(), entry.getTransformer()));
            }
            return new Compiled(instrumentedType, entries);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "FieldRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Compiled
        implements net.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final List<Entry> entries;

            protected Compiled(TypeDescription instrumentedType, List<Entry> entries) {
                this.instrumentedType = instrumentedType;
                this.entries = entries;
            }

            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(fieldDescription)) continue;
                    return entry.bind(this.instrumentedType, fieldDescription);
                }
                return new TypeWriter.FieldPool.Record.ForImplicitField(fieldDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Compiled)other).entries) && this.instrumentedType.equals(((Compiled)other).instrumentedType);
            }

            public int hashCode() {
                return 31 * this.instrumentedType.hashCode() + this.entries.hashCode();
            }

            public String toString() {
                return "FieldRegistry.Default.Compiled{instrumentedType=" + this.instrumentedType + ", entries=" + this.entries + '}';
            }

            protected static class Entry
            implements ElementMatcher<FieldDescription> {
                private final ElementMatcher<? super FieldDescription> matcher;
                private final FieldAttributeAppender fieldAttributeAppender;
                private final Object defaultValue;
                private final FieldTransformer fieldTransformer;

                protected Entry(ElementMatcher<? super FieldDescription> matcher, FieldAttributeAppender fieldAttributeAppender, Object defaultValue, FieldTransformer fieldTransformer) {
                    this.matcher = matcher;
                    this.fieldAttributeAppender = fieldAttributeAppender;
                    this.defaultValue = defaultValue;
                    this.fieldTransformer = fieldTransformer;
                }

                protected TypeWriter.FieldPool.Record bind(TypeDescription instrumentedType, FieldDescription fieldDescription) {
                    return new TypeWriter.FieldPool.Record.ForExplicitField(this.fieldAttributeAppender, this.defaultValue, this.fieldTransformer.transform(instrumentedType, fieldDescription));
                }

                @Override
                public boolean matches(FieldDescription target) {
                    return this.matcher.matches(target);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.matcher.equals(entry.matcher) && this.fieldAttributeAppender.equals(entry.fieldAttributeAppender) && !(this.defaultValue == null ? entry.defaultValue != null : !this.defaultValue.equals(entry.defaultValue)) && this.fieldTransformer.equals(entry.fieldTransformer);
                }

                public int hashCode() {
                    int result = this.matcher.hashCode();
                    result = 31 * result + this.fieldAttributeAppender.hashCode();
                    result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                    result = 31 * result + this.fieldTransformer.hashCode();
                    return result;
                }

                public String toString() {
                    return "FieldRegistry.Default.Compiled.Entry{matcher=" + this.matcher + ", fieldAttributeAppender=" + this.fieldAttributeAppender + ", defaultValue=" + this.defaultValue + ", fieldTransformer=" + this.fieldTransformer + '}';
                }
            }
        }

        protected static class Entry
        implements LatentMatcher<FieldDescription> {
            private final LatentMatcher<? super FieldDescription> matcher;
            private final FieldAttributeAppender.Factory fieldAttributeAppenderFactory;
            private final Object defaultValue;
            private final FieldTransformer fieldTransformer;

            protected Entry(LatentMatcher<? super FieldDescription> matcher, FieldAttributeAppender.Factory fieldAttributeAppenderFactory, Object defaultValue, FieldTransformer fieldTransformer) {
                this.matcher = matcher;
                this.fieldAttributeAppenderFactory = fieldAttributeAppenderFactory;
                this.defaultValue = defaultValue;
                this.fieldTransformer = fieldTransformer;
            }

            protected FieldAttributeAppender.Factory getFieldAttributeAppenderFactory() {
                return this.fieldAttributeAppenderFactory;
            }

            protected Object getDefaultValue() {
                return this.defaultValue;
            }

            protected FieldTransformer getTransformer() {
                return this.fieldTransformer;
            }

            @Override
            public ElementMatcher<? super FieldDescription> resolve(TypeDescription instrumentedType) {
                return this.matcher.resolve(instrumentedType);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.fieldAttributeAppenderFactory.equals(entry.fieldAttributeAppenderFactory) && !(this.defaultValue == null ? entry.defaultValue != null : !this.defaultValue.equals(entry.defaultValue)) && this.fieldTransformer.equals(entry.fieldTransformer);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.fieldAttributeAppenderFactory.hashCode();
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + this.fieldTransformer.hashCode();
                return result;
            }

            public String toString() {
                return "FieldRegistry.Default.Entry{matcher=" + this.matcher + ", fieldAttributeAppenderFactory=" + this.fieldAttributeAppenderFactory + ", defaultValue=" + this.defaultValue + ", fieldTransformer=" + this.fieldTransformer + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.FieldPool {

        public static enum NoOp implements Compiled
        {
            INSTANCE;


            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                return new TypeWriter.FieldPool.Record.ForImplicitField(fieldDescription);
            }

            public String toString() {
                return "FieldRegistry.Compiled.NoOp." + this.name();
            }
        }
    }
}

