/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.maven.ClassLoaderResolver;
import net.bytebuddy.build.maven.Initialization;
import net.bytebuddy.build.maven.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.utility.CompoundList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuddyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.groupId}", required=true, readonly=true)
    public String groupId;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    public String artifactId;
    @Parameter(defaultValue="${project.version}", required=true, readonly=true)
    public String version;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    public String packaging;
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @Parameter
    public List<Transformation> transformations;
    @Parameter
    public Initialization initialization;
    @Parameter
    public String suffix;
    @Parameter(defaultValue="true", required=true)
    public boolean failOnLiveInitializer;
    @Parameter(defaultValue="false", required=true)
    public boolean skip;
    @Parameter(defaultValue="true", required=true)
    public boolean warnOnMissingOutputDirectory;
    @Parameter(defaultValue="true", required=true)
    public boolean warnOnEmptyTypeSet;
    @Parameter(defaultValue="true", required=true)
    public boolean failFast;
    @Parameter(defaultValue="false", required=true)
    public boolean extendedParsing;
    @Parameter(defaultValue="0", required=true)
    public int threads;
    @Component
    public RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    public RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", required=true, readonly=true)
    public List<RemoteRepository> remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not applying instrumentation as a result of plugin configuration.");
            return;
        }
        if (this.transformations == null || this.transformations.isEmpty()) {
            this.getLog().warn((CharSequence)"No transformations are specified. Skipping plugin application.");
            return;
        }
        try {
            this.apply(new File(this.getOutputDirectory()), this.getClassPathElements());
        }
        catch (IOException exception) {
            throw new MojoFailureException("Error during writing process", (Throwable)exception);
        }
    }

    protected abstract String getOutputDirectory();

    protected abstract List<String> getClassPathElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(File root, List<? extends String> classPath) throws MojoExecutionException, IOException {
        if (!root.exists()) {
            if (this.warnOnMissingOutputDirectory) {
                this.getLog().warn((CharSequence)("Skipping instrumentation due to missing directory: " + root));
            } else {
                this.getLog().info((CharSequence)("Skipping instrumentation due to missing directory: " + root));
            }
            return;
        }
        if (!root.isDirectory()) {
            throw new MojoExecutionException("Not a directory: " + root);
        }
        ClassLoaderResolver classLoaderResolver = new ClassLoaderResolver(this.getLog(), this.repositorySystem, this.repositorySystemSession, this.remoteRepositories);
        try {
            Plugin.Engine.Summary summary;
            ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>(this.transformations.size());
            for (Transformation transformation : this.transformations) {
                String plugin = transformation.getPlugin();
                try {
                    factories.add(new Plugin.Factory.UsingReflection(Class.forName(plugin, false, classLoaderResolver.resolve(transformation.asCoordinate(this.groupId, this.artifactId, this.version, this.packaging)))).with(transformation.makeArgumentResolvers()).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(File.class, (Object)root), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Log.class, (Object)this.getLog()), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)new MavenBuildLogger(this.getLog()))}));
                    this.getLog().info((CharSequence)("Resolved plugin: " + transformation.getRawPlugin()));
                }
                catch (Throwable throwable) {
                    throw new MojoExecutionException("Cannot resolve plugin: " + transformation.getRawPlugin(), throwable);
                }
            }
            EntryPoint entryPoint = (this.initialization == null ? Initialization.makeDefault() : this.initialization).getEntryPoint(classLoaderResolver, this.groupId, this.artifactId, this.version, this.packaging);
            this.getLog().info((CharSequence)("Resolved entry point: " + entryPoint));
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(classPath.size());
            for (String string : classPath) {
                File artifact = new File(string);
                classFileLocators.add((ClassFileLocator)(artifact.isFile() ? ClassFileLocator.ForJarFile.of((File)artifact) : new ClassFileLocator.ForFolder(artifact)));
            }
            ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);
            try {
                Plugin.Engine pluginEngine;
                this.getLog().info((CharSequence)("Processing class files located in in: " + root));
                try {
                    ClassFileVersion classFileVersion;
                    String javaVersionString = ByteBuddyMojo.findJavaVersionString(this.project);
                    if (javaVersionString == null) {
                        classFileVersion = ClassFileVersion.ofThisVm();
                        this.getLog().warn((CharSequence)("Could not locate Java target version, build is JDK dependant: " + classFileVersion.getMajorVersion()));
                    } else {
                        classFileVersion = ClassFileVersion.ofJavaVersionString((String)javaVersionString);
                        this.getLog().debug((CharSequence)("Java version detected: " + javaVersionString));
                    }
                    pluginEngine = Plugin.Engine.Default.of((EntryPoint)entryPoint, (ClassFileVersion)classFileVersion, (MethodNameTransformer)(this.suffix == null || this.suffix.length() == 0 ? MethodNameTransformer.Suffixing.withRandomSuffix() : new MethodNameTransformer.Suffixing(this.suffix)));
                }
                catch (Throwable throwable) {
                    throw new MojoExecutionException("Cannot create plugin engine", throwable);
                }
                try {
                    summary = pluginEngine.with((Plugin.Engine.PoolStrategy)(this.extendedParsing ? Plugin.Engine.PoolStrategy.Default.EXTENDED : Plugin.Engine.PoolStrategy.Default.FAST)).with((ClassFileLocator)classFileLocator).with((Plugin.Engine.Listener)new TransformationLogger(this.getLog())).withErrorHandlers(new Plugin.Engine.ErrorHandler[]{Plugin.Engine.ErrorHandler.Enforcing.ALL_TYPES_RESOLVED, (Plugin.Engine.ErrorHandler)(this.failOnLiveInitializer ? Plugin.Engine.ErrorHandler.Enforcing.NO_LIVE_INITIALIZERS : Plugin.Engine.Listener.NoOp.INSTANCE), (Plugin.Engine.ErrorHandler)(this.failFast ? Plugin.Engine.ErrorHandler.Failing.FAIL_FAST : Plugin.Engine.Listener.NoOp.INSTANCE)}).with((Plugin.Engine.Dispatcher.Factory)(this.threads == 0 ? Plugin.Engine.Dispatcher.ForSerialTransformation.Factory.INSTANCE : new Plugin.Engine.Dispatcher.ForParallelTransformation.WithThrowawayExecutorService.Factory(this.threads))).apply((Plugin.Engine.Source)new Plugin.Engine.Source.ForFolder(root), (Plugin.Engine.Target)new Plugin.Engine.Target.ForFolder(root), factories);
                }
                catch (Throwable throwable) {
                    throw new MojoExecutionException("Failed to transform class files in " + root, throwable);
                }
            }
            finally {
                classFileLocator.close();
            }
            if (!summary.getFailed().isEmpty()) {
                throw new MojoExecutionException(summary.getFailed() + " type transformations have failed");
            }
            if (this.warnOnEmptyTypeSet && summary.getTransformed().isEmpty()) {
                this.getLog().warn((CharSequence)"No types were transformed during plugin execution");
            } else {
                this.getLog().info((CharSequence)("Transformed " + summary.getTransformed().size() + " types"));
            }
        }
        finally {
            classLoaderResolver.close();
        }
    }

    private static String findJavaVersionString(MavenProject project) {
        while (project != null) {
            String target = project.getProperties().getProperty("maven.compiler.target");
            if (target != null) {
                return target;
            }
            for (org.apache.maven.model.Plugin plugin : CompoundList.of((List)project.getBuildPlugins(), (List)project.getPluginManagement().getPlugins())) {
                Xpp3Dom node;
                if (!"maven-compiler-plugin".equals(plugin.getArtifactId()) || !(plugin.getConfiguration() instanceof Xpp3Dom) || (node = ((Xpp3Dom)plugin.getConfiguration()).getChild("target")) == null) continue;
                return node.getValue();
            }
            project = project.getParent();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TransformationLogger
    extends Plugin.Engine.Listener.Adapter {
        private final Log log;

        protected TransformationLogger(Log log) {
            this.log = log;
        }

        public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
            this.log.debug((CharSequence)("Transformed " + typeDescription + " using " + plugins));
        }

        public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
            this.log.warn((CharSequence)("Failed to transform " + typeDescription + " using " + plugin), throwable);
        }

        public void onError(Map<TypeDescription, List<Throwable>> throwables) {
            this.log.warn((CharSequence)("Failed to transform " + throwables.size() + " types"));
        }

        public void onError(Plugin plugin, Throwable throwable) {
            this.log.error((CharSequence)("Failed to close " + plugin), throwable);
        }

        public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
            this.log.debug((CharSequence)("Discovered live initializer for " + definingType + " as a result of transforming " + typeDescription));
        }
    }

    protected static class MavenBuildLogger
    implements BuildLogger {
        private final Log log;

        protected MavenBuildLogger(Log log) {
            this.log = log;
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String message) {
            this.log.debug((CharSequence)message);
        }

        public void debug(String message, Throwable throwable) {
            this.log.debug((CharSequence)message, throwable);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String message) {
            this.log.info((CharSequence)message);
        }

        public void info(String message, Throwable throwable) {
            this.log.info((CharSequence)message, throwable);
        }

        public boolean isWarnEnabled() {
            return this.log.isWarnEnabled();
        }

        public void warn(String message) {
            this.log.warn((CharSequence)message);
        }

        public void warn(String message, Throwable throwable) {
            this.log.warn((CharSequence)message, throwable);
        }

        public boolean isErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        public void error(String message) {
            this.log.error((CharSequence)message);
        }

        public void error(String message, Throwable throwable) {
            this.log.error((CharSequence)message, throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Mojo(name="transform-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
    public static class ForTestTypes
    extends ByteBuddyMojo {
        @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
        public String testOutputDirectory;
        @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
        public List<String> testClasspathElements;

        @Override
        protected String getOutputDirectory() {
            return this.testOutputDirectory;
        }

        @Override
        protected List<String> getClassPathElements() {
            return this.testClasspathElements;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
    public static class ForProductionTypes
    extends ByteBuddyMojo {
        @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
        public String outputDirectory;
        @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
        public List<String> compileClasspathElements;

        @Override
        protected String getOutputDirectory() {
            return this.outputDirectory;
        }

        @Override
        protected List<String> getClassPathElements() {
            return this.compileClasspathElements;
        }
    }
}

