/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Queue;
import javax.inject.Inject;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.ByteBuddyJarsTaskExtension;
import net.bytebuddy.utility.QueueFactory;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuddyJarsTask
extends AbstractByteBuddyTask {
    private File source;
    private File target;
    private Iterable<File> classPath;
    @MaybeNull
    private Iterable<File> discoverySet;

    @Inject
    public ByteBuddyJarsTask() {
        new ByteBuddyJarsTaskExtension(null).configure(this);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    @OutputDirectory
    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    @InputFiles
    @CompileClasspath
    public Iterable<File> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(Iterable<File> classPath) {
        this.classPath = classPath;
    }

    @MaybeNull
    @InputFiles
    @Optional
    public Iterable<File> getDiscoverySet() {
        return this.discoverySet;
    }

    public void setDiscoverySet(@MaybeNull Iterable<File> discoverySet) {
        this.discoverySet = discoverySet;
    }

    @Override
    protected File source() {
        return this.getSource();
    }

    @Override
    protected File target() {
        return this.getTarget();
    }

    @Override
    protected Iterable<File> classPath() {
        return this.getClassPath();
    }

    @Override
    @MaybeNull
    protected Iterable<File> discoverySet() {
        return this.discoverySet;
    }

    @TaskAction
    public void apply() throws IOException {
        File source = this.getSource().getAbsoluteFile();
        File target = this.getTarget().getAbsoluteFile();
        if (!source.equals(this.getTarget()) && ByteBuddyJarsTask.deleteRecursively(this.getTarget())) {
            this.getLogger().debug("Deleted target directory {}", (Object)this.getTarget());
        }
        Queue queue = QueueFactory.make(Collections.singletonList(source));
        while (!queue.isEmpty()) {
            File candidate = (File)queue.remove();
            File[] file = candidate.listFiles();
            if (file != null) {
                queue.addAll(Arrays.asList(file));
                continue;
            }
            if (!candidate.getAbsoluteFile().toString().startsWith(source.toString())) {
                throw new IllegalStateException(candidate + " is not a subdirectory of " + source);
            }
            File resolved = new File(target, candidate.toString().substring(source.toString().length()));
            if (resolved.getParentFile().mkdirs()) {
                this.getLogger().debug("Created host directory for {}", (Object)resolved);
            }
            this.getLogger().debug("Transforming {} to {}", (Object)candidate, (Object)resolved);
            this.doApply((Plugin.Engine.Source)new Plugin.Engine.Source.ForJarFile(candidate), (Plugin.Engine.Target)new Plugin.Engine.Target.ForJarFile(resolved));
        }
    }
}

