/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import org.gradle.api.GradleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResolver
implements Closeable {
    private final Map<Set<? extends File>, ClassLoader> classLoaders = new HashMap<Set<? extends File>, ClassLoader>();

    public ClassLoader resolve(Iterable<? extends File> classPath) {
        LinkedHashSet<File> classPathList = new LinkedHashSet<File>();
        for (File file : classPath) {
            classPathList.add(file);
        }
        return this.resolve((Set<? extends File>)classPathList);
    }

    private ClassLoader resolve(Set<? extends File> classPath) {
        ClassLoader classLoader = this.classLoaders.get(classPath);
        if (classLoader == null) {
            classLoader = this.doResolve(classPath);
            this.classLoaders.put(classPath, classLoader);
        }
        return classLoader;
    }

    private ClassLoader doResolve(Set<? extends File> classPath) {
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (File file : classPath) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException exception) {
                throw new GradleException("Cannot resolve " + file + " as URL", (Throwable)exception);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), ByteBuddy.class.getClassLoader());
    }

    @Override
    public void close() throws IOException {
        for (ClassLoader classLoader : this.classLoaders.values()) {
            if (!(classLoader instanceof Closeable)) continue;
            ((Closeable)((Object)classLoader)).close();
        }
    }
}

