/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.DeclaredByType;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RecordComponentDescription
extends DeclaredByType,
NamedElement.WithDescriptor,
AnnotationSource,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public TypeDescription.Generic getType();

    public MethodDescription getAccessor();

    @Override
    public Token asToken(ElementMatcher<? super TypeDescription> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Token
    implements ByteCodeElement.Token<Token> {
        private final String name;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;

        public Token(String name, TypeDescription.Generic type) {
            this(name, type, Collections.emptyList());
        }

        public Token(String name, TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            this.name = name;
            this.type = type;
            this.annotations = annotations;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription.Generic getType() {
            return this.type;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            return new Token(this.name, this.type.accept(visitor), this.annotations);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.annotations.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Token token = (Token)other;
            return this.name.equals(token.name) && this.type.equals(token.type) && this.annotations.equals(token.annotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final TypeDescription.Generic declaringType;
        private final RecordComponentDescription recordComponentDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(TypeDescription.Generic declaringType, RecordComponentDescription recordComponentDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            this.declaringType = declaringType;
            this.recordComponentDescription = recordComponentDescription;
            this.visitor = visitor;
        }

        @Override
        public MethodDescription.InGenericShape getAccessor() {
            return (MethodDescription.InGenericShape)((MethodList)this.declaringType.getDeclaredMethods().filter(ElementMatchers.named(this.getActualName()))).getOnly();
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.recordComponentDescription.getType().accept(this.visitor);
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.recordComponentDescription.asDefined();
        }

        @Override
        public TypeDefinition getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public String getActualName() {
            return this.recordComponentDescription.getActualName();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.recordComponentDescription.getDeclaredAnnotations();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final TypeDescription declaringType;
        private final String name;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;

        public Latent(TypeDescription declaringType, Token token) {
            this(declaringType, token.getName(), token.getType(), token.getAnnotations());
        }

        public Latent(TypeDescription declaringType, String name, TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            this.declaringType = declaringType;
            this.name = name;
            this.type = type;
            this.annotations = annotations;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.type.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public String getActualName() {
            return this.name;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }
    }

    public static class ForLoadedRecordComponent
    extends InDefinedShape.AbstractBase {
        protected static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final AnnotatedElement recordComponent;

        protected ForLoadedRecordComponent(AnnotatedElement recordComponent) {
            this.recordComponent = recordComponent;
        }

        public static RecordComponentDescription of(Object recordComponent) {
            if (!DISPATCHER.isInstance(recordComponent)) {
                throw new IllegalArgumentException("Not a record component: " + recordComponent);
            }
            return new ForLoadedRecordComponent((AnnotatedElement)recordComponent);
        }

        public TypeDescription.Generic getType() {
            return new TypeDescription.Generic.LazyProjection.OfRecordComponent(this.recordComponent);
        }

        public MethodDescription.InDefinedShape getAccessor() {
            return new MethodDescription.ForLoadedMethod(DISPATCHER.getAccessor(this.recordComponent));
        }

        public TypeDescription getDeclaringType() {
            return TypeDescription.ForLoadedType.of(DISPATCHER.getDeclaringType(this.recordComponent));
        }

        public String getActualName() {
            return DISPATCHER.getName(this.recordComponent);
        }

        public String getGenericSignature() {
            return DISPATCHER.getGenericSignature(this.recordComponent);
        }

        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.recordComponent.getDeclaredAnnotations());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public boolean isInstance(Object var1);

            public Object[] getRecordComponents(Class<?> var1);

            public boolean isRecord(Class<?> var1);

            public String getName(Object var1);

            public Class<?> getDeclaringType(Object var1);

            public Method getAccessor(Object var1);

            public Class<?> getType(Object var1);

            public Type getGenericType(Object var1);

            public String getGenericSignature(Object var1);

            public AnnotatedElement getAnnotatedType(Object var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava14CapableVm
            implements Dispatcher {
                private final Class<?> recordComponent;
                private final Method getRecordComponents;
                private final Method isRecord;
                private final Method getName;
                private final Method getDeclaringType;
                private final Method getAccessor;
                private final Method getType;
                private final Method getGenericType;
                private final Method getGenericSignature;
                private final Method getAnnotatedType;

                protected ForJava14CapableVm(Class<?> recordComponent, Method getRecordComponents, Method isRecord, Method getName, Method getDeclaringType, Method getAccessor, Method getType, Method getGenericType, Method getGenericSignature, Method getAnnotatedType) {
                    this.recordComponent = recordComponent;
                    this.getRecordComponents = getRecordComponents;
                    this.isRecord = isRecord;
                    this.getName = getName;
                    this.getDeclaringType = getDeclaringType;
                    this.getAccessor = getAccessor;
                    this.getType = getType;
                    this.getGenericType = getGenericType;
                    this.getGenericSignature = getGenericSignature;
                    this.getAnnotatedType = getAnnotatedType;
                }

                @Override
                public boolean isInstance(Object instance) {
                    return this.recordComponent.isInstance(instance);
                }

                @Override
                public Object[] getRecordComponents(Class<?> type) {
                    try {
                        return (Object[])this.getRecordComponents.invoke(type, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.Class#getRecordComponents", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.Class#getRecordComponents", exception.getCause());
                    }
                }

                @Override
                public boolean isRecord(Class<?> type) {
                    try {
                        return (Boolean)this.isRecord.invoke(type, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.Class#isRecord", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.Class#isRecord", exception.getCause());
                    }
                }

                @Override
                public String getName(Object recordComponent) {
                    try {
                        return (String)this.getName.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getName", exception.getCause());
                    }
                }

                @Override
                public Class<?> getDeclaringType(Object recordComponent) {
                    try {
                        return (Class)this.getDeclaringType.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getDeclaringType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getDeclaringType", exception.getCause());
                    }
                }

                @Override
                public Method getAccessor(Object recordComponent) {
                    try {
                        return (Method)this.getAccessor.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getAccessor", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getAccessor", exception.getCause());
                    }
                }

                @Override
                public Class<?> getType(Object recordComponent) {
                    try {
                        return (Class)this.getType.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getType", exception.getCause());
                    }
                }

                @Override
                public Type getGenericType(Object recordComponent) {
                    try {
                        return (Type)this.getGenericType.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getGenericType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getGenericType", exception.getCause());
                    }
                }

                @Override
                public String getGenericSignature(Object recordComponent) {
                    try {
                        return (String)this.getGenericSignature.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getGenericSignature", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getGenericSignature", exception.getCause());
                    }
                }

                @Override
                public AnnotatedElement getAnnotatedType(Object recordComponent) {
                    try {
                        return (AnnotatedElement)this.getAnnotatedType.invoke(recordComponent, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflection.RecordComponent#getAnnotatedType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflection.RecordComponent#getAnnotatedType", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.recordComponent.equals(((ForJava14CapableVm)object).recordComponent)) {
                        return false;
                    }
                    if (!this.getRecordComponents.equals(((ForJava14CapableVm)object).getRecordComponents)) {
                        return false;
                    }
                    if (!this.isRecord.equals(((ForJava14CapableVm)object).isRecord)) {
                        return false;
                    }
                    if (!this.getName.equals(((ForJava14CapableVm)object).getName)) {
                        return false;
                    }
                    if (!this.getDeclaringType.equals(((ForJava14CapableVm)object).getDeclaringType)) {
                        return false;
                    }
                    if (!this.getAccessor.equals(((ForJava14CapableVm)object).getAccessor)) {
                        return false;
                    }
                    if (!this.getType.equals(((ForJava14CapableVm)object).getType)) {
                        return false;
                    }
                    if (!this.getGenericType.equals(((ForJava14CapableVm)object).getGenericType)) {
                        return false;
                    }
                    if (!this.getGenericSignature.equals(((ForJava14CapableVm)object).getGenericSignature)) {
                        return false;
                    }
                    return this.getAnnotatedType.equals(((ForJava14CapableVm)object).getAnnotatedType);
                }

                public int hashCode() {
                    return (((((((((17 * 31 + this.recordComponent.hashCode()) * 31 + this.getRecordComponents.hashCode()) * 31 + this.isRecord.hashCode()) * 31 + this.getName.hashCode()) * 31 + this.getDeclaringType.hashCode()) * 31 + this.getAccessor.hashCode()) * 31 + this.getType.hashCode()) * 31 + this.getGenericType.hashCode()) * 31 + this.getGenericSignature.hashCode()) * 31 + this.getAnnotatedType.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public boolean isInstance(Object instance) {
                    return false;
                }

                @Override
                @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null value return is aligned with OpenJDK return value.")
                public Object[] getRecordComponents(Class<?> type) {
                    return null;
                }

                @Override
                public boolean isRecord(Class<?> type) {
                    return false;
                }

                @Override
                public String getName(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }

                @Override
                public Class<?> getDeclaringType(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }

                @Override
                public Method getAccessor(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }

                @Override
                public Class<?> getType(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }

                @Override
                public Type getGenericType(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }

                @Override
                public String getGenericSignature(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }

                @Override
                public AnnotatedElement getAnnotatedType(Object recordComponent) {
                    throw new IllegalStateException("The current VM does not support record components");
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                public Dispatcher run() {
                    try {
                        Class<?> recordComponent = Class.forName("java.lang.reflect.RecordComponent");
                        return new ForJava14CapableVm(recordComponent, Class.class.getMethod("getRecordComponents", new Class[0]), Class.class.getMethod("isRecord", new Class[0]), recordComponent.getMethod("getName", new Class[0]), recordComponent.getMethod("getDeclaringRecord", new Class[0]), recordComponent.getMethod("getAccessor", new Class[0]), recordComponent.getMethod("getType", new Class[0]), recordComponent.getMethod("getGenericType", new Class[0]), recordComponent.getMethod("getGenericSignature", new Class[0]), recordComponent.getMethod("getAnnotatedType", new Class[0]));
                    }
                    catch (ClassNotFoundException ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                    catch (NoSuchMethodException ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase
    implements RecordComponentDescription {
        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            return new Token(this.getActualName(), this.getType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), this.getDeclaredAnnotations());
        }

        @Override
        public String getDescriptor() {
            return this.getType().asErasure().getDescriptor();
        }

        @Override
        public String getGenericSignature() {
            TypeDescription.Generic recordComponentType = this.getType();
            try {
                return recordComponentType.getSort().isNonGeneric() ? NON_GENERIC_SIGNATURE : recordComponentType.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor((SignatureVisitor)new SignatureWriter())).toString();
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        public int hashCode() {
            return this.getActualName().hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecordComponentDescription)) {
                return false;
            }
            RecordComponentDescription recordComponentDescription = (RecordComponentDescription)other;
            return this.getActualName().equals(recordComponentDescription.getActualName());
        }

        public String toString() {
            return this.getType().getTypeName() + " " + this.getActualName();
        }
    }

    public static interface InDefinedShape
    extends RecordComponentDescription {
        public MethodDescription.InDefinedShape getAccessor();

        public TypeDescription getDeclaringType();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.type.RecordComponentDescription$AbstractBase
        implements InDefinedShape {
            public MethodDescription.InDefinedShape getAccessor() {
                return (MethodDescription.InDefinedShape)((MethodList)this.getDeclaringType().getDeclaredMethods().filter(ElementMatchers.named(this.getActualName()))).getOnly();
            }

            public InDefinedShape asDefined() {
                return this;
            }
        }
    }

    public static interface InGenericShape
    extends RecordComponentDescription {
        public MethodDescription.InGenericShape getAccessor();
    }
}

