/*
 * Decompiled with CFR 0.152.
 */
package net.butterflytv.rtmp_client;

import java.io.IOException;

public class RtmpClient {
    public static final int OPEN_SUCCESS = 1;
    private long rtmpPointer = 0L;

    public void open(String url, boolean isPublishMode) throws RtmpIOException {
        this.rtmpPointer = this.nativeAlloc();
        int result = this.nativeOpen(url, isPublishMode, this.rtmpPointer);
        if (result != 1) {
            throw new RtmpIOException(result);
        }
    }

    private native long nativeAlloc();

    private native int nativeOpen(String var1, boolean var2, long var3);

    public int read(byte[] data, int offset, int size) throws IOException {
        return this.nativeRead(data, offset, size, this.rtmpPointer);
    }

    private native int nativeRead(byte[] var1, int var2, int var3, long var4) throws IOException;

    public int write(byte[] data) throws IOException {
        return this.nativeWrite(data, this.rtmpPointer);
    }

    private native int nativeWrite(byte[] var1, long var2) throws IOException;

    public boolean pause(boolean pause) {
        return this.nativePause(pause, this.rtmpPointer);
    }

    private native boolean nativePause(boolean var1, long var2);

    public boolean isConnected() {
        return this.nativeIsConnected(this.rtmpPointer);
    }

    private native boolean nativeIsConnected(long var1);

    public void close() {
        this.nativeClose(this.rtmpPointer);
    }

    private native void nativeClose(long var1);

    static {
        System.loadLibrary("rtmp-jni");
    }

    public static class RtmpIOException
    extends IOException {
        public static final int OPEN_ALLOC = -1;
        public static final int OPEN_SETUP_URL = -2;
        public static final int OPEN_CONNECT = -3;
        public static final int OPEN_CONNECT_STREAM = -4;
        public final int errorCode;

        public RtmpIOException(int errorCode) {
            this.errorCode = errorCode;
        }
    }
}

