/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema;

import java.util.HashMap;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.WSDLParser;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SimpleType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WSDLParserTest {
    private final String behemothNs = "http://behemoth.service.suppliersguild.org";
    private final String commonNs = "http://common.types.suppliersguild.org/xsd";
    private final String uebung9Ns = "http://soa08.se.uni-hannover.de/uebung09";
    private WSDLParser parser;
    private HashMap<QName, ComplexType> complexTypes;
    private HashMap<QName, SimpleType> simpleTypes;
    private HashMap<QName, Element> elements;

    @Before
    public void setUp() throws Exception {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        Definition definition = reader.readWSDL(null, "testSchemata/OrderProcess.wsdl");
        this.parser = new WSDLParser(definition);
        this.complexTypes = this.parser.getComplexTypes();
        this.simpleTypes = this.parser.getSimpleTypes();
        this.elements = this.parser.getElements();
    }

    @Test
    public void testParseDefinition() throws Exception {
        Assert.assertEquals((long)5L, (long)this.elements.size());
        Assert.assertEquals((long)5L, (long)this.complexTypes.size());
        Assert.assertEquals((long)4L, (long)this.simpleTypes.size());
        ComplexType product = this.complexTypes.get(new QName("http://common.types.suppliersguild.org/xsd", "Product"));
        Assert.assertNotNull((Object)product);
        ComplexType amount = this.complexTypes.get(new QName("http://common.types.suppliersguild.org/xsd", "Amount"));
        Assert.assertNotNull((Object)amount);
        ComplexType unit = this.complexTypes.get(new QName("http://common.types.suppliersguild.org/xsd", "Unit"));
        Assert.assertNotNull((Object)unit);
        ComplexType money = this.complexTypes.get(new QName("http://common.types.suppliersguild.org/xsd", "Money"));
        Assert.assertNotNull((Object)money);
        ComplexType currency = this.complexTypes.get(new QName("http://common.types.suppliersguild.org/xsd", "Currency"));
        Assert.assertNotNull((Object)currency);
        Element orderProductRes = this.elements.get(new QName("http://behemoth.service.suppliersguild.org", "orderProductResponse"));
        Assert.assertNotNull((Object)orderProductRes);
        orderProductRes = this.elements.get(new QName("http://soa08.se.uni-hannover.de/uebung09", "orderProductResponse"));
        Assert.assertNotNull((Object)orderProductRes);
        Element orderProduct = this.elements.get(new QName("http://behemoth.service.suppliersguild.org", "orderProduct"));
        Assert.assertNotNull((Object)orderProduct);
        List<Element> nested = ((ComplexType)orderProduct.getType()).getElements();
        Assert.assertSame((Object)product, (Object)nested.get(0).getType());
        Assert.assertSame((Object)amount, (Object)nested.get(1).getType());
        Element getPriceForProduct = this.elements.get(new QName("http://behemoth.service.suppliersguild.org", "getPriceForProduct"));
        Assert.assertNotNull((Object)getPriceForProduct);
        nested = ((ComplexType)getPriceForProduct.getType()).getElements();
        Assert.assertSame((Object)product, (Object)nested.get(0).getType());
        Element getPriceForProductRes = this.elements.get(new QName("http://behemoth.service.suppliersguild.org", "getPriceForProductResponse"));
        Assert.assertNotNull((Object)getPriceForProductRes);
        nested = ((ComplexType)getPriceForProductRes.getType()).getElements();
        Assert.assertSame((Object)money, (Object)nested.get(0).getType());
        Element input = this.parser.getInputElementForOperation(new QName("http://soa08.se.uni-hannover.de/uebung09", "OrderProcess"), "OrderProcessSOAP11port_http", "orderProduct");
        Assert.assertSame((Object)orderProduct, (Object)input);
        input = this.parser.getInputElementForOperation(new QName("http://soa08.se.uni-hannover.de/uebung09", "OrderProcess"), "OrderProcessSOAP11port_http", "getPriceForProduct");
        Assert.assertSame((Object)getPriceForProduct, (Object)input);
        Element output = this.parser.getOutputElementForOperation(new QName("http://soa08.se.uni-hannover.de/uebung09", "OrderProcess"), "OrderProcessSOAP11port_http", "orderProduct");
        Assert.assertSame((Object)orderProductRes, (Object)output);
        output = this.parser.getOutputElementForOperation(new QName("http://soa08.se.uni-hannover.de/uebung09", "OrderProcess"), "OrderProcessSOAP11port_http", "getPriceForProduct");
        Assert.assertSame((Object)getPriceForProductRes, (Object)output);
    }
}

