/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema;

import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.InvalidInputException;
import net.bpelunit.toolsupport.util.schema.WSDLParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RPCEncodedTest {
    private static final String WSDL_NAMESPACE = "http://www.example.org/rpcEncodedTest/";
    private static final String WSDL_OPERATION = "go";
    private static final String WSDL_PATH = "testSchemata/rpcEncodedTest.wsdl";
    private static final String WSDL_PORT = "doSomethingPort";
    private static final String WSDL_SERVICE = "doSomethingService";
    private WSDLParser fParser;

    @Before
    public void setUp() throws Exception {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        Definition definition = reader.readWSDL(null, WSDL_PATH);
        this.fParser = new WSDLParser(definition);
    }

    @Test
    public void generateElementForRPCEncodedIsUnsupported() throws Exception {
        try {
            this.fParser.getOutputElementForOperation(new QName(WSDL_NAMESPACE, WSDL_SERVICE), WSDL_PORT, WSDL_OPERATION);
            Assert.fail((String)"rpc/encoded combination should be rejected");
        }
        catch (InvalidInputException ex) {
            Assert.assertTrue((String)"rpc/encoded combination should be rejected", (boolean)ex.getMessage().startsWith("Unknown combination"));
            Assert.assertTrue((String)"rpc/encoded should be mentioned in the error", (boolean)ex.getMessage().contains("rpc/encoded"));
        }
    }
}

