/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema;

import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import net.bpelunit.toolsupport.util.schema.ErrorAdapter;
import net.bpelunit.toolsupport.util.schema.InvalidInputException;
import net.bpelunit.toolsupport.util.schema.NoElementDefinitionExistsException;
import net.bpelunit.toolsupport.util.schema.NoSuchOperationException;
import net.bpelunit.toolsupport.util.schema.SchemaElementManager;
import net.bpelunit.toolsupport.util.schema.SchemaParser;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SimpleType;
import net.bpelunit.toolsupport.util.schema.nodes.Type;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLParser {
    private Definition definition;
    private SchemaElementManager schemaManager;

    public WSDLParser(Definition definition) throws SAXException, TransformerException, WSDLReadingException {
        this.definition = definition;
        this.readSchemata();
    }

    HashMap<QName, ComplexType> getComplexTypes() {
        return this.schemaManager.getComplexTypes();
    }

    HashMap<QName, SimpleType> getSimpleTypes() {
        return this.schemaManager.getSimpleTypes();
    }

    HashMap<QName, Element> getElements() {
        return this.schemaManager.getElements();
    }

    private void readSchemata() throws SAXException, TransformerException, WSDLReadingException {
        SchemaParser parser = new SchemaParser();
        this.schemaManager = parser.getSchemaElementManager();
        XSOMParser reader = new XSOMParser();
        reader.setErrorHandler((ErrorHandler)new ErrorAdapter());
        reader.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        WSDLParser.collectSchemata(schemata, this.definition);
        for (List importsByNamespace : this.definition.getImports().values()) {
            for (Import importDef : importsByNamespace) {
                WSDLParser.collectSchemata(schemata, importDef.getDefinition());
            }
        }
        for (Schema schema : schemata) {
            org.w3c.dom.Element schemaElement = schema.getElement();
            StringReader sReader = this.getStringReaderFromElement(schemaElement);
            InputSource source = new InputSource(sReader);
            source.setSystemId(this.definition.getDocumentBaseURI());
            reader.parse(source);
            try {
                parser.readSchemata(reader.getResult());
            }
            catch (NullPointerException e) {
                throw new WSDLReadingException("Corrupt Schema in WSDL", e);
            }
            catch (Throwable throwable) {}
        }
    }

    private static void collectSchemata(List<Schema> schemata, Definition def) {
        Types typesSection = def.getTypes();
        if (typesSection == null) {
            return;
        }
        for (Object o : typesSection.getExtensibilityElements()) {
            if (!(o instanceof Schema)) continue;
            Schema schema = (Schema)o;
            org.w3c.dom.Element element = schema.getElement();
            WSDLParser.addNamespaces(def.getNamespaces(), element);
            schemata.add(schema);
        }
    }

    private StringReader getStringReaderFromElement(org.w3c.dom.Element element) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(element);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
        return stringReader;
    }

    private static void addNamespaces(Map<String, String> namespaces, org.w3c.dom.Element schemaElement) {
        for (Map.Entry<String, String> o : namespaces.entrySet()) {
            Map.Entry<String, String> entry;
            String attribute;
            if (!(o instanceof Map.Entry) || schemaElement.getAttributeNode(attribute = "xmlns:" + (entry = o).getKey()) != null) continue;
            schemaElement.setAttribute(attribute, entry.getValue());
        }
    }

    public Element getInputElementForOperation(QName service, String port, String operationName) throws InvalidInputException, NoSuchOperationException, NoElementDefinitionExistsException {
        return this.getElementForOperation(service, port, operationName, null, SOAPOperationDirectionIdentifier.INPUT);
    }

    public Element getOutputElementForOperation(QName service, String port, String operationName) throws InvalidInputException, NoSuchOperationException, NoElementDefinitionExistsException {
        return this.getElementForOperation(service, port, operationName, null, SOAPOperationDirectionIdentifier.OUTPUT);
    }

    public Element getFaultElementForOperation(QName service, String port, String operationName, String faultName) throws InvalidInputException, NoSuchOperationException, NoElementDefinitionExistsException {
        return this.getElementForOperation(service, port, operationName, faultName, SOAPOperationDirectionIdentifier.FAULT);
    }

    private Element getElementForOperation(QName service, String port, String operationName, String faultName, SOAPOperationDirectionIdentifier direction) throws InvalidInputException, NoSuchOperationException, NoElementDefinitionExistsException {
        String opStyle;
        Operation operation;
        SOAPOperationCallIdentifier opIdentifier;
        try {
            opIdentifier = new SOAPOperationCallIdentifier(this.definition, service, port, operationName, direction);
            operation = opIdentifier.getBindingOperation().getOperation();
        }
        catch (SpecificationException e) {
            throw new NoSuchOperationException(e);
        }
        try {
            opStyle = opIdentifier.getEncodingStyle();
        }
        catch (SpecificationException e) {
            throw new InvalidInputException(e);
        }
        Message msg = this.getMessageFromOperation(faultName, direction, operation);
        if ("document/literal".equals(opStyle)) {
            return this.getElementForDocLitMessage(msg);
        }
        if ("rpc/literal".equals(opStyle)) {
            String bodyNamespace = opIdentifier.getBodyNamespace();
            return this.getElementForRpcLitMessage(bodyNamespace, operation.getName(), msg);
        }
        throw new InvalidInputException("Unknown combination of operation style and soap:body use: " + opStyle);
    }

    private Message getMessageFromOperation(String faultName, SOAPOperationDirectionIdentifier direction, Operation operation) throws InvalidInputException, NoElementDefinitionExistsException {
        switch (direction) {
            case OUTPUT: {
                Output output = operation.getOutput();
                if (output == null) {
                    throw new InvalidInputException("Selected operation has no output");
                }
                return output.getMessage();
            }
            case INPUT: {
                Input input = operation.getInput();
                if (input == null) {
                    throw new InvalidInputException("Selected operation has no input");
                }
                return input.getMessage();
            }
            case FAULT: {
                if (faultName == null) {
                    throw new NoElementDefinitionExistsException("Custom fault has no schema attached to it");
                }
                Fault fault = operation.getFault(faultName);
                if (fault == null) {
                    throw new InvalidInputException("Selected operation has no fault called " + faultName);
                }
                return fault.getMessage();
            }
        }
        throw new InvalidInputException("Unknown direction type");
    }

    private Element getElementForRpcLitMessage(String bodyNamespace, String operationName, Message msg) throws InvalidInputException {
        QName wrapperName = new QName(bodyNamespace, operationName);
        HashMap<QName, Element> elements = this.schemaManager.getElements();
        if (elements.containsKey(wrapperName)) {
            return (Element)elements.get(wrapperName);
        }
        ComplexType wrapperType = this.schemaManager.getComplexType(bodyNamespace, String.valueOf(operationName) + "WrapperElementType");
        this.addRPCPartElements(bodyNamespace, msg, wrapperType);
        Element wrapperElement = this.schemaManager.getElement(wrapperName);
        wrapperElement.setType(wrapperType);
        return wrapperElement;
    }

    private void addRPCPartElements(String bodyNamespace, Message msg, ComplexType wrapperType) throws InvalidInputException {
        HashMap<QName, ComplexType> complexTypes = this.schemaManager.getComplexTypes();
        HashMap<QName, SimpleType> simpleTypes = this.schemaManager.getSimpleTypes();
        List parts = msg.getOrderedParts(null);
        for (Part part : parts) {
            Type type;
            QName typeName = part.getTypeName();
            if (typeName == null) {
                throw new InvalidInputException("Style is rpc/lit, but the part " + part.getName() + " uses the element attribute");
            }
            if (complexTypes.containsKey(typeName)) {
                type = (Type)complexTypes.get(typeName);
            } else if (simpleTypes.containsKey(typeName)) {
                type = (Type)simpleTypes.get(typeName);
            } else if ("http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI())) {
                type = this.schemaManager.getSimpleType(typeName.getLocalPart());
            } else {
                throw new InvalidInputException("Could not find the type " + typeName);
            }
            Element partElement = this.schemaManager.getElement(bodyNamespace, part.getName());
            partElement.setType(type);
            wrapperType.addElement(partElement);
        }
    }

    private Element getElementForDocLitMessage(Message msg) throws InvalidInputException, NoElementDefinitionExistsException {
        Collection parts = msg.getParts().values();
        if (parts.isEmpty()) {
            throw new NoElementDefinitionExistsException("Message has no parts");
        }
        Part part = (Part)parts.iterator().next();
        QName elementName = part.getElementName();
        if (elementName == null) {
            throw new InvalidInputException("Style is doc/lit, but the part " + part.getName() + " uses the element attribute");
        }
        return this.schemaManager.getElement(elementName);
    }
}

