/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util;

import java.util.HashSet;
import java.util.Set;
import net.bpelunit.toolsupport.ToolSupportActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class WSDLFileFilter
extends ViewerFilter {
    private Set fArchives;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.fArchives.contains(element);
    }

    public WSDLFileFilter() {
        this.init();
    }

    private void init() {
        BusyIndicator.showWhile((Display)ToolSupportActivator.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                WSDLFileFilter.this.fArchives = new HashSet();
                WSDLFileFilter.this.traverse((IContainer)ResourcesPlugin.getWorkspace().getRoot(), WSDLFileFilter.this.fArchives);
            }
        });
    }

    private boolean traverse(IContainer container, Set set) {
        boolean added = false;
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    String ext = file.getFileExtension();
                    if (ext != null && ext.equalsIgnoreCase("wsdl")) {
                        set.add(file);
                        added = true;
                    }
                } else if (resource instanceof IContainer && this.traverse((IContainer)resource, set)) {
                    set.add(resource);
                    added = true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return added;
    }
}

