/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util;

import java.util.HashMap;
import java.util.Map;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.util.NamespaceDeclaration;
import org.apache.xmlbeans.XmlCursor;

public class NamespaceEditor {
    private XMLTestSuite baseSuite;

    public NamespaceEditor(XMLTestSuite suite) {
        this.baseSuite = suite;
    }

    public String getPrefix(String url) {
        for (Map.Entry<String, String> entry : this.getNamespacesFromSuite().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(url)) continue;
            return entry.getKey();
        }
        return this.addNamespaceToSuite(url);
    }

    public void getNamespacesFromSuite(Map<String, String> namespaces) {
        this.baseSuite.newCursor().getAllNamespaces(namespaces);
    }

    public Map<String, String> getNamespacesFromSuite() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        this.baseSuite.newCursor().getAllNamespaces(namespaces);
        return namespaces;
    }

    public boolean addNamespaceToSuite(String prefix, String url) {
        if (!"".equals(prefix) && !"".equals(url)) {
            XmlCursor cursor = this.baseSuite.newCursor();
            cursor.toNextToken();
            cursor.insertNamespace(prefix, url);
            return true;
        }
        return false;
    }

    public String addNamespaceToSuite(String url) {
        if (url != null) {
            String prefix = this.generatePrefix(url);
            this.addNamespaceToSuite(prefix, url);
            return prefix;
        }
        return null;
    }

    public boolean editNamespaceInSuite(NamespaceDeclaration current, String prefix, String url) {
        XmlCursor cursor = this.getPlacedCursor(current);
        if (cursor != null) {
            cursor.removeXml();
            this.addNamespaceToSuite(prefix, url);
            return true;
        }
        return false;
    }

    public boolean removeNamespaceFromSuite(NamespaceDeclaration prop) {
        XmlCursor cursor = this.getPlacedCursor(prop);
        if (cursor != null) {
            cursor.removeXml();
            return true;
        }
        return false;
    }

    private String generatePrefix(String url) {
        int protocolPosition = url.indexOf("://www.");
        protocolPosition = protocolPosition == -1 ? ((protocolPosition = url.indexOf("://")) == -1 ? 0 : (protocolPosition += 3)) : (protocolPosition += 7);
        int endPosition = Math.min(protocolPosition + 3, url.length());
        String prefix = url.substring(protocolPosition, endPosition);
        Map<String, String> namespaces = this.getNamespacesFromSuite();
        if (namespaces.containsKey(prefix)) {
            int suffix = 0;
            while (namespaces.containsKey(String.valueOf(prefix) + suffix)) {
                ++suffix;
            }
            prefix = String.valueOf(prefix) + suffix;
        }
        return prefix;
    }

    private XmlCursor getPlacedCursor(NamespaceDeclaration current) {
        block2: {
            String declarationPrefix;
            XmlCursor cursor = this.baseSuite.newCursor();
            do {
                XmlCursor.TokenType type = cursor.toNextToken();
                while (type.equals(XmlCursor.TokenType.ATTR)) {
                    type = cursor.toNextToken();
                }
                if (!type.equals(XmlCursor.TokenType.NAMESPACE)) break block2;
                declarationPrefix = cursor.getName().getLocalPart();
            } while (!current.getPrefix().equals(declarationPrefix));
            return cursor;
        }
        return null;
    }
}

