/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import java.util.ArrayList;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.IDialogFieldListener;
import net.bpelunit.toolsupport.editors.wizards.fields.IListAdapter;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.ActivityWizardPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ActivitySelectionWizardPage
extends ActivityWizardPage {
    private ListDialogField fSelectionField;
    private ActivityUtil.ActivityConstant fCurrentSelection;

    public ActivitySelectionWizardPage(String pageName) {
        super(pageName, ActivityEditMode.ADD);
        this.setTitle("Add a new activity");
        this.setDescription("Select an activity");
    }

    @Override
    protected void createFieldControls(Composite composite, int nColumns) {
        CopyListener copyListener = new CopyListener();
        String[] addButtons = new String[]{};
        this.fSelectionField = new ListDialogField(copyListener, addButtons, (IBaseLabelProvider)new CopyListLabelProvider());
        this.fSelectionField.setDialogFieldListener(copyListener);
        this.fSelectionField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.fSelectionField.setLabelText(null);
        this.fSelectionField.setElements(new ArrayList<Object>(ActivityUtil.getTopLevelActivities()));
        this.fSelectionField.doFillIntoGrid(composite, nColumns);
        TableViewer tableViewer = this.fSelectionField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"Activity"});
        GridData gd = (GridData)this.fSelectionField.getListControl(null).getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.fCurrentSelection = null;
        this.setPageComplete(false);
    }

    public ActivityUtil.ActivityConstant getSelectedActivity() {
        return this.fCurrentSelection;
    }

    @Override
    public WizardPageCode getCode() {
        return WizardPageCode.SEND;
    }

    private static class CopyListLabelProvider
    extends LabelProvider {
        private CopyListLabelProvider() {
        }

        public String getText(Object element) {
            return ((ActivityUtil.ActivityConstant)element).getNiceName();
        }

        public Image getImage(Object element) {
            return ToolSupportActivator.getImage("img_activity");
        }
    }

    private class CopyListener
    implements IListAdapter,
    IDialogFieldListener {
        private CopyListener() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            if (field.getSelectedElements().size() == 1) {
                ActivitySelectionWizardPage.this.setPageComplete(true);
                ActivitySelectionWizardPage.this.fCurrentSelection = (ActivityUtil.ActivityConstant)field.getSelectedElements().get(0);
            } else {
                ActivitySelectionWizardPage.this.setPageComplete(false);
                ActivitySelectionWizardPage.this.fCurrentSelection = null;
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

