/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.xml.suite.XMLCondition;
import net.bpelunit.framework.xml.suite.XMLReceiveActivity;
import net.bpelunit.toolsupport.editors.formwidgets.HyperlinkField;
import net.bpelunit.toolsupport.editors.wizards.NamespaceWizard;
import net.bpelunit.toolsupport.editors.wizards.components.StructuredDataComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import net.bpelunit.toolsupport.util.XPathValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ReceiveComponent
extends StructuredDataComponent
implements HyperlinkField.IHyperLinkFieldListener {
    private ListDialogField fConditionsField;
    private XMLReceiveActivity fReceiveOperation;

    public ReceiveComponent(IWizardPage page, FontMetrics metrics) {
        super(page, metrics);
    }

    @Override
    public void handleAddPressed() {
        String[] edit = this.editCondition(null);
        if (edit != null) {
            XMLCondition xmlCondition = this.fReceiveOperation.addNewCondition();
            xmlCondition.setExpression(edit[0]);
            xmlCondition.setValue(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fConditionsField, false);
        }
    }

    @Override
    public void handleEditPressed() {
        XMLCondition xmlCondition = this.getSelectedCondition();
        if (xmlCondition != null) {
            this.openConditionEditor(xmlCondition);
        }
    }

    @Override
    public void handleRemovePressed() {
        int index;
        XMLCondition cond = this.getSelectedCondition();
        if (cond != null && (index = ActivityUtil.getIndexFor((Object[])this.fReceiveOperation.getConditionArray(), (Object)cond)) != -1) {
            this.fReceiveOperation.removeCondition(index);
            this.recreateInput();
            this.enableButtonsForSelection(this.fConditionsField, false);
        }
    }

    private XMLCondition getSelectedCondition() {
        List<Object> selectedElements = this.fConditionsField.getSelectedElements();
        if (selectedElements.size() > 0) {
            return (XMLCondition)selectedElements.get(0);
        }
        return null;
    }

    private String[] editCondition(XMLCondition currentProperty) {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getWizard().getShell(), "Add a condition");
        String initialExpression = currentProperty != null ? currentProperty.getExpression() : null;
        String initialValue = currentProperty != null ? currentProperty.getValue() : null;
        TextField expressionField = new TextField(dialog, "Expression", initialExpression, TextField.Style.MULTI);
        expressionField.setValidator((DialogFieldValidator)new XPathValidator("expression"));
        dialog.addField((Field)expressionField);
        TextField valueField = new TextField(dialog, "Value", initialValue, TextField.Style.MULTI);
        valueField.setValidator((DialogFieldValidator)new NotEmptyValidator("value"));
        dialog.addField((Field)valueField);
        if (dialog.open() != 0) {
            return null;
        }
        String[] s = new String[]{expressionField.getSelection(), valueField.getSelection()};
        return s;
    }

    public void init(XMLReceiveActivity receiveOperation) {
        StructuredDataComponent.ListFieldListener conditionListener = this.createListFieldListener();
        this.fConditionsField = new ListDialogField(conditionListener, fButtons, (IBaseLabelProvider)new ConditionsListLabelProvider());
        this.fConditionsField.setDialogFieldListener(conditionListener);
        this.fConditionsField.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Condition", "Value"}, true));
        this.fConditionsField.setLabelText(null);
        this.fReceiveOperation = receiveOperation;
        this.recreateInput();
    }

    @Override
    public Composite createControls(Composite composite, int nColumns) {
        Group group = this.createGroup(composite, "Conditions to be verified", nColumns, new GridData(4, 4, true, true));
        this.fConditionsField.doFillIntoGrid((Composite)group, nColumns);
        TableViewer tableViewer = this.fConditionsField.getTableViewer();
        tableViewer.getTable().setHeaderVisible(true);
        GridData gd = (GridData)this.fConditionsField.getListControl(null).getLayoutData();
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        gd.grabExcessHorizontalSpace = true;
        HyperlinkField field = new HyperlinkField("Configure Namespace Prefixes...");
        field.setHyperLinkFieldListener(this);
        field.createControl((Composite)group, nColumns, 1);
        return group;
    }

    public void recreateInput() {
        ArrayList<Object> l = new ArrayList<Object>();
        XMLCondition[] xMLConditionArray = this.fReceiveOperation.getConditionArray();
        int n = xMLConditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLCondition o = xMLConditionArray[n2];
            l.add(o);
            ++n2;
        }
        this.fConditionsField.setElements(l);
        this.enableButtonsForSelection(this.fConditionsField, false);
    }

    public void openConditionEditor(XMLCondition xmlCondition) {
        String[] edit = this.editCondition(xmlCondition);
        if (edit != null) {
            xmlCondition.setExpression(edit[0]);
            xmlCondition.setValue(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fConditionsField, false);
        }
    }

    @Override
    public void hyperLinkActivated() {
        WizardDialog d = new WizardDialog(this.getShell(), (IWizard)new NamespaceWizard(this.getTestSuite()));
        d.open();
    }

    private static class ConditionsListLabelProvider
    implements ITableLabelProvider {
        private ConditionsListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XMLCondition) {
                XMLCondition property = (XMLCondition)element;
                switch (columnIndex) {
                    case 0: {
                        return property.getExpression();
                    }
                    case 1: {
                        return property.getValue();
                    }
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

