/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.xml.suite.XMLCopy;
import net.bpelunit.framework.xml.suite.XMLTwoWayActivity;
import net.bpelunit.toolsupport.editors.formwidgets.HyperlinkField;
import net.bpelunit.toolsupport.editors.wizards.NamespaceWizard;
import net.bpelunit.toolsupport.editors.wizards.components.StructuredDataComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import net.bpelunit.toolsupport.util.XPathValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class DataCopyComponent
extends StructuredDataComponent
implements HyperlinkField.IHyperLinkFieldListener {
    private ListDialogField fDataCopyField;
    private XMLTwoWayActivity fParentActivity;

    public DataCopyComponent(IWizardPage wizard, FontMetrics metrics) {
        super(wizard, metrics);
    }

    @Override
    public void handleAddPressed() {
        String[] edit = this.editCopy(null);
        if (edit != null) {
            XMLCopy xmlCopy = this.fParentActivity.getMapping().addNewCopy();
            xmlCopy.setFrom(edit[0]);
            xmlCopy.setTo(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fDataCopyField, false);
        }
    }

    @Override
    public void handleEditPressed() {
        XMLCopy current = this.getSelectedCopy();
        if (current == null) {
            return;
        }
        String[] edit = this.editCopy(current);
        if (edit != null) {
            current.setFrom(edit[0]);
            current.setTo(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fDataCopyField, false);
        }
    }

    @Override
    public void handleRemovePressed() {
        int index;
        XMLCopy copy = this.getSelectedCopy();
        if (copy != null && (index = ActivityUtil.getIndexFor((Object[])this.fParentActivity.getMapping().getCopyArray(), (Object)copy)) != -1) {
            this.fParentActivity.getMapping().removeCopy(index);
            this.recreateInput();
            this.enableButtonsForSelection(this.fDataCopyField, false);
        }
    }

    private XMLCopy getSelectedCopy() {
        List<Object> selectedElements = this.fDataCopyField.getSelectedElements();
        if (selectedElements.size() > 0) {
            return (XMLCopy)selectedElements.get(0);
        }
        return null;
    }

    public void recreateInput() {
        ArrayList<Object> l = new ArrayList<Object>();
        XMLCopy[] xMLCopyArray = this.fParentActivity.getMapping().getCopyArray();
        int n = xMLCopyArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLCopy o = xMLCopyArray[n2];
            l.add(o);
            ++n2;
        }
        this.fDataCopyField.setElements(l);
    }

    private String[] editCopy(XMLCopy currentProperty) {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getWizard().getShell(), "Add a copy operation");
        String initialFrom = currentProperty != null ? currentProperty.getFrom() : null;
        String initialTo = currentProperty != null ? currentProperty.getTo() : null;
        TextField fromField = new TextField(dialog, "Source", initialFrom, TextField.Style.MULTI);
        fromField.setValidator((DialogFieldValidator)new XPathValidator("source"));
        dialog.addField((Field)fromField);
        TextField toField = new TextField(dialog, "Target", initialTo, TextField.Style.MULTI);
        toField.setValidator((DialogFieldValidator)new XPathValidator("target"));
        dialog.addField((Field)toField);
        if (dialog.open() != 0) {
            return null;
        }
        String[] s = new String[]{fromField.getSelection(), toField.getSelection()};
        return s;
    }

    public void init(XMLTwoWayActivity activity) {
        StructuredDataComponent.ListFieldListener copyListener = new StructuredDataComponent.ListFieldListener();
        this.fDataCopyField = new ListDialogField(copyListener, fButtons, (IBaseLabelProvider)new CopyListLabelProvider());
        this.fDataCopyField.setDialogFieldListener(copyListener);
        this.fDataCopyField.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"From", "To"}, true));
        this.fDataCopyField.setLabelText(null);
        if (activity.getMapping() == null) {
            activity.addNewMapping();
        }
        this.fParentActivity = activity;
        ArrayList<Object> l = new ArrayList<Object>();
        XMLCopy[] xMLCopyArray = this.fParentActivity.getMapping().getCopyArray();
        int n = xMLCopyArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLCopy o = xMLCopyArray[n2];
            l.add(o);
            ++n2;
        }
        this.fDataCopyField.setElements(l);
        this.enableButtonsForSelection(this.fDataCopyField, false);
    }

    @Override
    public Composite createControls(Composite composite, int nColumns) {
        Group group = this.createGroup(composite, "Data Copy Operations", nColumns, new GridData(4, 4, true, true));
        this.fDataCopyField.doFillIntoGrid((Composite)group, nColumns);
        TableViewer tableViewer = this.fDataCopyField.getTableViewer();
        tableViewer.getTable().setHeaderVisible(true);
        GridData gd = (GridData)this.fDataCopyField.getListControl(null).getLayoutData();
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        gd.grabExcessHorizontalSpace = true;
        HyperlinkField field = new HyperlinkField("Configure Namespace Prefixes...");
        field.setHyperLinkFieldListener(this);
        field.createControl((Composite)group, nColumns, 1);
        return group;
    }

    @Override
    public void hyperLinkActivated() {
        WizardDialog d = new WizardDialog(this.getShell(), (IWizard)new NamespaceWizard(this.getTestSuite()));
        d.open();
    }

    private static class CopyListLabelProvider
    implements ITableLabelProvider {
        private CopyListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XMLCopy) {
                XMLCopy property = (XMLCopy)element;
                switch (columnIndex) {
                    case 0: {
                        return property.getFrom();
                    }
                    case 1: {
                        return property.getTo();
                    }
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

