/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards;

import javax.xml.namespace.QName;
import net.bpelunit.framework.xml.suite.XMLReceiveActivity;
import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.BPELUnitEditor;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.pages.ActivityWizardPage;
import net.bpelunit.toolsupport.editors.wizards.pages.OperationWizardPage;
import net.bpelunit.toolsupport.util.ToolUtil;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public abstract class ActivityWizard
extends Wizard {
    private TestSuitePage fPage;
    WizardPageCode fStartupPageCode;
    private ActivityEditMode fMode;

    public ActivityWizard(TestSuitePage page, ActivityEditMode mode) {
        this.fMode = mode;
        this.fPage = page;
        this.setWindowTitle(this.getPageName());
    }

    protected abstract String getPageName();

    public IWizardPage getStartingPage() {
        if (this.fStartupPageCode != null) {
            IWizardPage[] pages;
            IWizardPage[] iWizardPageArray = pages = this.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage element = iWizardPageArray[n2];
                ActivityWizardPage page = (ActivityWizardPage)element;
                if (page.getCode().equals((Object)this.fStartupPageCode)) {
                    return page;
                }
                ++n2;
            }
        }
        return super.getStartingPage();
    }

    protected void transferOperation(OperationWizardPage page, XMLSoapActivity activity) {
        QName service = page.getService();
        String port = page.getPort();
        String operation = page.getOperation();
        activity.setService(service);
        activity.setPort(port);
        activity.setOperation(operation);
    }

    protected void transferFault(boolean fault, XMLReceiveActivity activity) {
        activity.setFault(fault);
    }

    protected void transferFault(boolean fault, XMLSendActivity activity) {
        activity.setFault(fault);
    }

    protected void transferFaultString(String faultString, XMLReceiveActivity activity) {
        if (faultString == null || "".equals(faultString)) {
            if (activity.isSetFaultstring()) {
                activity.unsetFaultstring();
            }
        } else {
            activity.setFaultstring(faultString);
        }
    }

    protected void transferFaultString(String faultString, XMLSendActivity activity) {
        if (faultString == null || "".equals(faultString)) {
            if (activity.isSetFaultstring()) {
                activity.unsetFaultstring();
            }
        } else {
            activity.setFaultstring(faultString);
        }
    }

    protected void transferDelay(String delaySequence, XMLSendActivity activity) {
        if (delaySequence == null || "".equals(delaySequence)) {
            if (activity.isSetDelaySequence()) {
                activity.unsetDelaySequence();
            }
        } else {
            activity.setDelaySequence(delaySequence);
        }
    }

    protected void transferLiteralSendData(String sendXML, XMLSendActivity sendActivity) {
        XmlObject any = ToolUtil.parseSendBlock(this.getTestSuite(), sendXML);
        if (any != null) {
            sendActivity.getData().set(any);
        }
    }

    protected ActivityEditMode getMode() {
        return this.fMode;
    }

    public BPELUnitEditor getEditor() {
        return this.fPage.getSuiteEditor();
    }

    public XMLTestSuite getTestSuite() {
        return this.getEditor().getTestSuite();
    }

    public void setStart(WizardPageCode code) {
        this.fStartupPageCode = code;
    }
}

