/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import java.util.ArrayList;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.CheckBoxField;
import net.bpelunit.framework.client.eclipse.dialog.field.ComboField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.client.eclipse.dialog.validate.NullValidator;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestCasesSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.sections.TreeSection;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Node;

public class TestCaseAndTrackSection
extends TreeSection {
    public TestCaseAndTrackSection(Composite parent, TestSuitePage page, FormToolkit toolkit) {
        super(parent, toolkit, page, true, true);
        this.init();
    }

    private void init() {
        this.getViewer().setLabelProvider((IBaseLabelProvider)new TestCaseLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new TestCaseContentProvider());
    }

    @Override
    protected String getDescription() {
        return "Manage test cases and partner tracks.";
    }

    @Override
    protected String getName() {
        return "Test Cases and Tracks";
    }

    public void refresh() {
        this.setViewerInput(this.getTestCasesXMLPart());
        this.getTreeViewer().expandAll();
        super.refresh();
    }

    private XMLTestCasesSection getTestCasesXMLPart() {
        XMLTestSuite model = this.getEditor().getTestSuite();
        return model.getTestCases();
    }

    @Override
    protected void addPressed() {
        this.addTestCase();
    }

    protected void addPartnerTrack(XMLTestCase to) {
        String name = this.editPartnerTrack("Add a new partner track", null);
        if (name != null && name.length() > 0) {
            XMLPartnerTrack track = to.addNewPartnerTrack();
            track.setName(name);
            this.adjust();
        }
    }

    protected void addClientTrack(XMLTestCase to) {
        to.addNewClientTrack();
        this.adjust();
    }

    private void addTestCase() {
        String[] results = this.editTestCase("Add a new test case", null, null, false, false);
        if (results != null) {
            XMLPartnerDeploymentInformation[] allDeployers;
            XMLTestCase testCase = this.getTestCasesXMLPart().addNewTestCase();
            testCase.setName(results[0]);
            testCase.setBasedOn(results[1]);
            testCase.setAbstract(Boolean.parseBoolean(results[2]));
            testCase.setVary(Boolean.parseBoolean(results[3]));
            testCase.addNewClientTrack();
            XMLPartnerDeploymentInformation[] xMLPartnerDeploymentInformationArray = allDeployers = this.getAllDeployers();
            int n = allDeployers.length;
            int n2 = 0;
            while (n2 < n) {
                XMLPartnerDeploymentInformation information = xMLPartnerDeploymentInformationArray[n2];
                XMLPartnerTrack track = testCase.addNewPartnerTrack();
                track.setName(information.getName());
                ++n2;
            }
            this.adjust();
            this.getTreeViewer().expandToLevel((Object)testCase, -1);
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)testCase));
        }
    }

    private XMLPartnerDeploymentInformation[] getAllDeployers() {
        XMLTestSuite model = this.getEditor().getTestSuite();
        XMLPartnerDeploymentInformation[] partnerArray = model.getDeployment().getPartnerArray();
        return partnerArray;
    }

    @Override
    protected void editPressed() {
        Object current = this.getViewerSelection();
        if (current instanceof XMLTestCase) {
            XMLTestCase testCase = (XMLTestCase)current;
            String[] results = this.editTestCase("Edit a test case", testCase.getName(), testCase.getBasedOn(), testCase.getAbstract(), testCase.getVary());
            if (results != null) {
                testCase.setName(results[0]);
                testCase.setBasedOn(results[1]);
                testCase.setAbstract(Boolean.parseBoolean(results[2]));
                testCase.setVary(Boolean.parseBoolean(results[3]));
                this.setEditRemoveDuplicateEnabled(true);
                this.adjust();
            }
        } else if (current instanceof XMLPartnerTrack) {
            this.editPartnerTrack((XMLPartnerTrack)current);
        }
    }

    private void editPartnerTrack(XMLPartnerTrack track) {
        String name = this.editPartnerTrack("Edit a partner track", track.getName());
        if (name != null) {
            track.setName(name);
            this.setEditRemoveDuplicateEnabled(true);
            this.adjust();
        }
    }

    @Override
    protected void removePressed() {
        Object current = this.getViewerSelection();
        if (current instanceof XMLTestCase) {
            this.removeTestCase(current);
        } else {
            this.removeTrack((XMLTrack)current);
        }
    }

    private void removeTestCase(Object current) {
        XMLTestCasesSection testCaseSection = this.getTestCasesXMLPart();
        XMLTestCase[] testCaseList = testCaseSection.getTestCaseArray();
        int i = 0;
        XMLTestCase[] xMLTestCaseArray = testCaseList;
        int n = testCaseList.length;
        int n2 = 0;
        while (n2 < n) {
            XMLTestCase testCase = xMLTestCaseArray[n2];
            if (testCase.equals(current)) {
                testCaseSection.removeTestCase(i);
                break;
            }
            ++i;
            ++n2;
        }
        this.getViewer().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    private void removeTrack(XMLTrack track) {
        XmlObject o;
        XmlCursor c = track.newCursor();
        if (c.toParent() && (o = c.getObject()) instanceof XMLTestCase) {
            XMLPartnerTrack[] partnerTrackList;
            XMLTestCase current = (XMLTestCase)o;
            int i = 0;
            boolean found = false;
            XMLPartnerTrack[] xMLPartnerTrackArray = partnerTrackList = current.getPartnerTrackArray();
            int n = partnerTrackList.length;
            int n2 = 0;
            while (n2 < n) {
                XMLPartnerTrack track2 = xMLPartnerTrackArray[n2];
                if (track2.equals(track)) {
                    found = true;
                    break;
                }
                ++i;
                ++n2;
            }
            if (found) {
                current.removePartnerTrack(i);
                this.getPage().postTrackSelected(null);
            }
        }
        this.getViewer().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    @Override
    protected void upPressed() {
        XMLTestCase xmlTestCase;
        XmlCursor currentCursor;
        Object viewerSelection = this.getViewerSelection();
        if (viewerSelection instanceof XMLTestCase && (currentCursor = (xmlTestCase = (XMLTestCase)viewerSelection).newCursor()).toPrevSibling()) {
            xmlTestCase.newCursor().moveXml(currentCursor);
            this.adjust();
        }
    }

    @Override
    protected void downPressed() {
        XMLTestCase xmlTestCase;
        XmlCursor currentCursor;
        Object viewerSelection = this.getViewerSelection();
        if (viewerSelection instanceof XMLTestCase && (currentCursor = (xmlTestCase = (XMLTestCase)viewerSelection).newCursor()).toNextSibling()) {
            currentCursor.moveXml(xmlTestCase.newCursor());
            this.adjust();
        }
    }

    @Override
    protected void duplicatePressed() {
        Object viewerSelection = this.getViewerSelection();
        if (viewerSelection instanceof XMLTestCase) {
            XMLTestCase testCase = (XMLTestCase)viewerSelection;
            Node node = testCase.getDomNode();
            node.getParentNode().appendChild(node.cloneNode(true));
            this.adjust();
        }
    }

    private void adjust() {
        this.getViewer().refresh();
        this.markDirty();
    }

    private String editPartnerTrack(String title, String current) {
        XMLPartnerDeploymentInformation[] partnerList = this.getEditor().getTestSuite().getDeployment().getPartnerArray();
        String[] partnerNames = new String[partnerList.length];
        int i = 0;
        boolean found = false;
        XMLPartnerDeploymentInformation[] xMLPartnerDeploymentInformationArray = partnerList;
        int n = partnerList.length;
        int n2 = 0;
        while (n2 < n) {
            XMLPartnerDeploymentInformation information = xMLPartnerDeploymentInformationArray[n2];
            partnerNames[i] = information.getName();
            if (partnerNames[i].equals(current)) {
                found = true;
            }
            ++i;
            ++n2;
        }
        if (!found) {
            current = null;
        }
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        ComboField combo = new ComboField(dialog, "Name:", current, partnerNames);
        combo.setValidator((DialogFieldValidator)new NotEmptyValidator("Name"));
        dialog.addField((Field)combo);
        if (dialog.open() != 0) {
            return null;
        }
        return combo.getSelection();
    }

    private String[] editTestCase(String title, String currentName, String currentBasedOn, boolean currentAbstractSetting, boolean currentVarySetting) {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        TextField nameField = new TextField(dialog, "Name:", currentName, TextField.Style.SINGLE);
        nameField.setValidator((DialogFieldValidator)new NotEmptyValidator("Name"));
        dialog.addField((Field)nameField);
        TextField basedOnField = new TextField(dialog, "Based On:", currentBasedOn, TextField.Style.SINGLE);
        basedOnField.setValidator((DialogFieldValidator)new NullValidator());
        dialog.addField((Field)basedOnField);
        CheckBoxField abstractField = new CheckBoxField(dialog, "Abstract", currentAbstractSetting);
        abstractField.setValidator((DialogFieldValidator)new NotEmptyValidator("Abstract"));
        dialog.addField((Field)abstractField);
        CheckBoxField varyField = new CheckBoxField(dialog, "Vary send delay times", currentVarySetting);
        varyField.setValidator((DialogFieldValidator)new NotEmptyValidator("Vary"));
        dialog.addField((Field)varyField);
        if (dialog.open() != 0) {
            return null;
        }
        return new String[]{nameField.getSelection(), basedOnField.getSelection(), abstractField.getSelection(), varyField.getSelection()};
    }

    @Override
    protected void itemSelected(Object firstElement) {
        if (firstElement instanceof XMLTrack) {
            XMLTrack selection = (XMLTrack)firstElement;
            this.getPage().postTrackSelected(selection);
        }
        this.setEnabled(BUTTON_REMOVE, this.getIsDeleteEnabled(firstElement));
        this.setEnabled(BUTTON_EDIT, this.getIsEditEnabled(firstElement));
        this.setEnabled(BUTTON_DUPLICATE, this.getIsDuplicateEnabled(firstElement));
        this.setEnabled("UP", this.getIsMoveEnabled(firstElement) && ActivityUtil.hasPrevious((XmlObject)((XmlObject)firstElement)));
        this.setEnabled("DOWN", this.getIsMoveEnabled(firstElement) && ActivityUtil.hasNext((XmlObject)((XmlObject)firstElement)));
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.getViewer().getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        MenuManager newMenu = new MenuManager("&New");
        if (ssel.size() == 0 || ssel.size() == 1 && ssel.getFirstElement() instanceof XMLTestCase) {
            this.createAction((IMenuManager)newMenu, "Test Case", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.addPressed();
                }
            });
        }
        if (ssel.size() == 1) {
            Object object = ssel.getFirstElement();
            if (object instanceof XMLTestCase) {
                final XMLTestCase testCase = (XMLTestCase)object;
                this.createAction((IMenuManager)newMenu, "Partner Track", new Action(){

                    public void run() {
                        TestCaseAndTrackSection.this.addPartnerTrack(testCase);
                    }
                });
                Action newClientTrackAction = this.createAction((IMenuManager)newMenu, "Client Track", new Action(){

                    public void run() {
                        TestCaseAndTrackSection.this.addClientTrack(testCase);
                    }
                });
                newClientTrackAction.setEnabled(testCase.getClientTrack() == null);
            }
            manager.add((IContributionItem)newMenu);
            manager.add((IContributionItem)new Separator());
            Action editAction = this.createAction(manager, "&Edit", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.editPressed();
                }
            });
            editAction.setEnabled(this.getIsEditEnabled(object));
            manager.add((IContributionItem)new Separator());
            Action removeAction = this.createAction(manager, "&Delete", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.removePressed();
                }
            });
            removeAction.setEnabled(this.getIsDeleteEnabled(object));
            manager.add((IContributionItem)new Separator());
            Action duplicateAction = this.createAction(manager, "D&uplicate", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.removePressed();
                }
            });
            duplicateAction.setEnabled(this.getIsDeleteEnabled(object));
        }
    }

    private boolean getIsMoveEnabled(Object object) {
        return object instanceof XMLTestCase;
    }

    private boolean getIsEditEnabled(Object object) {
        return object instanceof XMLPartnerTrack || object instanceof XMLTestCase;
    }

    private boolean getIsDuplicateEnabled(Object object) {
        return object instanceof XMLTestCase;
    }

    private boolean getIsDeleteEnabled(Object object) {
        return object instanceof XMLTestCase;
    }

    private class TestCaseContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY_LIST = new Object[0];
        private XMLTestCasesSection fSection;

        private TestCaseContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof XMLTestCasesSection) {
                XMLTestCasesSection element = (XMLTestCasesSection)inputElement;
                return element.getTestCaseArray();
            }
            return this.EMPTY_LIST;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof XMLTestCasesSection) {
                this.fSection = (XMLTestCasesSection)newInput;
            }
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof XMLTestCase) {
                XMLTestCase testCase = (XMLTestCase)parentElement;
                ArrayList<Object> tracks = new ArrayList<Object>();
                XMLPartnerTrack[] xMLPartnerTrackArray = testCase.getPartnerTrackArray();
                int n = xMLPartnerTrackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XMLPartnerTrack t = xMLPartnerTrackArray[n2];
                    tracks.add(t);
                    ++n2;
                }
                if (testCase.getClientTrack() != null) {
                    tracks.add(testCase.getClientTrack());
                }
                return tracks.toArray();
            }
            return this.EMPTY_LIST;
        }

        public Object getParent(Object element) {
            if (element instanceof XMLTrack) {
                XMLTestCase[] testCaseList;
                XMLTrack track = (XMLTrack)element;
                XMLTestCase[] xMLTestCaseArray = testCaseList = this.fSection.getTestCaseArray();
                int n = testCaseList.length;
                int n2 = 0;
                while (n2 < n) {
                    XMLPartnerTrack[] partnerTrackList;
                    XMLTestCase case1 = xMLTestCaseArray[n2];
                    XMLPartnerTrack[] xMLPartnerTrackArray = partnerTrackList = case1.getPartnerTrackArray();
                    int n3 = partnerTrackList.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        XMLPartnerTrack track2 = xMLPartnerTrackArray[n4];
                        if (track2.equals(track)) {
                            return case1;
                        }
                        ++n4;
                    }
                    if (element.equals(case1.getClientTrack())) {
                        return case1;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof XMLTestCase) {
                XMLTestCase testCase = (XMLTestCase)element;
                return testCase.getPartnerTrackArray().length > 0 || testCase.getClientTrack() != null;
            }
            return false;
        }
    }

    private class TestCaseLabelProvider
    implements ILabelProvider {
        private TestCaseLabelProvider() {
        }

        public Image getImage(Object element) {
            return ToolSupportActivator.getImage("img_testcase");
        }

        public String getText(Object element) {
            if (element instanceof XMLTestCase) {
                return ((XMLTestCase)element).getName();
            }
            if (element instanceof XMLPartnerTrack) {
                return ((XMLPartnerTrack)element).getName();
            }
            return "client";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

