/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import java.io.File;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebPage;
import net.blugrid.core.model.Website;
import net.blugrid.core.utils.FileUtils;
import net.blugrid.service.S3ServiceConnector;
import net.blugrid.service.SeoService;
import net.blugrid.service.WebscaperConnector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SeoServiceImpl
implements SeoService {
    private static final Logger logger = Logger.getLogger(SeoServiceImpl.class);
    @Autowired
    private WebscaperConnector Webscaperconnector;
    @Autowired
    private S3ServiceConnector S3Serviceconnector;
    @Autowired
    private FileUtils Fileutils;

    @Override
    @Async
    public void saveStaticWebSite(Token token, Website website) {
        if (website.getWebpages() != null) {
            for (WebPage webpage : website.getWebpages()) {
                this.saveStaticWebPage(token, webpage);
            }
        }
        if (website.getDefaultwebpage() != null) {
            this.saveStaticHomePage(token, website.getDefaultwebpage());
        }
    }

    @Override
    public void saveStaticWebPage(Token token, WebPage webpage) {
        if (webpage.getLft() != 1) {
            String bucketName = webpage.getDomainname();
            String awspath = "static" + webpage.getUrl().replace("#!", "") + "/index.html";
            String doc = this.getDocument(token, webpage);
            this.saveDocument(token, doc, bucketName, awspath);
        }
    }

    @Override
    public void saveStaticHomePage(Token token, WebPage webpage) {
        String bucketName = webpage.getDomainname();
        String awspath = "static/index.html";
        String doc = this.getDocument(token, webpage);
        this.saveDocument(token, doc, bucketName, awspath);
    }

    private void saveDocument(Token token, String doc, String bucketName, String awspath) {
        File file = this.Fileutils.convertStringToFile(token, doc, bucketName + "_" + awspath.toLowerCase().replaceAll("/", "_"));
        this.S3Serviceconnector.uploadFile(token, bucketName, file, awspath);
    }

    private String getDocument(Token token, WebPage webpage) {
        String baseuri = "https://" + webpage.getDomainname();
        String prerenderurl = webpage.getAbsolutestaticpath();
        String str = this.Webscaperconnector.getWebPageDocument(token, baseuri, prerenderurl, webpage.getUrl());
        logger.info((Object)("webpage string length: " + str.length()));
        return str;
    }
}

