/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import net.blugrid.core.model.JwtToken;
import net.blugrid.core.model.Operator;
import net.blugrid.core.model.SessionResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.TokenHandler;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TokenHandlerImpl
implements TokenHandler {
    private static final Logger logger = Logger.getLogger(TokenHandlerImpl.class);

    @Override
    public SessionResponse setJjwtToken(SessionResponse session) {
        if (session.getSession() != null) {
            JwtToken jwttoken = this.createJwtToken(session.getSession().getSessiontoken().getid_token());
            session.getSession().setJwttoken(jwttoken);
        }
        return session;
    }

    @Override
    public JwtToken createJwtToken(String string) {
        Token token = new Token();
        token.setid_token(string);
        String key = "a5k3zx!";
        byte[] authBytes = key.getBytes(StandardCharsets.UTF_8);
        String key64 = Base64.getEncoder().encodeToString(authBytes);
        Gson gson = new Gson();
        String payload = gson.toJson((Object)token);
        String jwt = Jwts.builder().setSubject(payload).signWith(SignatureAlgorithm.HS256, key64).compact();
        JwtToken jwttoken = new JwtToken();
        jwttoken.setId_token(jwt);
        logger.info((Object)("jwttoken created - " + jwttoken));
        return jwttoken;
    }

    @Override
    public Token convertJwtToken(String jwttoken) {
        jwttoken = jwttoken.replace("Bearer", "");
        String key = "a5k3zx!";
        byte[] authBytes = key.getBytes(StandardCharsets.UTF_8);
        String key64 = Base64.getEncoder().encodeToString(authBytes);
        String name = ((Claims)Jwts.parser().setSigningKey(key64).parseClaimsJws(jwttoken).getBody()).getSubject();
        Gson gson = new Gson();
        Token token = (Token)gson.fromJson(name, Token.class);
        token.setJwttoken(jwttoken);
        logger.info((Object)("jwttoken unpacked - " + jwttoken));
        return token;
    }

    private Operator fromJSON(byte[] userBytes) {
        try {
            return (Operator)new ObjectMapper().readValue((InputStream)new ByteArrayInputStream(userBytes), Operator.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] toJSON(Operator operator) {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)operator);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String toBase64(byte[] content) {
        return DatatypeConverter.printBase64Binary((byte[])content);
    }

    private byte[] fromBase64(String content) {
        return DatatypeConverter.parseBase64Binary((String)content);
    }
}

