/*
 * Decompiled with CFR 0.152.
 */
package net.bican.wordpress;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcStruct;

public abstract class XmlRpcMapped {
    private static final Logger logger = LoggerFactory.getLogger(XmlRpcMapped.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    public void fromXmlRpcStruct(XmlRpcStruct x) {
        Field[] f = this.getClass().getDeclaredFields();
        String k = null;
        Object v = null;
        for (Field field : f) {
            try {
                k = field.getName();
                v = x.get((Object)k);
                Class<?> kType = field.getType();
                if (v == null) continue;
                try {
                    XmlRpcMapped object = (XmlRpcMapped)kType.newInstance();
                    object.fromXmlRpcStruct((XmlRpcStruct)v);
                    field.set(this, object);
                }
                catch (ClassCastException | InstantiationException e) {
                    if (kType == List.class) {
                        XmlRpcArray vList = (XmlRpcArray)v;
                        ArrayList<Object> result = new ArrayList<Object>();
                        if (vList.size() <= 0) continue;
                        Class<?> gType = vList.get(0).getClass();
                        String[] typeStr = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].toString().split(" ");
                        String[] typeStrSub = Arrays.copyOfRange(typeStr, 1, typeStr.length);
                        StringBuilder typeB = new StringBuilder();
                        int il = typeStrSub.length;
                        for (int i = 0; i < il; ++i) {
                            if (i > 0) {
                                typeB.append(" ");
                            }
                            typeB.append(typeStrSub[i]);
                        }
                        String type = typeB.toString();
                        try {
                            Class<?> clList = Class.forName(type, false, this.getClass().getClassLoader());
                            Iterator it = vList.iterator();
                            while (it.hasNext()) {
                                if (gType == String.class) {
                                    String itemToInsert = (String)it.next();
                                    result.add(itemToInsert);
                                    continue;
                                }
                                XmlRpcStruct item = (XmlRpcStruct)it.next();
                                try {
                                    XmlRpcMapped itemToInsert = (XmlRpcMapped)clList.newInstance();
                                    clList.cast(itemToInsert);
                                    itemToInsert.fromXmlRpcStruct(item);
                                    result.add(itemToInsert);
                                }
                                catch (InstantiationException e1) {
                                    logger.warn("field {} contains invalid types in response, skipping", (Object)k);
                                }
                            }
                            field.set(this, result);
                        }
                        catch (ClassNotFoundException e2) {
                            logger.error("cannot find class {}", (Object)type);
                        }
                        continue;
                    }
                    if (kType == Integer.class) {
                        if (v.getClass() != Integer.class) {
                            Integer vInt = Integer.valueOf((String)v);
                            field.set(this, vInt);
                            continue;
                        }
                        field.set(this, v);
                        continue;
                    }
                    if (kType == Double.class) {
                        if (v.getClass() != Double.class) {
                            Double vDouble = Double.valueOf((String)v);
                            field.set(this, vDouble);
                            continue;
                        }
                        field.set(this, v);
                        continue;
                    }
                    if (kType == Date.class) {
                        try {
                            if (v.getClass() != Date.class) {
                                Date vDate = sdf.parse((String)v);
                                field.set(this, vDate);
                                continue;
                            }
                            field.set(this, v);
                            continue;
                        }
                        catch (ParseException e1) {
                            throw new IllegalArgumentException(e1);
                        }
                    }
                    if (v instanceof Boolean && kType == String.class) {
                        field.set(this, ((Boolean)v).toString());
                        continue;
                    }
                    if (v instanceof String && ((String)v).equals("") && field.getType() != String.class) {
                        field.set(this, null);
                        continue;
                    }
                    field.set(this, v);
                }
            }
            catch (IllegalArgumentException e) {
                try {
                    if (v != null && v instanceof XmlRpcArray && ((XmlRpcArray)v).size() != 0) {
                        logger.warn("value {} is invalid for {}, setting it to null (while parsing {})", new Object[]{v, k, field.getName()});
                    }
                    field.set(this, null);
                }
                catch (IllegalAccessException e1) {
                    logger.error("cannot set the field to null: {}", (Object)e.getLocalizedMessage());
                }
            }
            catch (IllegalAccessException e) {
                logger.error("illegal access to object constructor: {}", (Object)e.getLocalizedMessage());
            }
        }
    }

    private String toGenericString(String recordDelimiter, String fieldDelimiter, boolean showFieldName) {
        String result = null;
        try {
            Field[] f;
            result = "";
            for (Field field : f = this.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Class<?> fType = field.getType();
                if (showFieldName) {
                    result = result + field.getName() + fieldDelimiter;
                }
                result = fType == Date.class ? result + sdf.format(field.get(this)) : result + field.get(this);
                result = result + recordDelimiter;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    public String toOneLinerString() {
        return this.toGenericString(":", "", false).replaceAll(":$", "");
    }

    public String toString() {
        return this.toGenericString("\n", ":", true);
    }

    public XmlRpcStruct toXmlRpcStruct() {
        Field[] f;
        XmlRpcStruct result = new XmlRpcStruct();
        for (Field field : f = this.getClass().getDeclaredFields()) {
            try {
                Object o;
                if (Modifier.isStatic(field.getModifiers()) || (o = field.get(this)) == null) continue;
                result.put((Object)field.getName(), o);
            }
            catch (IllegalAccessException e) {
                logger.error("cannot receive field {}, {}", (Object)field.getName(), (Object)e.getLocalizedMessage());
            }
        }
        return result;
    }
}

