/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.authorize.Environment;
import net.authorize.util.LogHelper;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClient {
    private static Logger logger = LogManager.getLogger(HttpClient.class);
    public static final String ENCODING = "UTF-8";
    static boolean proxySet = false;
    static boolean UseProxy = Environment.getBooleanProperty("https.proxyUse");
    static String ProxyHost = Environment.getProperty("https.proxyHost");
    static int ProxyPort = Environment.getIntProperty("https.proxyPort");
    static String proxyUsername = Environment.getProperty("https.proxyUsername");
    static String proxyPassword = Environment.getProperty("https.proxyPassword");
    static int httpConnectionTimeout = Environment.getIntProperty("http.ConnectionTimeout");
    static int httpReadTimeout = Environment.getIntProperty("http.ReadTimeout");
    static Timeout newHttpConnectionTimeout;
    static Timeout newHttpReadTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block23: {
            BufferedReader reader;
            block21: {
                String line;
                reader = new BufferedReader(new InputStreamReader(is));
                sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                if (null == reader) break block21;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e.getMessage());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing InputStream: '%s'", e.getMessage());
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    try {
                        LogHelper.warn(logger, "Exception reading data from Stream: '%s'", e.getMessage());
                        if (null == reader) break block22;
                    }
                    catch (Throwable throwable) {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e2.getMessage());
                            }
                        }
                        if (null != is) {
                            try {
                                is.close();
                            }
                            catch (IOException e3) {
                                LogHelper.warn(logger, "Exception closing InputStream: '%s'", e3.getMessage());
                            }
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e4) {
                        LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e4.getMessage());
                    }
                }
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        LogHelper.warn(logger, "Exception closing InputStream: '%s'", e5.getMessage());
                    }
                }
            }
        }
        return sb.toString();
    }

    private static SSLContext getSSLContext() {
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            sc.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static CloseableHttpClient getHttpsClient() throws Exception {
        SSLContext sslcontext = HttpClient.getSSLContext();
        try {
            CloseableHttpClient httpClient;
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_2}).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(newHttpReadTimeout).build()).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(newHttpConnectionTimeout).setSocketTimeout(newHttpReadTimeout).build()).build();
            RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
            if (UseProxy && ProxyHost != null) {
                if (proxyUsername != null && proxyPassword != null) {
                    LogHelper.info(logger, "Setting up proxy to URL with Authentication: '%s://%s@%s:%d'", "http", proxyUsername, ProxyHost, ProxyPort);
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    AuthScope proxyScope = new AuthScope(ProxyHost, ProxyPort);
                    UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword.toCharArray());
                    credsProvider.setCredentials(proxyScope, (Credentials)proxyCreds);
                    httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setProxy(new HttpHost("http", ProxyHost, ProxyPort)).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
                } else {
                    LogHelper.info(logger, "Setting up proxy to URL: '%s://%s:%d'", "http", ProxyHost, ProxyPort);
                    httpClient = HttpClientBuilder.create().setProxy(new HttpHost("http", ProxyHost, ProxyPort)).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
                }
                proxySet = true;
            } else {
                LogHelper.warn(logger, "Defaulting to non-proxy environment", new Object[0]);
                httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            }
            return httpClient;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        LogHelper.info(logger, "Use Proxy: '%s'", UseProxy);
        httpConnectionTimeout = httpConnectionTimeout == 0 ? 30000 : httpConnectionTimeout;
        httpReadTimeout = httpReadTimeout == 0 ? 30000 : httpReadTimeout;
        newHttpConnectionTimeout = Timeout.ofSeconds((long)httpConnectionTimeout);
        newHttpReadTimeout = Timeout.ofSeconds((long)httpReadTimeout);
    }
}

