/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.sim;

import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.authorize.Merchant;
import net.authorize.util.LogHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class Fingerprint {
    private static Log logger = LogFactory.getLog(Fingerprint.class);
    private long sequence;
    private long timeStamp;
    private String fingerprintHash;

    private Fingerprint() {
    }

    public static Fingerprint createFingerprint(String loginID, String transactionKey, long sequence, String amount) {
        return Fingerprint.createFingerprint(loginID, transactionKey, sequence, amount, "");
    }

    public static Fingerprint createFingerprint(String loginID, String transactionKey, long sequence, String amount, String currency) {
        Fingerprint fingerprint = new Fingerprint();
        SecureRandom generator = new SecureRandom();
        fingerprint.sequence = Long.parseLong(sequence + "" + generator.nextInt(1000));
        fingerprint.timeStamp = System.currentTimeMillis() / 1000L;
        try {
            SecretKeySpec key = new SecretKeySpec(transactionKey.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(key);
            String inputstring = loginID + "^" + fingerprint.sequence + "^" + fingerprint.timeStamp + "^" + amount + "^" + currency;
            byte[] result = mac.doFinal(inputstring.getBytes());
            StringBuilder strbuf = new StringBuilder(result.length * 2);
            for (byte aResult : result) {
                if ((aResult & 0xFF) < 16) {
                    strbuf.append("0");
                }
                strbuf.append(Long.toString(aResult & 0xFF, 16));
            }
            fingerprint.fingerprintHash = strbuf.toString();
        }
        catch (NoSuchAlgorithmException nsae) {
            LogHelper.error(logger, "Fingerprint creation failed.", nsae);
        }
        catch (InvalidKeyException ike) {
            LogHelper.error(logger, "Fingerprint creation failed.", ike);
        }
        return fingerprint;
    }

    public static Fingerprint createFingerprint(Merchant merchant, long sequence, BigDecimal amount) {
        Fingerprint fingerprint = new Fingerprint();
        if (merchant != null && amount != null) {
            fingerprint = Fingerprint.createFingerprint(merchant.getLogin(), merchant.getTransactionKey(), sequence, amount.setScale(2, 4).toPlainString());
        }
        return fingerprint;
    }

    public long getSequence() {
        return Math.abs(this.sequence);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getFingerprintHash() {
        return this.fingerprintHash;
    }
}

