/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.xml.reporting;

import java.util.ArrayList;
import java.util.Date;
import net.authorize.data.xml.reporting.BatchDetails;
import net.authorize.data.xml.reporting.TransactionDetails;
import net.authorize.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportingDetails {
    public static String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static String DATE_FORMAT_FULL = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private boolean batchIncludeStatistics = false;
    private Date batchFirstSettlementDate = null;
    private Date batchLastSettlementDate = null;
    private String batchId = null;
    private String transactionId = null;
    private ArrayList<BatchDetails> batchDetailsList = new ArrayList();
    private ArrayList<TransactionDetails> transactionDetailList = new ArrayList();

    private ReportingDetails() {
    }

    public static ReportingDetails createReportingDetails() {
        return new ReportingDetails();
    }

    public boolean isBatchIncludeStatistics() {
        return this.batchIncludeStatistics;
    }

    public void setBatchIncludeStatistics(boolean batchIncludeStatistics) {
        this.batchIncludeStatistics = batchIncludeStatistics;
    }

    public Date getBatchFirstSettlementDate() {
        return this.batchFirstSettlementDate;
    }

    public void setBatchFirstSettlementDate(Date batchFirstSettlementDate) {
        this.batchFirstSettlementDate = batchFirstSettlementDate;
    }

    public void setBatchFirstSettlementDate(String batchFirstSettlementDate) {
        this.batchFirstSettlementDate = DateUtil.getDateFromFormattedDate(batchFirstSettlementDate, DATE_FORMAT);
    }

    public Date getBatchLastSettlementDate() {
        return this.batchLastSettlementDate;
    }

    public void setBatchLastSettlementDate(Date batchLastSettlementDate) {
        this.batchLastSettlementDate = batchLastSettlementDate;
    }

    public void setBatchLastSettlementDate(String batchLastSettlementDate) {
        this.batchLastSettlementDate = DateUtil.getDateFromFormattedDate(batchLastSettlementDate, DATE_FORMAT);
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public ArrayList<BatchDetails> getBatchDetailsList() {
        return this.batchDetailsList;
    }

    public void setBatchDetailsList(ArrayList<BatchDetails> batchDetailList) {
        this.batchDetailsList = batchDetailList;
    }

    public ArrayList<TransactionDetails> getTransactionDetailList() {
        return this.transactionDetailList;
    }

    public void setTransactionDetailList(ArrayList<TransactionDetails> transactionDetailList) {
        this.transactionDetailList = transactionDetailList;
    }
}

