/*
 * Decompiled with CFR 0.152.
 */
package net.authorize;

import net.authorize.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    SANDBOX("https://test.authorize.net", "https://apitest.authorize.net", "https://test.authorize.net"),
    SANDBOX_TESTMODE("https://test.authorize.net", "https://apitest.authorize.net", "https://test.authorize.net"),
    PRODUCTION("https://secure.authorize.net", "https://api.authorize.net", "https://cardpresent.authorize.net"),
    PRODUCTION_TESTMODE("https://secure.authorize.net", "https://api.authorize.net", "https://cardpresent.authorize.net"),
    LOCAL_VM(null, null, null),
    HOSTED_VM(null, null, null),
    CUSTOM(null, null, null);

    private String baseUrl;
    private String xmlBaseUrl;
    private String cardPresentUrl;

    private Environment(String baseUrl, String xmlBaseUrl, String cardPresentUrl) {
        this.baseUrl = baseUrl;
        this.xmlBaseUrl = xmlBaseUrl;
        this.cardPresentUrl = cardPresentUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getXmlBaseUrl() {
        return this.xmlBaseUrl;
    }

    public String getCardPresentUrl() {
        return this.cardPresentUrl;
    }

    public static Environment createEnvironment(String baseUrl, String xmlBaseUrl) {
        Environment environment = CUSTOM;
        environment.baseUrl = baseUrl;
        environment.xmlBaseUrl = xmlBaseUrl;
        return environment;
    }

    public static Environment createEnvironment(String baseUrl, String xmlBaseUrl, String cardPresentUrl) {
        Environment environment = CUSTOM;
        environment.baseUrl = baseUrl;
        environment.xmlBaseUrl = xmlBaseUrl;
        environment.cardPresentUrl = cardPresentUrl;
        return environment;
    }

    public static int getIntProperty(String propertyName) {
        int value = 0;
        String stringValue = Environment.getProperty(propertyName);
        value = StringUtils.parseInt(stringValue);
        return value;
    }

    public static boolean getBooleanProperty(String propertyName) {
        boolean value = false;
        String stringValue = Environment.getProperty(propertyName);
        if (null != stringValue) {
            value = Boolean.parseBoolean(stringValue.trim());
        }
        return value;
    }

    public static String getProperty(String propertyName) {
        String stringValue = null;
        String propValue = System.getProperty(propertyName);
        String envValue = System.getenv(propertyName);
        if (null != propValue && propValue.trim().length() > 0) {
            stringValue = propValue;
        } else if (null != envValue && envValue.trim().length() > 0) {
            stringValue = envValue;
        }
        return stringValue;
    }
}

