/*
 * Decompiled with CFR 0.152.
 */
package net.authorize;

import net.authorize.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResponseCode {
    APPROVED(1, "This transaction has been approved."),
    DECLINED(2, "This transaction has been declined"),
    ERROR(3, "There has been an error processing this transaction."),
    REVIEW(4, "This transaction is being held for review."),
    UNKNOWN(0, "Unknown.");

    private final int code;
    private final String description;

    private ResponseCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ResponseCode findByResponseCode(int code) {
        for (ResponseCode responseCode : ResponseCode.values()) {
            if (responseCode.code != code) continue;
            return responseCode;
        }
        return UNKNOWN;
    }

    public static ResponseCode findByResponseCode(String code) {
        if (StringUtils.isNotEmpty(code)) {
            return ResponseCode.findByResponseCode(Integer.parseInt(code));
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

