/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.xml.reporting;

import java.util.ArrayList;
import java.util.Date;
import net.authorize.data.xml.reporting.BatchStatistics;
import net.authorize.data.xml.reporting.ReportingDetails;
import net.authorize.data.xml.reporting.SettlementStateType;
import net.authorize.util.DateUtil;
import net.authorize.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDetails {
    private String batchId;
    private Date settlementTimeUTC;
    private Date settlementTimeLocal;
    private SettlementStateType settlementState;
    private String paymentMethod;
    private ArrayList<BatchStatistics> batchStatisticsList = new ArrayList();

    private BatchDetails() {
    }

    public static BatchDetails createBatchDetail() {
        return new BatchDetails();
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Date getSettlementTimeUTC() {
        return this.settlementTimeUTC;
    }

    public void setSettlementTimeUTC(Date settlementTimeUTC) {
        this.settlementTimeUTC = settlementTimeUTC;
    }

    public void setSettlementTimeUTC(String settlementTimeUTC) {
        if (StringUtils.isNotEmpty(settlementTimeUTC)) {
            this.settlementTimeUTC = DateUtil.getDateFromFormattedDate(settlementTimeUTC, ReportingDetails.DATE_FORMAT);
        }
    }

    public Date getSettlementTimeLocal() {
        return this.settlementTimeLocal;
    }

    public void setSettlementTimeLocal(Date settlementTimeLocal) {
        this.settlementTimeLocal = settlementTimeLocal;
    }

    public void setSettlementTimeLocal(String settlementTimeLocal) {
        if (StringUtils.isNotEmpty(settlementTimeLocal)) {
            this.settlementTimeLocal = DateUtil.getDateFromFormattedDate(settlementTimeLocal, ReportingDetails.DATE_FORMAT);
        }
    }

    public SettlementStateType getSettlementState() {
        return this.settlementState;
    }

    public void setSettlementState(SettlementStateType settlementState) {
        this.settlementState = settlementState;
    }

    public ArrayList<BatchStatistics> getBatchStatisticsList() {
        return this.batchStatisticsList;
    }

    public void addBatchStatistics(BatchStatistics batchStatistics) {
        if (this.batchStatisticsList == null) {
            this.batchStatisticsList = new ArrayList();
        }
        this.batchStatisticsList.add(batchStatistics);
    }

    public void setBatchStatisticsList(ArrayList<BatchStatistics> batchStatisticsList) {
        this.batchStatisticsList = batchStatisticsList;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
}

