/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data;

import java.io.Serializable;
import java.math.BigDecimal;
import net.authorize.util.StringUtils;

public class ShippingCharges
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PO_NUMBER_LENGTH = 25;
    private String taxItemName;
    private String taxDescription;
    private BigDecimal taxAmount = new BigDecimal(0.0);
    private String freightItemName;
    private String freightDescription;
    private BigDecimal freightAmount = new BigDecimal(0.0);
    private String dutyItemName;
    private String dutyItemDescription;
    private BigDecimal dutyAmount = new BigDecimal(0.0);
    private boolean taxExempt = false;
    private String purchaseOrderNumber;

    private ShippingCharges() {
    }

    public static ShippingCharges createShippingCharges() {
        return new ShippingCharges();
    }

    public String getTaxItemName() {
        return this.taxItemName;
    }

    public void setTaxItemName(String taxItemName) {
        this.taxItemName = taxItemName;
    }

    public String getTaxDescription() {
        return this.taxDescription;
    }

    public void setTaxDescription(String taxDescription) {
        this.taxDescription = taxDescription;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        if (StringUtils.isNotEmpty(taxAmount)) {
            this.taxAmount = new BigDecimal(taxAmount).setScale(2, 4);
        }
    }

    public String getFreightItemName() {
        return this.freightItemName;
    }

    public void setFreightItemName(String freightItemName) {
        this.freightItemName = freightItemName;
    }

    public String getFreightDescription() {
        return this.freightDescription;
    }

    public void setFreightDescription(String freightDescription) {
        this.freightDescription = freightDescription;
    }

    public BigDecimal getFreightAmount() {
        return this.freightAmount;
    }

    public void setFreightAmount(BigDecimal freightAmount) {
        this.freightAmount = freightAmount;
    }

    public void setFreightAmount(String freightAmount) {
        if (StringUtils.isNotEmpty(freightAmount)) {
            this.freightAmount = new BigDecimal(freightAmount).setScale(2, 4);
        }
    }

    public String getDutyItemName() {
        return this.dutyItemName;
    }

    public void setDutyItemName(String dutyItemName) {
        this.dutyItemName = dutyItemName;
    }

    public String getDutyItemDescription() {
        return this.dutyItemDescription;
    }

    public void setDutyItemDescription(String dutyItemDescription) {
        this.dutyItemDescription = dutyItemDescription;
    }

    public BigDecimal getDutyAmount() {
        return this.dutyAmount;
    }

    public void setDutyAmount(BigDecimal dutyAmount) {
        this.dutyAmount = dutyAmount;
    }

    public void setDutyAmount(String dutyAmount) {
        if (StringUtils.isNotEmpty(dutyAmount)) {
            this.dutyAmount = new BigDecimal(dutyAmount).setScale(2, 4);
        }
    }

    public boolean isTaxExempt() {
        return this.taxExempt;
    }

    public void setTaxExempt(boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }
}

