/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.aim.cardpresent;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import net.authorize.AuthNetField;
import net.authorize.ResponseCode;
import net.authorize.ResponseReasonCode;
import net.authorize.aim.Transaction;
import net.authorize.data.creditcard.AVSCode;
import net.authorize.data.creditcard.CardType;
import net.authorize.data.creditcard.CreditCard;
import net.authorize.data.xml.reporting.CardCodeResponseType;
import net.authorize.util.BasicXmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result<T>
extends net.authorize.Result<T> {
    private static final long serialVersionUID = 1L;
    protected ResponseCode responseCode = null;
    protected ArrayList<ResponseReasonCode> responseReasonCodes = new ArrayList();
    private String authCode;
    private AVSCode avsResultCode;
    private CardCodeResponseType cardCodeResponse;
    private String transId;
    private String refTransId;
    private String transHash;
    private boolean testMode;
    private String userRef;
    protected BasicXmlDocument xmlResponseDocument;

    protected Result() {
    }

    public static <T> Result<T> createResult(T object, BasicXmlDocument response) {
        Result<T> result = new Result<T>();
        if (object instanceof Transaction) {
            Transaction targetTransaction = Transaction.createTransaction((Transaction)object, response);
            super.importResponseCode(targetTransaction);
            super.importResponseReasonCodes(targetTransaction);
            super.importAuthCode(targetTransaction);
            super.importAVSResultCode(targetTransaction);
            super.importCardCode(targetTransaction);
            super.importTransID(targetTransaction);
            super.importRefTransID(targetTransaction);
            super.importTransHash(targetTransaction);
            super.importTestMode(targetTransaction);
            super.importUserRef(targetTransaction);
            CreditCard creditCard = targetTransaction.getCreditCard();
            if (creditCard != null) {
                creditCard.setMaskedCreditCardNumber(super.getAccountNumber(targetTransaction));
                creditCard.setCardType(CardType.findByValue(super.getAccountType(targetTransaction)));
                creditCard.setAvsCode(result.avsResultCode);
                targetTransaction.setCreditCard(creditCard);
            }
            result.target = targetTransaction;
        }
        return result;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public ArrayList<ResponseReasonCode> getResponseReasonCodes() {
        return this.responseReasonCodes;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public AVSCode getAvsResultCode() {
        return this.avsResultCode;
    }

    public CardCodeResponseType getCardCodeResponse() {
        return this.cardCodeResponse;
    }

    public String getTransId() {
        return this.transId;
    }

    public String getRefTransId() {
        return this.refTransId;
    }

    public String getTransHash() {
        return this.transHash;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public String getUserRef() {
        return this.userRef;
    }

    public boolean isApproved() {
        return ResponseCode.APPROVED.equals((Object)this.responseCode);
    }

    public boolean isDeclined() {
        return ResponseCode.DECLINED.equals((Object)this.responseCode);
    }

    public boolean isError() {
        return ResponseCode.ERROR.equals((Object)this.responseCode);
    }

    private void importResponseCode(Transaction txn) {
        this.responseCode = ResponseCode.findByResponseCode(BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT__RESPONSE_CODE.getFieldName()));
    }

    private void importErrors(Transaction txn) {
        NodeList errors_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT__ERROR.getFieldName());
        for (int i = 0; i < errors_list.getLength(); ++i) {
            Element error_el = (Element)errors_list.item(i);
            ResponseReasonCode responseReasonCode = ResponseReasonCode.findByReasonCode(BasicXmlDocument.getElementText(error_el, AuthNetField.ELEMENT__ERROR_CODE.getFieldName()));
            responseReasonCode.setReasonText(BasicXmlDocument.getElementText(error_el, AuthNetField.ELEMENT__ERROR_TEXT.getFieldName()));
            this.responseReasonCodes.add(responseReasonCode);
        }
    }

    private void importMessages(Transaction txn) {
        NodeList message_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT__MESSAGE.getFieldName());
        for (int i = 0; i < message_list.getLength(); ++i) {
            Element message_el = (Element)message_list.item(i);
            ResponseReasonCode responseReasonCode = ResponseReasonCode.findByReasonCode(BasicXmlDocument.getElementText(message_el, AuthNetField.ELEMENT__CODE.getFieldName()));
            responseReasonCode.setReasonText(BasicXmlDocument.getElementText(message_el, AuthNetField.ELEMENT__DESCRIPTION.getFieldName()));
            this.responseReasonCodes.add(responseReasonCode);
        }
    }

    private void importResponseReasonCodes(Transaction txn) {
        switch (this.responseCode) {
            case APPROVED: {
                this.importMessages(txn);
                break;
            }
            case DECLINED: {
                this.importErrors(txn);
                break;
            }
            case ERROR: {
                this.importErrors(txn);
                break;
            }
        }
    }

    private void importAuthCode(Transaction txn) {
        this.authCode = BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__AUTH_CODE.getFieldName());
    }

    private void importAVSResultCode(Transaction txn) {
        this.avsResultCode = AVSCode.findByValue(BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__AVS_RESULT_CODE.getFieldName()));
    }

    private void importCardCode(Transaction txn) {
        this.cardCodeResponse = CardCodeResponseType.findByValue(BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__CVV_RESULT_CODE.getFieldName()));
    }

    private void importTransID(Transaction txn) {
        this.transId = BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__TRANS_ID.getFieldName());
    }

    private void importRefTransID(Transaction txn) {
        this.refTransId = BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__REF_TRANS_ID.getFieldName());
    }

    private void importTransHash(Transaction txn) {
        this.transHash = BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__TRANS_HASH.getFieldName());
    }

    private void importTestMode(Transaction txn) {
        String _testMode = BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__TEST_MODE.getFieldName());
        this.testMode = "1".equals(_testMode);
    }

    private void importUserRef(Transaction txn) {
        this.userRef = BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__USER_REF.getFieldName());
    }

    private String getAccountNumber(Transaction txn) {
        return BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__ACCOUNT_NUMBER.getFieldName());
    }

    private String getAccountType(Transaction txn) {
        return BasicXmlDocument.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT__ACCOUNT_TYPE.getFieldName());
    }

    public BasicXmlDocument getXmlResponseDocument() {
        return this.xmlResponseDocument;
    }

    public boolean isAuthorizeNet() {
        String amount = ((Transaction)this.target).getRequestMap().get(AuthNetField.X_AMOUNT.getFieldName());
        String MD5Value = ((Transaction)this.target).getMD5Value();
        String apiLoginId = ((Transaction)this.target).getRequestMap().get(AuthNetField.X_LOGIN.getFieldName());
        String md5Check = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String s = MD5Value + apiLoginId + this.getTransId() + amount;
            digest.update(s.getBytes());
            md5Check = new BigInteger(1, digest.digest()).toString(16).toUpperCase();
            while (md5Check.length() < 32) {
                md5Check = "0" + md5Check;
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            // empty catch block
        }
        return md5Check != null && md5Check.equalsIgnoreCase(this.getTransHash());
    }
}

