/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.File;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class URIConverter
implements Converter {
    public static final URIConverter INSTANCE = new URIConverter();

    URIConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return URI.class.equals(cls);
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof String) {
            if (value instanceof File) {
                return ((File)value).toURI();
            }
            if (value instanceof URL) {
                return ((URL)value).toURI();
            }
            return new URI(value.toString().trim());
        }
        if (value != null) {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
        }
        return null;
    }
}

