/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.util.List;
import java.util.RandomAccess;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class ListFormatter
implements Formatter {
    public static final ListFormatter INSTANCE = new ListFormatter();

    ListFormatter() {
    }

    public boolean accept(Object o) {
        return o instanceof List && o instanceof RandomAccess;
    }

    public boolean isStruct() {
        return true;
    }

    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        int count;
        List list = (List)o;
        JSONHint hint = context.getHint();
        int length = list.size();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('[');
        for (count = 0; count < length; ++count) {
            Object item = list.get(count);
            if (item == src) {
                item = null;
            }
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                context.appendIndent(out, context.getDepth() + 1);
            }
            context.enter(count, hint);
            item = context.preformatInternal(item != null ? item.getClass() : Object.class, item);
            if (item == null) {
                NullFormatter.INSTANCE.format(context, src, item, out);
            } else if (hint == null) {
                if (item.getClass() == lastClass) {
                    lastFormatter.format(context, src, item, out);
                } else {
                    lastFormatter = context.formatInternal(item, out);
                    lastClass = item.getClass();
                }
            } else {
                context.formatInternal(item, out);
            }
            context.exit();
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            context.appendIndent(out, context.getDepth());
        }
        out.append(']');
    }
}

