/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.ExtendedDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCache {
    private static final int CACHE_SIZE = 256;
    private ResourceBundle resources;
    private Locale locale;
    private TimeZone timeZone;
    private StringBuilder builderCache;
    private int stringCacheCount = 0;
    private String[] stringCache;
    private Map<String, DateFormat> dateFormatCache;
    private Map<String, NumberFormat> numberFormatCache;
    private Map<ParameterTypeKey, Type> parameterTypeCache;

    public LocalCache(String bundle, Locale locale, TimeZone timeZone) {
        this.resources = ResourceBundle.getBundle(bundle, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public StringBuilder getCachedBuffer() {
        if (this.builderCache == null) {
            this.builderCache = new StringBuilder();
        } else {
            this.builderCache.setLength(0);
        }
        return this.builderCache;
    }

    public String getString(CharSequence cs) {
        if (cs.length() == 0) {
            return "";
        }
        if (cs.length() < 32 && this.stringCacheCount++ > 16) {
            String str;
            int index = this.getCacheIndex(cs);
            if (index < 0) {
                return cs.toString();
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if ((str = this.stringCache[index]) == null || str.length() != cs.length()) {
                this.stringCache[index] = str = cs.toString();
                return str;
            }
            for (int i = 0; i < cs.length(); ++i) {
                if (str.charAt(i) == cs.charAt(i)) continue;
                this.stringCache[index] = str = cs.toString();
                return str;
            }
            return str;
        }
        return cs.toString();
    }

    private int getCacheIndex(CharSequence cs) {
        int h = 0;
        int max = Math.min(16, cs.length());
        for (int i = 0; i < max; ++i) {
            h = h * 31 + cs.charAt(i);
        }
        return h & 0xFF;
    }

    public NumberFormat getNumberFormat(String format) {
        NumberFormat nformat = null;
        if (this.numberFormatCache == null) {
            this.numberFormatCache = new HashMap<String, NumberFormat>();
        } else {
            nformat = this.numberFormatCache.get(format);
        }
        if (nformat == null) {
            nformat = new DecimalFormat(format, new DecimalFormatSymbols(this.locale));
            this.numberFormatCache.put(format, nformat);
        }
        return nformat;
    }

    public DateFormat getDateFormat(String format) {
        DateFormat dformat = null;
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, DateFormat>();
        } else {
            dformat = this.dateFormatCache.get(format);
        }
        if (dformat == null) {
            dformat = new ExtendedDateFormat(format, this.locale);
            dformat.setTimeZone(this.timeZone);
            this.dateFormatCache.put(format, dformat);
        }
        return dformat;
    }

    public Type getParameterType(Type t, Class<?> cls, int pos) {
        ParameterTypeKey key = new ParameterTypeKey(t, cls, pos);
        Type result = null;
        if (this.parameterTypeCache == null) {
            this.parameterTypeCache = new HashMap<ParameterTypeKey, Type>();
        } else {
            result = this.parameterTypeCache.get(key);
        }
        if (result == null) {
            result = ClassUtil.getParameterType(t, cls, pos);
            this.parameterTypeCache.put(key, result);
        }
        return result;
    }

    public String getMessage(String id) {
        return this.getMessage(id, null);
    }

    public String getMessage(String id, Object ... args) {
        if (args != null && args.length > 0) {
            return MessageFormat.format(this.resources.getString(id), args);
        }
        return this.resources.getString(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterTypeKey {
        private Type t;
        private Class<?> cls;
        private int pos;

        public ParameterTypeKey(Type t, Class<?> cls, int pos) {
            this.t = t;
            this.cls = cls;
            this.pos = pos;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + this.pos;
            result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterTypeKey other = (ParameterTypeKey)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            if (this.pos != other.pos) {
                return false;
            }
            return !(this.t == null ? other.t != null : !this.t.equals(other.t));
        }
    }
}

