/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.parse;

import java.io.IOException;
import net.arnx.jsonic.JSONEventType;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.parse.JSONParser;
import net.arnx.jsonic.util.LocalCache;

public class ScriptParser
extends JSONParser {
    private InputSource in;

    public ScriptParser(InputSource in, int maxDepth, boolean interpretterMode, boolean ignoreWhirespace, LocalCache cache) {
        super(in, maxDepth, interpretterMode, ignoreWhirespace, cache);
        this.in = in;
    }

    int beforeRoot() throws IOException {
        int n = this.in.next();
        if (n == 65279) {
            n = this.in.next();
        }
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 0;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 0;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case 34: 
            case 39: {
                this.in.back();
                this.set(JSONEventType.STRING, this.parseString(true), true);
                return 1;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                this.set(JSONEventType.NUMBER, this.parseNumber(), true);
                return 1;
            }
            case 116: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("true", Boolean.TRUE), true);
                return 1;
            }
            case 102: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("false", Boolean.FALSE), true);
                return 1;
            }
            case 110: {
                this.in.back();
                this.set(JSONEventType.NULL, this.parseLiteral("null", null), true);
                return 1;
            }
            case -1: {
                if (this.isInterpretterMode()) {
                    return -1;
                }
                throw this.createParseException(this.in, "json.parse.EmptyInputError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterRoot() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 1;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 1;
            }
            case -1: {
                return -1;
            }
            case 34: 
            case 39: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 91: 
            case 102: 
            case 110: 
            case 116: 
            case 123: {
                if (!this.isInterpretterMode()) break;
                this.in.back();
                return 0;
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int beforeName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 2;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 2;
            }
            case 34: 
            case 39: {
                this.in.back();
                this.set(JSONEventType.NAME, this.parseString(true), false);
                return 3;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                Object num = this.parseNumber();
                this.set(JSONEventType.NAME, num != null ? num.toString() : null, false);
                return 3;
            }
            case 125: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        this.in.back();
        this.set(JSONEventType.NAME, this.parseLiteral(false), false);
        return 3;
    }

    int afterName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 3;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 3;
            }
            case 58: {
                return 4;
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int beforeValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 4;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 4;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case 34: 
            case 39: {
                this.in.back();
                this.set(JSONEventType.STRING, this.parseString(true), true);
                return 5;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                this.set(JSONEventType.NUMBER, this.parseNumber(), true);
                return 5;
            }
            case 116: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("true", Boolean.TRUE), true);
                return 5;
            }
            case 102: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("false", Boolean.FALSE), true);
                return 5;
            }
            case 110: {
                this.in.back();
                this.set(JSONEventType.NULL, this.parseLiteral("null", null), true);
                return 5;
            }
            case 93: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 5;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 5;
            }
            case 44: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    return 2;
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    return 4;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 125: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 93: {
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }
}

