/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

public abstract class NamingStyle {
    public static final NamingStyle NOOP = new NamingStyle("NOOP"){

        @Override
        public String to(String value) {
            return value;
        }
    };
    public static final NamingStyle LOWER_CASE = new NamingStyle("LOWER_CASE"){

        @Override
        public String to(String value) {
            return NamingStyle.toSimpleCase(value, false);
        }
    };
    public static final NamingStyle LOWER_CAMEL = new NamingStyle("LOWER_CAMEL"){

        @Override
        public String to(String value) {
            return NamingStyle.toCamelCase(value, false);
        }
    };
    public static final NamingStyle LOWER_SPACE = new NamingStyle("LOWER_SPACE"){

        @Override
        public String to(String value) {
            return NamingStyle.toSeparatedCase(value, false, ' ');
        }
    };
    public static final NamingStyle LOWER_HYPHEN = new NamingStyle("LOWER_HYPHEN"){

        @Override
        public String to(String value) {
            return NamingStyle.toSeparatedCase(value, false, '-');
        }
    };
    public static final NamingStyle LOWER_UNDERSCORE = new NamingStyle("LOWER_UNDERSCORE"){

        @Override
        public String to(String value) {
            return NamingStyle.toSeparatedCase(value, false, '_');
        }
    };
    public static final NamingStyle UPPER_CASE = new NamingStyle("UPPER_CASE"){

        @Override
        public String to(String value) {
            return NamingStyle.toSimpleCase(value, true);
        }
    };
    public static final NamingStyle UPPER_CAMEL = new NamingStyle("UPPER_CAMEL"){

        @Override
        public String to(String value) {
            return NamingStyle.toCamelCase(value, true);
        }
    };
    public static final NamingStyle UPPER_SPACE = new NamingStyle("UPPER_SPACE"){

        @Override
        public String to(String value) {
            return NamingStyle.toSeparatedCase(value, true, ' ');
        }
    };
    public static final NamingStyle UPPER_HYPHEN = new NamingStyle("UPPER_HYPHEN"){

        @Override
        public String to(String value) {
            return NamingStyle.toSeparatedCase(value, true, '-');
        }
    };
    public static final NamingStyle UPPER_UNDERSCORE = new NamingStyle("UPPER_UNDERSCORE"){

        @Override
        public String to(String value) {
            return NamingStyle.toSeparatedCase(value, true, '_');
        }
    };
    private String name;
    private static final int SEPARATOR = 1;
    private static final int LOWER = 2;
    private static final int UPPER = 3;
    private static final int NUMBER = 4;
    private static final int OTHER = 9;
    private static final int[] MAP = new int[128];

    public NamingStyle(String name) {
        this.name = name;
    }

    public abstract String to(String var1);

    public String toString() {
        return this.name;
    }

    private static String toSimpleCase(String value, boolean upper) {
        if (value == null || value.length() == 0) {
            return value;
        }
        char[] ca = value.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            int type = NamingStyle.getType(ca[i]);
            if (upper && type == 2) {
                ca[i] = (char)(ca[i] - 32);
                continue;
            }
            if (upper || type != 3) continue;
            ca[i] = (char)(ca[i] + 32);
        }
        return String.valueOf(ca);
    }

    private static String toCamelCase(String value, boolean upper) {
        int i;
        int end;
        int type;
        int start;
        if (value == null || value.length() == 0) {
            return value;
        }
        for (start = 0; start < value.length() && ((type = NamingStyle.getType(value.charAt(start))) == 1 || type == 9); ++start) {
        }
        for (end = 0; end < value.length() - start && ((type = NamingStyle.getType(value.charAt(value.length() - end - 1))) == 1 || type == 9); ++end) {
        }
        int index = -1;
        for (int i2 = start; i2 < value.length() - end; ++i2) {
            if (NamingStyle.getType(value.charAt(i2)) != 1) continue;
            index = i2;
            break;
        }
        if (index == -1) {
            int type2 = NamingStyle.getType(value.charAt(start));
            if (type2 == 3) {
                int next;
                char[] ca = value.toCharArray();
                if (!upper) {
                    ca[start] = (char)(ca[start] + 32);
                }
                for (int i3 = start + 1; i3 < ca.length - end && NamingStyle.getType(ca[i3]) == 3 && (i3 + 1 >= ca.length - end || (next = NamingStyle.getType(ca[i3 + 1])) == 3 || next == 4); ++i3) {
                    ca[i3] = (char)(ca[i3] + 32);
                }
                return String.valueOf(ca);
            }
            if (upper && type2 == 2) {
                char[] ca = value.toCharArray();
                ca[start] = (char)(ca[start] - 32);
                return String.valueOf(ca);
            }
            return value;
        }
        char[] ca = value.toCharArray();
        int pos = start;
        for (i = start; i < ca.length - end; ++i) {
            if (NamingStyle.getType(ca[i]) == 1) {
                upper = true;
                continue;
            }
            if (upper) {
                ca[pos++] = NamingStyle.getType(ca[i]) == 2 ? (char)(ca[i] - 32) : ca[i];
                upper = false;
                continue;
            }
            ca[pos++] = NamingStyle.getType(ca[i]) == 3 ? (char)(ca[i] + 32) : ca[i];
            upper = false;
        }
        for (i = 0; i < end; ++i) {
            ca[pos++] = ca[ca.length - end];
        }
        return String.valueOf(ca, 0, pos);
    }

    private static String toSeparatedCase(String value, boolean upper, char sep) {
        int end;
        int type;
        int start;
        if (value == null || value.length() == 0) {
            return value;
        }
        for (start = 0; start < value.length() && ((type = NamingStyle.getType(value.charAt(start))) == 1 || type == 9); ++start) {
        }
        for (end = 0; end < value.length() - start && ((type = NamingStyle.getType(value.charAt(value.length() - end - 1))) == 1 || type == 9); ++end) {
        }
        StringBuilder sb = new StringBuilder((int)((double)value.length() * 1.5));
        if (start > 0) {
            sb.append(value, 0, start);
        }
        int prev = -1;
        for (int i = start; i < value.length() - end; ++i) {
            char c = value.charAt(i);
            int type2 = NamingStyle.getType(c);
            if (type2 == 3 && prev != -1) {
                int next;
                if (prev != 3 && prev != 1) {
                    sb.append(sep);
                } else if (i + 1 < value.length() - end && (next = NamingStyle.getType(value.charAt(i + 1))) != 3 && next != 4 && next != 1) {
                    sb.append(sep);
                }
            }
            if (type2 == 1) {
                if (prev != 1) {
                    sb.append(sep);
                }
            } else if (upper && type2 == 2) {
                sb.append((char)(c - 32));
            } else if (!upper && type2 == 3) {
                sb.append((char)(c + 32));
            } else {
                sb.append(c);
            }
            prev = type2;
        }
        if (end > 0) {
            sb.append(value, value.length() - end, value.length());
        }
        return sb.toString();
    }

    private static int getType(char c) {
        return c < MAP.length ? MAP[c] : 0;
    }

    static {
        for (int i = 0; i < MAP.length; ++i) {
            NamingStyle.MAP[i] = i >= 65 && i <= 90 ? 3 : (i >= 97 && i <= 122 ? 2 : (i >= 48 && i <= 57 ? 4 : (i == 32 || i == 43 || i == 44 || i == 45 || i == 46 || i == 95 ? 1 : 9)));
        }
    }
}

