/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DateTimeFormatterProvider;
import net.arnx.jsonic.JSON;

final class InstantConverter
implements Converter {
    @Override
    public boolean accept(Class<?> cls) {
        return Instant.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Instant.ofEpochMilli(((Number)value).longValue());
        }
        if (value instanceof String) {
            String format = context.getDateFormatText();
            if (format != null) {
                TemporalAccessor temp = context.getLocalCache().get(DateTimeFormatter.class, format, DateTimeFormatterProvider.INSTANCE).parseBest((String)value, new TemporalQuery<ZonedDateTime>(){

                    @Override
                    public ZonedDateTime queryFrom(TemporalAccessor temporal) {
                        return ZonedDateTime.from(temporal);
                    }
                }, new TemporalQuery<OffsetDateTime>(){

                    @Override
                    public OffsetDateTime queryFrom(TemporalAccessor temporal) {
                        return OffsetDateTime.from(temporal);
                    }
                }, new TemporalQuery<LocalDateTime>(){

                    @Override
                    public LocalDateTime queryFrom(TemporalAccessor temporal) {
                        return LocalDateTime.from(temporal);
                    }
                }, new TemporalQuery<LocalDate>(){

                    @Override
                    public LocalDate queryFrom(TemporalAccessor temporal) {
                        return LocalDate.from(temporal);
                    }
                });
                if (temp instanceof ZonedDateTime) {
                    return ((ZonedDateTime)temp).toInstant();
                }
                if (temp instanceof OffsetDateTime) {
                    return ((OffsetDateTime)temp).toInstant();
                }
                if (temp instanceof LocalDateTime) {
                    return ((LocalDateTime)temp).atZone(context.getTimeZone().toZoneId()).toInstant();
                }
                if (temp instanceof LocalDate) {
                    return ((LocalDate)temp).atStartOfDay(context.getTimeZone().toZoneId()).toInstant();
                }
                return (Instant)temp;
            }
            return Instant.parse((String)value);
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

