/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.abstraction.MockUnit;

public final class MockUnitUtils {
    private MockUnitUtils() {
    }

    public static <T> void add(Class<? extends Collection> collectionClass, Collection<T> result, Supplier<T> supplier) {
        T value = supplier.get();
        try {
            result.add(value);
        }
        catch (Exception e) {
            String msg = AlephFormatter.str((String)"Cannot add value '#{val}' to collection '#{cls.simpleName}'").arg("val", value).arg("cls", collectionClass).fmt();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T> void add(Class<? extends List> listClass, List<T> result, Supplier<T> supplier) {
        T value = supplier.get();
        try {
            result.add(value);
        }
        catch (Exception e) {
            String msg = AlephFormatter.str((String)"Cannot add value '#{value}' to '#{cls.simpleName}'.").args(new Object[]{"value", value, "cls", listClass}).fmt();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T> void add(Class<? extends Set> setClass, Set<T> result, Supplier<T> supplier) {
        T value = supplier.get();
        try {
            result.add(value);
        }
        catch (Exception e) {
            String msg = AlephFormatter.str((String)"Cannot add value '#{value}' to '#{cls.simpleName}'.").args(new Object[]{"value", value, "cls", setClass}).fmt();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T, R> void put(Class<? extends Map> mapClass, Map<T, R> map, Supplier<T> keySupplier, Supplier<R> valueSupplier) {
        T keyVal = keySupplier.get();
        R valVal = valueSupplier.get();
        try {
            map.put(keyVal, valVal);
        }
        catch (Exception e) {
            String msg = AlephFormatter.str((String)"Cannot put values '{#{key}:#{val}}' to '#{cls.simpleName}'.").args(new Object[]{"key", keyVal, "val", valVal, "cls", mapClass.getSimpleName()}).fmt();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T, R> void put(Class<? extends Map> mapClass, Map<T, R> map, T key, R value) {
        try {
            map.put(key, value);
        }
        catch (Exception e) {
            String msg = AlephFormatter.str((String)"Cannot put values '{#{key}:#{val}}' to '#{cls.simpleName}'.").args(new Object[]{"key", key, "val", value, "cls", mapClass.getSimpleName()}).fmt();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static Object mockOrObject(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof MockUnit) {
            return ((MockUnit)obj).val();
        }
        return obj;
    }

    public static String listTypes(Object[] objects) {
        StringBuilder buff = new StringBuilder("(");
        Arrays.stream(objects).forEach(obj -> {
            if (null != obj) {
                buff.append(obj.getClass().getName());
            } else {
                buff.append("null");
            }
            buff.append(',');
        });
        buff.deleteCharAt(buff.length() - 1);
        buff.append(')');
        return buff.toString();
    }

    public static <T, R> Supplier<R> ifSupplierNotNullDo(Supplier<T> supplier, Function<T, R> function) {
        return () -> {
            Object val = supplier.get();
            if (null == val) {
                return null;
            }
            return function.apply(val);
        };
    }
}

