/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.WordsType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Words
extends MockUnitBase
implements MockUnitString {
    private final MockUnitString adjectives1syll;
    private final MockUnitString adjectives2syll;
    private final MockUnitString adjectives3syll;
    private final MockUnitString adjectives4syll;
    private final List<MockUnitString> adjectives;
    private final MockUnitString adverbs1syll;
    private final MockUnitString adverbs2syll;
    private final MockUnitString adverbs3syll;
    private final MockUnitString adverbs4syll;
    private final List<MockUnitString> adverbs;
    private final MockUnitString nouns1syll;
    private final MockUnitString nouns2syll;
    private final MockUnitString nouns3syll;
    private final MockUnitString nouns4syll;
    private final List<MockUnitString> nouns;
    private final MockUnitString verbs1syll;
    private final MockUnitString verbs2syll;
    private final MockUnitString verbs3syll;
    private final MockUnitString verbs4syll;
    private final List<MockUnitString> verbs;
    private final Map<WordsType, MockUnitString> typesMapping;
    private final List<MockUnitString> all;

    public static Words words() {
        return MockNeat.threadLocal().words();
    }

    protected Words() {
        this(MockNeat.threadLocal());
    }

    public Words(MockNeat mockNeat) {
        super(mockNeat);
        this.adjectives1syll = this.mockNeat.dicts().type(DictType.EN_ADJECTIVE_1SYLL);
        this.adjectives2syll = this.mockNeat.dicts().type(DictType.EN_ADJECTIVE_2SYLL);
        this.adjectives3syll = this.mockNeat.dicts().type(DictType.EN_ADJECTIVE_3SYLL);
        this.adjectives4syll = this.mockNeat.dicts().type(DictType.EN_ADJECTIVE_4SYLL);
        this.adjectives = Collections.unmodifiableList(Arrays.asList(this.adjectives1syll, this.adjectives2syll, this.adjectives3syll, this.adjectives4syll));
        this.adverbs1syll = this.mockNeat.dicts().type(DictType.EN_ADVERB_1SYLL);
        this.adverbs2syll = this.mockNeat.dicts().type(DictType.EN_ADVERB_2SYLL);
        this.adverbs3syll = this.mockNeat.dicts().type(DictType.EN_ADVERB_3SYLL);
        this.adverbs4syll = this.mockNeat.dicts().type(DictType.EN_ADVERB_4SYLL);
        this.adverbs = Collections.unmodifiableList(Arrays.asList(this.adverbs1syll, this.adverbs2syll, this.adverbs3syll, this.adverbs4syll));
        this.nouns1syll = this.mockNeat.dicts().type(DictType.EN_NOUN_1SYLL);
        this.nouns2syll = this.mockNeat.dicts().type(DictType.EN_NOUN_2SYLL);
        this.nouns3syll = this.mockNeat.dicts().type(DictType.EN_NOUN_3SYLL);
        this.nouns4syll = this.mockNeat.dicts().type(DictType.EN_NOUN_4SYLL);
        this.nouns = Collections.unmodifiableList(Arrays.asList(this.nouns1syll, this.nouns2syll, this.nouns3syll, this.nouns4syll));
        this.verbs1syll = this.mockNeat.dicts().type(DictType.EN_VERB_1SYLL);
        this.verbs2syll = this.mockNeat.dicts().type(DictType.EN_VERB_2SYLL);
        this.verbs3syll = this.mockNeat.dicts().type(DictType.EN_VERB_3SYLL);
        this.verbs4syll = this.mockNeat.dicts().type(DictType.EN_VERB_4SYLL);
        this.verbs = Collections.unmodifiableList(Arrays.asList(this.verbs1syll, this.verbs2syll, this.verbs3syll, this.verbs4syll));
        this.typesMapping = new ConcurrentHashMap<WordsType, MockUnitString>();
        ArrayList<MockUnitString> allWords = new ArrayList<MockUnitString>();
        allWords.addAll(this.adjectives);
        allWords.addAll(this.adverbs);
        allWords.addAll(this.nouns);
        allWords.addAll(this.verbs);
        this.all = Collections.unmodifiableList(allWords);
        this.typesMapping.put(WordsType.ADJECTIVES, this.adjectives());
        this.typesMapping.put(WordsType.ADJECTIVES_1SYLL, this.adjectives1syll());
        this.typesMapping.put(WordsType.ADJECTIVES_2SYLL, this.adjectives2syll());
        this.typesMapping.put(WordsType.ADJECTIVES_3SYLL, this.adjectives3syll());
        this.typesMapping.put(WordsType.ADJECTIVES_4SYLL, this.adjectives4syll());
        this.typesMapping.put(WordsType.ADVERBS, this.adverbs());
        this.typesMapping.put(WordsType.ADVERBS_1SYLL, this.adverbs1syll());
        this.typesMapping.put(WordsType.ADVERBS_2SYLL, this.adverbs2syll());
        this.typesMapping.put(WordsType.ADVERBS_3SYLL, this.adverbs3syll());
        this.typesMapping.put(WordsType.ADVERBS_4SYLL, this.adverbs4syll());
        this.typesMapping.put(WordsType.NOUNS, this.nouns());
        this.typesMapping.put(WordsType.NOUNS_1SYL, this.nouns1syll());
        this.typesMapping.put(WordsType.NOUNS_2SYL, this.nouns2syll());
        this.typesMapping.put(WordsType.NOUNS_3SYL, this.nouns3syll());
        this.typesMapping.put(WordsType.NOUNS_4SYL, this.nouns4syll());
        this.typesMapping.put(WordsType.VERBS, this.verbs());
        this.typesMapping.put(WordsType.VERBS_1SYLL, this.verbs1syll());
        this.typesMapping.put(WordsType.VERBS_2SYLL, this.verbs2syll());
        this.typesMapping.put(WordsType.VERBS_3SYLL, this.verbs3syll());
        this.typesMapping.put(WordsType.VERBS_4SYLL, this.verbs4syll());
    }

    @Override
    public Supplier<String> supplier() {
        return this.mockNeat.from(this.all).val().supplier();
    }

    public MockUnitString type(WordsType type) {
        ValidationUtils.notNull(type, "type");
        return this.typesMapping.get((Object)type);
    }

    public MockUnitString types(WordsType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            WordsType type = this.mockNeat.from(types).get();
            return this.typesMapping.get((Object)type).supplier();
        };
    }

    public MockUnitString adjectives() {
        return () -> this.mockNeat.from(this.adjectives).val().supplier();
    }

    public MockUnitString adjectives1syll() {
        return this.adjectives1syll;
    }

    public MockUnitString adjectives2syll() {
        return this.adjectives2syll;
    }

    public MockUnitString adjectives3syll() {
        return this.adjectives3syll;
    }

    public MockUnitString adjectives4syll() {
        return this.adjectives4syll;
    }

    public MockUnitString adverbs() {
        return () -> this.mockNeat.from(this.adverbs).val().supplier();
    }

    public MockUnitString adverbs1syll() {
        return this.adverbs1syll;
    }

    public MockUnitString adverbs2syll() {
        return this.adverbs2syll;
    }

    public MockUnitString adverbs3syll() {
        return this.adverbs3syll;
    }

    public MockUnitString adverbs4syll() {
        return this.adverbs4syll;
    }

    public MockUnitString nouns() {
        return () -> this.mockNeat.from(this.nouns).val().supplier();
    }

    public MockUnitString nouns1syll() {
        return this.nouns1syll;
    }

    public MockUnitString nouns2syll() {
        return this.nouns2syll;
    }

    public MockUnitString nouns3syll() {
        return this.nouns3syll;
    }

    public MockUnitString nouns4syll() {
        return this.nouns4syll;
    }

    public MockUnitString verbs() {
        return () -> this.mockNeat.from(this.verbs).val().supplier();
    }

    public MockUnitString verbs1syll() {
        return this.verbs1syll;
    }

    public MockUnitString verbs2syll() {
        return this.verbs2syll;
    }

    public MockUnitString verbs3syll() {
        return this.verbs3syll;
    }

    public MockUnitString verbs4syll() {
        return this.verbs4syll;
    }
}

